/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.resources;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.Repository;
import org.apache.chemistry.opencmis.client.api.SecondaryType;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.runtime.SessionFactoryImpl;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConnectionException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.commons.lang.BooleanUtils;
import org.fao.geonet.domain.MetadataResourceExternalManagementProperties;
import org.fao.geonet.utils.Log;
import org.springframework.util.StringUtils;

public class CMISConfiguration {
    private Session client = null;
    public static final Integer CMIS_MAX_ITEMS_PER_PAGE = 1000;
    public static final String CMIS_FOLDER_DELIMITER = "/";
    public static final String CMIS_SECONDARY_PROPERTY_SEPARATOR = "->";
    private final String CMIS_DEFAULT_WEBSERVICES_ACL_SERVICE = "/services/ACLService?wsdl";
    private final String CMIS_DEFAULT_WEBSERVICES_DISCOVERY_SERVICE = "/services/DiscoveryService?wsdl";
    private final String CMIS_DEFAULT_WEBSERVICES_MULTIFILING_SERVICE = "/services/MultiFilingService?wsdl";
    private final String CMIS_DEFAULT_WEBSERVICES_NAVIGATION_SERVICE = "/services/NavigationService?wsdl";
    private final String CMIS_DEFAULT_WEBSERVICES_OBJECT_SERVICE = "/services/ObjectService?wsdl";
    private final String CMIS_DEFAULT_WEBSERVICES_POLICY_SERVICE = "/services/PolicyService?wsdl";
    private final String CMIS_DEFAULT_WEBSERVICES_RELATIONSHIP_SERVICE = "/services/RelationshipService?wsdl";
    private final String CMIS_DEFAULT_WEBSERVICES_REPOSITORY_SERVICE = "/services/RepositoryService?wsdl";
    private final String CMIS_DEFAULT_WEBSERVICES_VERSIONING_SERVICE = "/services/VersioningService?wsdl";
    private final String CMIS_DEFAULT_WEBSERVICES_BASE_URL_SERVICE = "/cmis";
    private final String CMIS_DEFAULT_BROWSER_URL_SERVICE = "/browser";
    private final String CMIS_DEFAULT_ATOMPUB_URL_SERVICE = "/atom";
    private final String CMIS_DEFAULT_EXTERNAL_RESOURCE_MANAGEMENT_WINDOW_PARAMETERS = "toolbar=0,width=600,height=600";
    private final Boolean CMIS_DEFAULT_EXTERNAL_RESOURCE_MANAGEMENT_MODAL_ENABLED = true;
    private final Boolean CMIS_DEFAULT_EXTERNAL_RESOURCE_MANAGEMENT_FOLDER_ENABLED = true;
    private final Boolean CMIS_DEFAULT_VERSIONING_ENABLED = false;
    private String servicesBaseUrl;
    private String bindingType;
    private String baseRepositoryPath;
    private String username;
    private String password;
    private String repositoryId;
    private String repositoryName;
    private String cmisMetadataUUIDPropertyName;
    private String parsedCmisMetadataUUIDPropertyName = null;
    private boolean cmisMetadataUUIDSecondaryProperty = false;
    private String externalResourceManagementUrl;
    private String externalResourceManagementWindowParameters;
    private Boolean externalResourceManagementModalEnabled;
    private Boolean externalResourceManagementFolderEnabled;
    private String externalResourceManagementFolderRoot;
    private String externalResourceManagementValidationStatusPropertyName;
    private String parsedExternalResourceManagementValidationStatusPropertyName = null;
    private String externalResourceManagementValidationStatusDefaultValue;
    private boolean externalResourceManagementValidationStatusSecondaryProperty = false;
    private MetadataResourceExternalManagementProperties.ValidationStatus defaultStatus = null;
    private Boolean versioningEnabled;
    private VersioningState versioningState;
    private Boolean versioningMajorOnUpdate;
    private String webservicesRepositoryService;
    private String webservicesNavigationService;
    private String webservicesObjectService;
    private String webservicesVersioningService;
    private String webservicesDiscoveryService;
    private String webservicesRelationshipService;
    private String webservicesMultifilingService;
    private String webservicesPolicyService;
    private String webservicesAclService;
    private String webservicesMemoryThreshold;
    private String webservicesBaseUrl;
    private String browserUrl;
    private String atompubUrl;

    @Nonnull
    public String getServicesBaseUrl() {
        return this.servicesBaseUrl;
    }

    public void setServicesBaseUrl(String servicesBaseUrl) {
        this.servicesBaseUrl = servicesBaseUrl;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Nonnull
    public String getBindingType() {
        return this.bindingType;
    }

    public void setBindingType(String bindingTypeString) {
        this.bindingType = org.apache.commons.lang.StringUtils.isEmpty((String)bindingTypeString) ? null : BindingType.fromValue((String)bindingTypeString).value();
    }

    @Nonnull
    private BindingType getBindingTypeObject() {
        return BindingType.fromValue((String)this.bindingType);
    }

    private void setBindingTypeObject(BindingType bindingType) {
        this.bindingType = bindingType.value();
    }

    public String getBaseRepositoryPath() {
        return this.baseRepositoryPath;
    }

    public void setBaseRepositoryPath(String baseRepositoryPath) {
        this.baseRepositoryPath = baseRepositoryPath;
    }

    @Nonnull
    public String getRepositoryId() {
        return this.repositoryId;
    }

    public void setRepositoryId(String repositoryId) {
        this.repositoryId = repositoryId;
    }

    @Nonnull
    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    @Nonnull
    public String getExternalResourceManagementUrl() {
        return this.externalResourceManagementUrl;
    }

    public void setExternalResourceManagementUrl(String externalResourceManagementUrl) {
        this.externalResourceManagementUrl = externalResourceManagementUrl;
    }

    @Nonnull
    public String getExternalResourceManagementWindowParameters() {
        if (this.externalResourceManagementWindowParameters == null) {
            return "toolbar=0,width=600,height=600";
        }
        return this.externalResourceManagementWindowParameters;
    }

    public void setExternalResourceManagementWindowParameters(String externalResourceManagementWindowParameters) {
        this.externalResourceManagementWindowParameters = externalResourceManagementWindowParameters;
    }

    @Nonnull
    public Boolean isExternalResourceManagementModalEnabled() {
        if (this.externalResourceManagementModalEnabled == null) {
            return this.CMIS_DEFAULT_EXTERNAL_RESOURCE_MANAGEMENT_MODAL_ENABLED;
        }
        return this.externalResourceManagementModalEnabled;
    }

    public void setExternalResourceManagementModalEnabled(Boolean externalResourceManagementModalEnabled) {
        this.externalResourceManagementModalEnabled = externalResourceManagementModalEnabled;
    }

    public void setExternalResourceManagementModalEnabled(String externalResourceManagementModalEnabled) {
        this.externalResourceManagementModalEnabled = BooleanUtils.toBooleanObject((String)externalResourceManagementModalEnabled);
    }

    public Boolean isExternalResourceManagementFolderEnabled() {
        if (this.externalResourceManagementFolderEnabled == null) {
            return this.CMIS_DEFAULT_EXTERNAL_RESOURCE_MANAGEMENT_FOLDER_ENABLED;
        }
        return this.externalResourceManagementFolderEnabled;
    }

    public void setExternalResourceManagementFolderEnabled(Boolean externalResourceManagementFolderEnabled) {
        this.externalResourceManagementFolderEnabled = externalResourceManagementFolderEnabled;
    }

    public String getExternalResourceManagementFolderRoot() {
        return this.externalResourceManagementFolderRoot;
    }

    public void setExternalResourceManagementFolderRoot(String externalResourceManagementFolderRoot) {
        String folderRoot = externalResourceManagementFolderRoot;
        if (folderRoot != null) {
            if (!folderRoot.startsWith(this.getFolderDelimiter())) {
                folderRoot = this.getFolderDelimiter() + folderRoot;
            }
            if (folderRoot.endsWith(this.getFolderDelimiter())) {
                folderRoot = folderRoot.substring(0, folderRoot.length() - 1);
            }
        }
        this.externalResourceManagementFolderRoot = folderRoot;
    }

    public String getExternalResourceManagementValidationStatusDefaultValue() {
        return this.externalResourceManagementValidationStatusDefaultValue;
    }

    public void setExternalResourceManagementValidationStatusDefaultValue(String externalResourceManagementValidationStatusDefaultValue) {
        this.externalResourceManagementValidationStatusDefaultValue = externalResourceManagementValidationStatusDefaultValue;
    }

    @Nonnull
    public VersioningState getVersioningState() {
        if (this.versioningState == null) {
            return VersioningState.MAJOR;
        }
        return this.versioningState;
    }

    public void setVersioningState(VersioningState versioningState) {
        if (versioningState != null && versioningState.equals((Object)VersioningState.CHECKEDOUT)) {
            throw new IllegalArgumentException("Versioning state CHECKEDOUT is not supported in this context");
        }
        this.versioningState = versioningState;
    }

    public void setVersioningState(String versioningState) {
        this.setVersioningState(org.apache.commons.lang.StringUtils.isEmpty((String)versioningState) ? null : VersioningState.valueOf((String)versioningState.toUpperCase()));
    }

    @Nonnull
    public Boolean isVersioningMajorOnUpdate() {
        if (this.versioningMajorOnUpdate == null) {
            return false;
        }
        return this.versioningMajorOnUpdate;
    }

    public void setVersioningMajorOnUpdate(Boolean versioningMajorOnUpdate) {
        this.versioningMajorOnUpdate = versioningMajorOnUpdate;
    }

    public void setVersioningMajorOnUpdate(String versioningMajorOnUpdate) {
        this.versioningMajorOnUpdate = BooleanUtils.toBooleanObject((String)versioningMajorOnUpdate);
    }

    @Nonnull
    public Boolean isVersioningEnabled() {
        if (this.versioningEnabled == null) {
            return this.CMIS_DEFAULT_VERSIONING_ENABLED;
        }
        return this.versioningEnabled;
    }

    public void setVersioningEnabled(Boolean versioningEnabled) {
        this.versioningEnabled = versioningEnabled;
    }

    public void setVersioningEnabled(String versioningEnabled) {
        this.versioningEnabled = BooleanUtils.toBooleanObject((String)versioningEnabled);
    }

    @Nonnull
    public String getWebservicesRepositoryService() {
        return this.getServiceUrl(this.getWebservicesBaseUrl(), this.webservicesRepositoryService, "/services/RepositoryService?wsdl");
    }

    public void setWebservicesRepositoryService(String webservicesRepositoryService) {
        this.webservicesRepositoryService = webservicesRepositoryService;
    }

    @Nonnull
    public String getWebservicesNavigationService() {
        return this.getServiceUrl(this.getWebservicesBaseUrl(), this.webservicesNavigationService, "/services/NavigationService?wsdl");
    }

    public void setWebservicesNavigationService(String webservicesNavigationService) {
        this.webservicesNavigationService = webservicesNavigationService;
    }

    @Nonnull
    public String getWebservicesObjectService() {
        return this.getServiceUrl(this.getWebservicesBaseUrl(), this.webservicesObjectService, "/services/ObjectService?wsdl");
    }

    public void setWebservicesObjectService(String webservicesObjectService) {
        this.webservicesObjectService = webservicesObjectService;
    }

    @Nonnull
    public String getWebservicesVersioningService() {
        return this.getServiceUrl(this.getWebservicesBaseUrl(), this.webservicesVersioningService, "/services/VersioningService?wsdl");
    }

    public void setWebservicesVersioningService(String webservicesVersioningService) {
        this.webservicesVersioningService = webservicesVersioningService;
    }

    @Nonnull
    public String getWebservicesDiscoveryService() {
        return this.getServiceUrl(this.getWebservicesBaseUrl(), this.webservicesDiscoveryService, "/services/DiscoveryService?wsdl");
    }

    public void setWebservicesDiscoveryService(String webservicesDiscoveryService) {
        this.webservicesDiscoveryService = webservicesDiscoveryService;
    }

    @Nonnull
    public String getWebservicesRelationshipService() {
        return this.getServiceUrl(this.getWebservicesBaseUrl(), this.webservicesRelationshipService, "/services/RelationshipService?wsdl");
    }

    public void setWebservicesRelationshipService(String webservicesRelationshipService) {
        this.webservicesRelationshipService = webservicesRelationshipService;
    }

    @Nonnull
    public String getWebservicesMultifilingService() {
        return this.getServiceUrl(this.getWebservicesBaseUrl(), this.webservicesMultifilingService, "/services/MultiFilingService?wsdl");
    }

    public void setWebservicesMultifilingService(String webservicesMultifilingService) {
        this.webservicesMultifilingService = webservicesMultifilingService;
    }

    @Nonnull
    public String getWebservicesPolicyService() {
        return this.getServiceUrl(this.getWebservicesBaseUrl(), this.webservicesPolicyService, "/services/PolicyService?wsdl");
    }

    public void setWebservicesPolicyService(String webservicesPolicyService) {
        this.webservicesPolicyService = webservicesPolicyService;
    }

    @Nonnull
    public String getWebservicesAclService() {
        return this.getServiceUrl(this.getWebservicesBaseUrl(), this.webservicesAclService, "/services/ACLService?wsdl");
    }

    public void setWebservicesAclService(String webservicesAclService) {
        this.webservicesAclService = webservicesAclService;
    }

    @Nonnull
    public String getWebservicesMemoryThreshold() {
        return this.webservicesMemoryThreshold;
    }

    public void setWebservicesMemoryThreshold(String webservicesMemoryThreshold) {
        this.webservicesMemoryThreshold = webservicesMemoryThreshold;
    }

    @Nonnull
    public String getWebservicesBaseUrl() {
        return this.getServiceUrl(this.servicesBaseUrl, this.webservicesBaseUrl, "/cmis");
    }

    public void setWebservicesBaseUrl(String webservicesBaseUrl) {
        this.webservicesBaseUrl = webservicesBaseUrl;
    }

    @Nonnull
    public String getBrowserUrl() {
        return this.getServiceUrl(this.servicesBaseUrl, this.browserUrl, "/browser");
    }

    public void setBrowserUrl(String browserUrl) {
        this.browserUrl = browserUrl;
    }

    @Nonnull
    public String getAtompubUrl() {
        return this.getServiceUrl(this.servicesBaseUrl, this.atompubUrl, "/atom");
    }

    public void setAtompubUrl(String atompubUrl) {
        this.atompubUrl = atompubUrl;
    }

    public String getCmisMetadataUUIDPropertyName() {
        if (this.parsedCmisMetadataUUIDPropertyName != null) {
            return this.parsedCmisMetadataUUIDPropertyName;
        }
        return this.cmisMetadataUUIDPropertyName;
    }

    public void setCmisMetadataUUIDPropertyName(String cmisMetadataUUIDPropertyName) {
        if (!org.apache.commons.lang.StringUtils.isEmpty((String)cmisMetadataUUIDPropertyName) && cmisMetadataUUIDPropertyName.contains(CMIS_SECONDARY_PROPERTY_SEPARATOR)) {
            String[] splitPropertyNames = cmisMetadataUUIDPropertyName.split(Pattern.quote(CMIS_SECONDARY_PROPERTY_SEPARATOR));
            if (splitPropertyNames.length != 2) {
                Log.error((String)"geonetwork.resources", (Object)String.format("Invalid format for property name %s property will not be used", cmisMetadataUUIDPropertyName));
                this.cmisMetadataUUIDPropertyName = null;
                this.cmisMetadataUUIDSecondaryProperty = false;
                return;
            }
            this.cmisMetadataUUIDSecondaryProperty = true;
        }
        this.cmisMetadataUUIDPropertyName = cmisMetadataUUIDPropertyName;
    }

    public String getExternalResourceManagementValidationStatusPropertyName() {
        if (this.parsedExternalResourceManagementValidationStatusPropertyName != null) {
            return this.parsedExternalResourceManagementValidationStatusPropertyName;
        }
        return this.externalResourceManagementValidationStatusPropertyName;
    }

    public void setExternalResourceManagementValidationStatusPropertyName(String externalResourceManagementValidationStatusPropertyName) {
        this.externalResourceManagementValidationStatusPropertyName = externalResourceManagementValidationStatusPropertyName;
        if (!org.apache.commons.lang.StringUtils.isEmpty((String)externalResourceManagementValidationStatusPropertyName) && externalResourceManagementValidationStatusPropertyName.contains(CMIS_SECONDARY_PROPERTY_SEPARATOR)) {
            String[] splitPropertyNames = externalResourceManagementValidationStatusPropertyName.split(Pattern.quote(CMIS_SECONDARY_PROPERTY_SEPARATOR));
            if (splitPropertyNames.length != 2) {
                Log.error((String)"geonetwork.resources", (Object)String.format("Invalid format for property name %s property will not be used", externalResourceManagementValidationStatusPropertyName));
                this.externalResourceManagementValidationStatusPropertyName = null;
                this.externalResourceManagementValidationStatusSecondaryProperty = false;
                return;
            }
            this.externalResourceManagementValidationStatusSecondaryProperty = true;
        }
    }

    public MetadataResourceExternalManagementProperties.ValidationStatus getValidationStatusDefaultValue() {
        if (this.defaultStatus == null && !StringUtils.isEmpty((Object)this.getExternalResourceManagementValidationStatusPropertyName())) {
            this.defaultStatus = this.getExternalResourceManagementValidationStatusDefaultValue() != null ? MetadataResourceExternalManagementProperties.ValidationStatus.valueOf((String)this.getExternalResourceManagementValidationStatusDefaultValue()) : MetadataResourceExternalManagementProperties.ValidationStatus.INCOMPLETE;
        }
        return this.defaultStatus;
    }

    @PostConstruct
    public void init() {
        String repositoryUrl;
        if (this.cmisMetadataUUIDPropertyName != null) {
            this.setCmisMetadataUUIDPropertyName(this.cmisMetadataUUIDPropertyName);
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        this.baseRepositoryPath = this.baseRepositoryPath;
        if (this.baseRepositoryPath == null) {
            this.baseRepositoryPath = "";
        }
        if (this.baseRepositoryPath.endsWith(CMIS_FOLDER_DELIMITER)) {
            this.baseRepositoryPath = this.baseRepositoryPath.substring(1);
        }
        if (this.baseRepositoryPath.length() > 1 && !this.baseRepositoryPath.startsWith(CMIS_FOLDER_DELIMITER)) {
            this.baseRepositoryPath = CMIS_FOLDER_DELIMITER + this.baseRepositoryPath;
        }
        if (this.username != null) {
            parameters.put("org.apache.chemistry.opencmis.user", this.username);
            parameters.put("org.apache.chemistry.opencmis.password", this.password);
        }
        if (this.getBindingTypeObject() == null) {
            throw new IllegalArgumentException("CMIS Binding type must be supplied");
        }
        switch (this.getBindingTypeObject()) {
            case WEBSERVICES: {
                parameters.put("org.apache.chemistry.opencmis.binding.webservices.ACLService", this.getWebservicesAclService());
                parameters.put("org.apache.chemistry.opencmis.binding.webservices.DiscoveryService", this.getWebservicesDiscoveryService());
                parameters.put("org.apache.chemistry.opencmis.binding.webservices.MultiFilingService", this.getWebservicesMultifilingService());
                parameters.put("org.apache.chemistry.opencmis.binding.webservices.NavigationService", this.getWebservicesNavigationService());
                parameters.put("org.apache.chemistry.opencmis.binding.webservices.ObjectService", this.getWebservicesObjectService());
                parameters.put("org.apache.chemistry.opencmis.binding.webservices.PolicyService", this.getWebservicesPolicyService());
                parameters.put("org.apache.chemistry.opencmis.binding.webservices.RelationshipService", this.getWebservicesRelationshipService());
                parameters.put("org.apache.chemistry.opencmis.binding.webservices.RepositoryService", this.getWebservicesRepositoryService());
                parameters.put("org.apache.chemistry.opencmis.binding.webservices.VersioningService", this.getWebservicesVersioningService());
                repositoryUrl = this.getWebservicesBaseUrl();
                break;
            }
            case BROWSER: {
                parameters.put("org.apache.chemistry.opencmis.binding.browser.url", this.getBrowserUrl());
                repositoryUrl = this.getBrowserUrl();
                break;
            }
            case ATOMPUB: {
                parameters.put("org.apache.chemistry.opencmis.binding.atompub.url", this.getAtompubUrl());
                repositoryUrl = this.getAtompubUrl();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported CMIS Binding type '" + this.getBindingTypeObject().value() + "'.");
            }
        }
        parameters.put("org.apache.chemistry.opencmis.binding.spi.type", this.getBindingTypeObject().value());
        SessionFactoryImpl factory = SessionFactoryImpl.newInstance();
        if (this.repositoryId == null) {
            if (this.repositoryName != null) {
                try {
                    for (Repository repository : factory.getRepositories(parameters)) {
                        if (!repository.getName().equalsIgnoreCase(this.repositoryName)) continue;
                        this.repositoryId = repository.getId();
                    }
                }
                catch (CmisConnectionException | CmisRuntimeException e) {
                    Log.error((String)"geonetwork.resources", (Object)("CMIS Repository ID not found for repositoryName=\"" + this.repositoryName + "\". " + (e.getErrorContent() == null ? "" : "  Got following results from cmis api call:" + e.getErrorContent())), (Throwable)e);
                }
            }
        } else {
            try {
                for (Repository repository : factory.getRepositories(parameters)) {
                    if (!repository.getId().equalsIgnoreCase(this.repositoryId)) continue;
                    this.repositoryName = repository.getName();
                    break;
                }
            }
            catch (CmisConnectionException | CmisRuntimeException e) {
                Log.error((String)"geonetwork.resources", (Object)("CMIS Repository name not found repositoryName=\"" + this.repositoryName + "\". " + (e.getErrorContent() == null ? "" : "  Got following results from cmis api call:" + e.getErrorContent())), (Throwable)e);
            }
        }
        if (this.repositoryId != null) {
            parameters.put("org.apache.chemistry.opencmis.session.repository.id", this.repositoryId);
            try {
                this.client = factory.createSession(parameters);
                Log.info((String)"geonetwork.resources", (Object)("Connected to CMIS using binding '" + this.client.getBinding().getBindingType().value() + "' with base url '" + repositoryUrl + "' using product '" + this.client.getRepositoryInfo().getProductName() + "' version '" + this.client.getRepositoryInfo().getProductVersion() + "'."));
                this.parsedCmisMetadataUUIDPropertyName = this.parseSecondaryProperty(this.client, this.cmisMetadataUUIDPropertyName);
                this.parsedExternalResourceManagementValidationStatusPropertyName = this.parseSecondaryProperty(this.client, this.externalResourceManagementValidationStatusPropertyName);
                if (!this.client.getDefaultContext().isCacheEnabled()) {
                    Log.debug((String)"geonetwork.resources", (Object)"Changing default CMIS operational context cache to enabled.");
                    this.client.getDefaultContext().setCacheEnabled(true);
                }
                if (this.client.getDefaultContext().isIncludeAllowableActions()) {
                    Log.debug((String)"geonetwork.resources", (Object)"Changing default CMIS operational context to not include allowable actions.");
                    this.client.getDefaultContext().setIncludeAllowableActions(false);
                }
                if (this.client.getDefaultContext().isIncludeAcls()) {
                    Log.debug((String)"geonetwork.resources", (Object)"Changing default CMIS operational context to not include acls.");
                    this.client.getDefaultContext().setIncludeAcls(false);
                }
                if (this.client.getDefaultContext().isIncludePathSegments()) {
                    Log.debug((String)"geonetwork.resources", (Object)"Changing default CMIS operational context to not include path segments.");
                    this.client.getDefaultContext().setIncludePathSegments(false);
                }
                if (this.client.getDefaultContext().isIncludePolicies()) {
                    Log.debug((String)"geonetwork.resources", (Object)"Changing default CMIS operational context to not include policies.");
                    this.client.getDefaultContext().setIncludePolicies(false);
                }
                if (!this.client.getDefaultContext().getIncludeRelationships().equals((Object)IncludeRelationships.NONE)) {
                    Log.debug((String)"geonetwork.resources", (Object)"Changing default CMIS operational context to not include relationships.");
                    this.client.getDefaultContext().setIncludeRelationships(IncludeRelationships.NONE);
                }
                if (this.client.getDefaultContext().getMaxItemsPerPage() != CMIS_MAX_ITEMS_PER_PAGE.intValue()) {
                    Log.debug((String)"geonetwork.resources", (Object)("Changing default CMIS max items per page to " + CMIS_MAX_ITEMS_PER_PAGE + "."));
                    this.client.getDefaultContext().setMaxItemsPerPage(CMIS_MAX_ITEMS_PER_PAGE.intValue());
                }
                if (org.apache.commons.lang.StringUtils.isEmpty((String)this.client.getDefaultContext().getFilterString())) {
                    Log.debug((String)"geonetwork.resources", (Object)"Changing default CMIS operational context filter.");
                    this.client.getDefaultContext().setFilter(new HashSet<String>(Arrays.asList("cmis:name", "cmis:objectId", "cmis:objectTypeId", "cmis:baseTypeId", "cmis:createdBy", "cmis:creationDate", "cmis:lastModifiedBy", "cmis:lastModificationDate", "cmis:changeToken", "cmis:description", "cmis:isLatestVersion", "cmis:isMajorVersion", "cmis:isLatestMajorVersion", "cmis:versionLabel", "cmis:versionSeriesId", "cmis:contentStreamLength", "cmis:contentStreamMimeType", "cmis:contentStreamFileName", "cmis:contentStreamId")));
                }
            }
            catch (CmisConnectionException | CmisRuntimeException e) {
                this.client = null;
                Log.error((String)"geonetwork.resources", (Object)("CMIS error creating session using base url \"" + repositoryUrl + "\" with repositoryName=\"" + this.repositoryName + "\". " + (e.getErrorContent() == null ? "" : "  Got following results from cmis api call:" + e.getErrorContent())), (Throwable)e);
            }
        }
    }

    @Nonnull
    public Session getClient() {
        if (this.client == null) {
            this.init();
        }
        if (this.client == null) {
            throw new RuntimeException("Failed to create CMIS session.");
        }
        return this.client;
    }

    public String getFolderDelimiter() {
        return CMIS_FOLDER_DELIMITER;
    }

    public String getSecondaryPropertySeparator() {
        return CMIS_SECONDARY_PROPERTY_SEPARATOR;
    }

    public boolean existSecondaryProperty() {
        return this.cmisMetadataUUIDSecondaryProperty || this.externalResourceManagementValidationStatusSecondaryProperty;
    }

    public boolean existMetadataUUIDSecondaryProperty() {
        return this.cmisMetadataUUIDSecondaryProperty;
    }

    public boolean existExternalResourceManagementValidationStatusSecondaryProperty() {
        return this.externalResourceManagementValidationStatusSecondaryProperty;
    }

    private String getServiceUrl(String baseUrl, String serviceUrl, String defaultServicePathInfo) {
        if (org.apache.commons.lang.StringUtils.isEmpty((String)serviceUrl)) {
            return baseUrl + defaultServicePathInfo;
        }
        if (serviceUrl.startsWith(CMIS_FOLDER_DELIMITER)) {
            return baseUrl + serviceUrl;
        }
        return serviceUrl;
    }

    private String parseSecondaryProperty(Session client, String propertyName) {
        String[] splitPropertyNames;
        if (!org.apache.commons.lang.StringUtils.isEmpty((String)propertyName) && propertyName.contains(CMIS_SECONDARY_PROPERTY_SEPARATOR) && (splitPropertyNames = propertyName.split(Pattern.quote(CMIS_SECONDARY_PROPERTY_SEPARATOR))).length == 2) {
            Folder baseFolder = (Folder)client.getObjectByPath(this.baseRepositoryPath);
            for (SecondaryType secondaryType : baseFolder.getSecondaryTypes()) {
                if (!secondaryType.getId().equals(splitPropertyNames[0]) && !secondaryType.getDisplayName().equals(splitPropertyNames[0])) continue;
                for (Map.Entry entry : secondaryType.getPropertyDefinitions().entrySet()) {
                    if (!((PropertyDefinition)entry.getValue()).getId().equals(splitPropertyNames[1]) && !((PropertyDefinition)entry.getValue()).getDisplayName().equals(splitPropertyNames[1])) continue;
                    String parsedPropertyName = secondaryType.getId() + CMIS_SECONDARY_PROPERTY_SEPARATOR + (String)entry.getKey();
                    if (parsedPropertyName.equals(propertyName)) {
                        return null;
                    }
                    Log.info((String)"geonetwork.resources", (Object)String.format("Parsed CMIS secondary properties from '%s' to '%s'", propertyName, parsedPropertyName));
                    return parsedPropertyName;
                }
            }
            Log.error((String)"geonetwork.resources", (Object)String.format("Unable to locate secondary property name '%s'", propertyName));
        }
        return null;
    }
}

