/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.search.spatial;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.OpenBitSet;
import org.fao.geonet.domain.Pair;
import org.fao.geonet.kernel.search.spatial.SpatialFilter;
import org.fao.geonet.kernel.search.spatial.SpatialIndexWriter;
import org.geotools.data.FeatureSource;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.index.ItemVisitor;
import org.locationtech.jts.index.SpatialIndex;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;

public class WithinBBoxFilter
extends SpatialFilter {
    private Map<String, AtomicInteger> enclosed;

    public WithinBBoxFilter(Query query, int numHits, Geometry geom, Pair<FeatureSource<SimpleFeatureType, SimpleFeature>, SpatialIndex> sourceAccessor) throws IOException {
        super(query, numHits, geom, sourceAccessor);
    }

    @Override
    public DocIdSet getDocIdSet(AtomicReaderContext context, Bits acceptDocs) throws IOException {
        final OpenBitSet bits = new OpenBitSet((long)context.reader().maxDoc());
        final Map<String, AtomicInteger> enclosed = this.enclosed();
        if (enclosed.isEmpty() || this._hits >= this._numHits) {
            return bits;
        }
        new IndexSearcher((IndexReader)context.reader()).search(this._query, new Collector(){
            private int docBase;
            private Document document;
            private AtomicReader reader;

            public void setScorer(Scorer scorer) {
            }

            public boolean acceptsDocsOutOfOrder() {
                return true;
            }

            public void collect(int doc) {
                doc += this.docBase;
                try {
                    this.document = this.reader.document(doc, WithinBBoxFilter.this._fieldsToLoad);
                    String key = this.document.get("_id");
                    AtomicInteger notEnclosedBrotherCount = (AtomicInteger)enclosed.get(key);
                    if (notEnclosedBrotherCount != null && notEnclosedBrotherCount.get() == 0 && WithinBBoxFilter.this._hits < WithinBBoxFilter.this._numHits) {
                        ++WithinBBoxFilter.this._hits;
                        bits.set((long)(doc + this.docBase));
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            public void setNextReader(AtomicReaderContext context) throws IOException {
                this.docBase = context.docBase;
                this.reader = context.reader();
            }
        });
        return bits;
    }

    protected synchronized Map<String, AtomicInteger> enclosed() {
        if (this.enclosed == null) {
            this.enclosed = new HashMap<String, AtomicInteger>();
            SpatialIndex spatialIndex = (SpatialIndex)this.sourceAccessor.two();
            final Envelope env = this._geom.getEnvelopeInternal();
            spatialIndex.query(env, new ItemVisitor(){

                public void visitItem(Object o) {
                    SpatialIndexWriter.Data data = (SpatialIndexWriter.Data)o;
                    if (env.contains(data.getEnv())) {
                        if (WithinBBoxFilter.this.enclosed.containsKey(data.getMetadataId())) {
                            ((AtomicInteger)WithinBBoxFilter.this.enclosed.get(data.getMetadataId())).decrementAndGet();
                        } else {
                            WithinBBoxFilter.this.enclosed.put(data.getMetadataId(), new AtomicInteger(data.getNumBrotherGeometries() - 1));
                        }
                    }
                }
            });
        }
        return this.enclosed;
    }

    @Override
    protected Filter createFilter(FeatureSource<SimpleFeatureType, SimpleFeature> source) {
        return null;
    }
}

