/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.search.spatial;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.jcs.access.GroupCacheAccess;
import org.apache.jcs.access.exception.CacheException;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.OpenBitSet;
import org.fao.geonet.JeevesJCS;
import org.fao.geonet.domain.Pair;
import org.fao.geonet.kernel.search.spatial.SpatialIndexWriter;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.JTS;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.index.SpatialIndex;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.Id;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.identity.FeatureId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SpatialFilter
extends org.apache.lucene.search.Filter {
    private static Logger LOGGER = LoggerFactory.getLogger((String)"geonetwork.spatial");
    private static final int MAX_FIDS_PER_QUERY = 5000;
    private static final Geometry WORLD_BOUNDS;
    protected Geometry _geom;
    protected final FilterFactory2 _filterFactory;
    protected final Set<String> _fieldsToLoad;
    protected Pair<FeatureSource<SimpleFeatureType, SimpleFeature>, SpatialIndex> sourceAccessor;
    protected org.apache.lucene.search.Query _query;
    private Filter _spatialFilter;
    private Map<String, FeatureId> _unrefinedMatches;
    private boolean warned = false;
    protected int _numHits;
    protected int _hits = 0;

    protected SpatialFilter(org.apache.lucene.search.Query query, int numHits, Geometry geom, Pair<FeatureSource<SimpleFeatureType, SimpleFeature>, SpatialIndex> sourceAccessor) throws IOException {
        this._query = query;
        this._numHits = numHits;
        this.sourceAccessor = sourceAccessor;
        this._filterFactory = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());
        this._fieldsToLoad = Collections.singleton("_id");
        this._geom = geom;
        this._spatialFilter = this.createFilter((FeatureSource<SimpleFeatureType, SimpleFeature>)((FeatureSource)sourceAccessor.one()));
        if (this._spatialFilter != null && this._spatialFilter.getClass().getName().equals("org.geotools.filter.spatial.DisjointImpl")) {
            this._geom = WORLD_BOUNDS;
        }
    }

    protected SpatialFilter(org.apache.lucene.search.Query query, int numHits, Envelope bounds, Pair<FeatureSource<SimpleFeatureType, SimpleFeature>, SpatialIndex> sourceAccessor) throws IOException {
        this(query, numHits, (Geometry)JTS.toGeometry((Envelope)bounds), sourceAccessor);
    }

    static JeevesJCS getJCSCache() throws Error {
        JeevesJCS jcs;
        try {
            jcs = JeevesJCS.getInstance((String)"SpatialFilterCache");
        }
        catch (CacheException e) {
            throw new Error(e);
        }
        return jcs;
    }

    public DocIdSet getDocIdSet(AtomicReaderContext context, Bits acceptDocs) throws IOException {
        OpenBitSet bits = new OpenBitSet((long)context.reader().maxDoc());
        final Map<String, FeatureId> unrefinedSpatialMatches = this.unrefinedSpatialMatches();
        final HashSet<FeatureId> matches = new HashSet<FeatureId>();
        HashMultimap docIndexLookup = HashMultimap.create();
        if (unrefinedSpatialMatches.isEmpty() || this._hits >= this._numHits) {
            return bits;
        }
        new IndexSearcher((IndexReader)context.reader()).search(this._query, new Collector((Multimap)docIndexLookup){
            private int docBase;
            private Document document;
            private AtomicReader reader;
            final /* synthetic */ Multimap val$docIndexLookup;
            {
                this.val$docIndexLookup = multimap;
            }

            public void setScorer(Scorer scorer) {
            }

            public boolean acceptsDocsOutOfOrder() {
                return true;
            }

            public void collect(int doc) {
                doc += this.docBase;
                try {
                    this.document = this.reader.document(doc, SpatialFilter.this._fieldsToLoad);
                    String key = this.document.get("_id");
                    FeatureId featureId = (FeatureId)unrefinedSpatialMatches.get(key);
                    if (featureId != null && SpatialFilter.this._hits < SpatialFilter.this._numHits) {
                        ++SpatialFilter.this._hits;
                        matches.add(featureId);
                        this.val$docIndexLookup.put((Object)featureId, (Object)(doc + this.docBase));
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            public void setNextReader(AtomicReaderContext context) throws IOException {
                this.docBase = context.docBase;
                this.reader = context.reader();
            }
        });
        JeevesJCS jcs = SpatialFilter.getJCSCache();
        this.processCachedFeatures((GroupCacheAccess)jcs, matches, (Multimap<FeatureId, Integer>)docIndexLookup, bits);
        this.processNonCachedFeature(jcs, matches, (Multimap<FeatureId, Integer>)docIndexLookup, bits);
        return bits;
    }

    private void processCachedFeatures(GroupCacheAccess jcs, Set<FeatureId> matches, Multimap<FeatureId, Integer> docIndexLookup, OpenBitSet bits) {
        Iterator<FeatureId> iter = matches.iterator();
        while (iter.hasNext()) {
            FeatureId id = iter.next();
            Geometry geom = (Geometry)jcs.get((Object)id.getID());
            if (geom == null) continue;
            iter.remove();
            SimpleFeatureBuilder simpleFeatureBuilder = new SimpleFeatureBuilder((SimpleFeatureType)((FeatureSource)this.sourceAccessor.one()).getSchema());
            simpleFeatureBuilder.set(((SimpleFeatureType)((FeatureSource)this.sourceAccessor.one()).getSchema()).getGeometryDescriptor().getName(), (Object)geom);
            SimpleFeature simpleFeature = simpleFeatureBuilder.buildFeature(id.getID());
            this.evaluateFeature(simpleFeature, bits, docIndexLookup);
        }
    }

    private void processNonCachedFeature(JeevesJCS jcs, Set<FeatureId> matches, Multimap<FeatureId, Integer> docIndexLookup, OpenBitSet bits) throws IOException {
        while (!matches.isEmpty()) {
            Id fidFilter;
            if (matches.size() > 5000) {
                FeatureId[] subset = new FeatureId[5000];
                Iterator<FeatureId> iter = matches.iterator();
                for (int i = 0; iter.hasNext() && i < 5000; ++i) {
                    subset[i] = iter.next();
                    iter.remove();
                }
                fidFilter = this._filterFactory.id(subset);
            } else {
                fidFilter = this._filterFactory.id(matches);
                matches = Collections.emptySet();
            }
            FeatureSource _featureSource = (FeatureSource)this.sourceAccessor.one();
            String ftn = ((SimpleFeatureType)_featureSource.getSchema()).getName().getLocalPart();
            String[] geomAtt = new String[]{((SimpleFeatureType)_featureSource.getSchema()).getGeometryDescriptor().getLocalName()};
            FeatureCollection features = _featureSource.getFeatures(new Query(ftn, (Filter)fidFilter, geomAtt));
            try (FeatureIterator iterator = features.features();){
                while (iterator.hasNext()) {
                    SimpleFeature feature = (SimpleFeature)iterator.next();
                    FeatureId featureId = feature.getIdentifier();
                    jcs.put((Object)featureId.getID(), feature.getDefaultGeometry());
                    this.evaluateFeature(feature, bits, docIndexLookup);
                }
            }
        }
    }

    private void evaluateFeature(SimpleFeature feature, OpenBitSet bits, Multimap<FeatureId, Integer> docIndexLookup) {
        try {
            if (this._spatialFilter.evaluate((Object)feature)) {
                Iterator iterator = docIndexLookup.get((Object)feature.getIdentifier()).iterator();
                while (iterator.hasNext()) {
                    int doc = (Integer)iterator.next();
                    bits.set((long)doc);
                }
            }
        }
        catch (TopologyException e) {
            if (!this.warned) {
                this.warned = true;
                LOGGER.warn("{} errors are occuring with filter: {}", (Object)e.getMessage(), (Object)this._spatialFilter);
            }
            LOGGER.debug(e.getMessage() + "{}: occurred during a search: {} on feature: {}", new Object[]{e.getMessage(), this._spatialFilter, feature.getDefaultGeometry()});
        }
    }

    protected synchronized Map<String, FeatureId> unrefinedSpatialMatches() {
        if (this._unrefinedMatches == null) {
            SpatialIndex spatialIndex = (SpatialIndex)this.sourceAccessor.two();
            List fids = spatialIndex.query(this._geom.getEnvelopeInternal());
            this._unrefinedMatches = new HashMap<String, FeatureId>();
            for (SpatialIndexWriter.Data match : fids) {
                this._unrefinedMatches.put(match.getMetadataId(), match.getFeatureId());
            }
        }
        return this._unrefinedMatches;
    }

    protected Filter createFilter(FeatureSource<SimpleFeatureType, SimpleFeature> source) {
        String geomAttName = ((SimpleFeatureType)source.getSchema()).getGeometryDescriptor().getLocalName();
        PropertyName geomPropertyName = this._filterFactory.property(geomAttName);
        Literal geomExpression = this._filterFactory.literal((Object)this._geom);
        Filter filter = this.createGeomFilter(this._filterFactory, geomPropertyName, geomExpression);
        return filter;
    }

    public Filter createGeomFilter(FilterFactory2 filterFactory, PropertyName geomPropertyName, Literal geomExpression) {
        throw new UnsupportedOperationException("createGeomFilter must be overridden ");
    }

    public org.apache.lucene.search.Query getQuery() {
        return this._query;
    }

    public void setQuery(org.apache.lucene.search.Query query) {
        this._query = query;
    }

    static {
        GeometryFactory fac = new GeometryFactory();
        WORLD_BOUNDS = fac.toGeometry(new Envelope(-180.0, 180.0, -90.0, 90.0));
    }
}

