/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.search.spatial;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.jcs.access.exception.InvalidArgumentException;
import org.apache.lucene.search.Query;
import org.fao.geonet.domain.Pair;
import org.fao.geonet.kernel.search.spatial.FullScanFilter;
import org.fao.geonet.kernel.search.spatial.SpatialFilter;
import org.fao.geonet.kernel.search.spatial.WithinOrEquals;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.geotools.data.FeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.spatial.ReprojectingFilterVisitor;
import org.geotools.filter.spatial.WithinImpl;
import org.geotools.filter.visitor.DefaultFilterVisitor;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.geotools.filter.visitor.ExtractBoundsFilterVisitor;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.geotools.xsd.Parser;
import org.jdom.Element;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.index.SpatialIndex;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.filter.And;
import org.opengis.filter.BinaryLogicOperator;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;
import org.opengis.geometry.BoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class OgcGenericFilters {
    private static SimpleFeatureType reprojectGeometryType(Name geometryAttName) {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        AttributeTypeBuilder attBuilder = new AttributeTypeBuilder();
        attBuilder.crs((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        attBuilder.binding(MultiPolygon.class);
        GeometryDescriptor geomDescriptor = attBuilder.buildDescriptor(geometryAttName, attBuilder.buildGeometryType());
        builder.setName("dummy");
        builder.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        builder.add((AttributeDescriptor)geomDescriptor);
        return builder.buildFeatureType();
    }

    public static SpatialFilter create(Query query, int numHits, Element filterExpr, Pair<FeatureSource<SimpleFeatureType, SimpleFeature>, SpatialIndex> sourceAccessor, Parser parser) throws Exception {
        Boolean disjointFilter;
        Name geometryColumn = ((SimpleFeatureType)((FeatureSource)sourceAccessor.one()).getSchema()).getGeometryDescriptor().getName();
        String string = Xml.getString((Element)filterExpr);
        if (Log.isDebugEnabled((String)"geonetwork.search")) {
            Log.debug((String)"geonetwork.search", (Object)("Filter string is :\n" + string));
        }
        parser.setValidating(true);
        parser.setFailOnValidationError(false);
        if (Log.isDebugEnabled((String)"geonetwork.search")) {
            Log.debug((String)"geonetwork.search", (Object)"Parsing filter");
        }
        Object parseResult = parser.parse((Reader)new StringReader(string));
        if (parser.getValidationErrors().size() > 0 && filterExpr.getContentSize() > 0) {
            Log.error((String)"geonetwork.search", (Object)"Errors occurred when trying to parse a filter:");
            Log.error((String)"geonetwork.search", (Object)"----------------------------------------------");
            StringBuilder sb = new StringBuilder(" Errors parsing filter:");
            for (Object error : parser.getValidationErrors()) {
                Log.error((String)"geonetwork.search", error);
                sb.append("\n" + error);
            }
            Log.error((String)"geonetwork.search", (Object)"----------------------------------------------");
            throw new InvalidArgumentException(sb.toString());
        }
        if (!(parseResult instanceof Filter)) {
            return null;
        }
        Filter fullFilter = (Filter)parseResult;
        FilterFactory2 filterFactory2 = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());
        GeomExtractor visitor = new GeomExtractor(filterFactory2);
        Filter trimmedFilter = (Filter)fullFilter.accept((FilterVisitor)visitor, null);
        if (trimmedFilter == null) {
            return null;
        }
        Filter remappedFilter = (Filter)trimmedFilter.accept((FilterVisitor)new RenameGeometryPropertyNameVisitor(geometryColumn), null);
        visitor = new ReprojectingFilterVisitor(filterFactory2, (FeatureType)OgcGenericFilters.reprojectGeometryType(geometryColumn));
        Filter reprojectedFilter = (Filter)remappedFilter.accept((FilterVisitor)visitor, null);
        if (Log.isDebugEnabled((String)"geonetwork.search")) {
            Log.debug((String)"geonetwork.search", (Object)("Reprojected Filter is " + reprojectedFilter));
        }
        Envelope bounds = (Envelope)reprojectedFilter.accept((FilterVisitor)ExtractBoundsFilterVisitor.BOUNDS_VISITOR, (Object)DefaultGeographicCRS.WGS84);
        if (Log.isDebugEnabled((String)"geonetwork.search")) {
            Log.debug((String)"geonetwork.search", (Object)("Filter Envelope is " + bounds));
        }
        final Filter finalFilter = (Filter)reprojectedFilter.accept((FilterVisitor)new WithinUpdater(), null);
        if (Log.isDebugEnabled((String)"geonetwork.search")) {
            Log.debug((String)"geonetwork.search", (Object)("Adjusted within Filter is " + finalFilter));
        }
        if ((disjointFilter = (Boolean)finalFilter.accept((FilterVisitor)new DisjointDetector(), (Object)false)).booleanValue()) {
            return new FullScanFilter(query, numHits, bounds, sourceAccessor){

                @Override
                protected Filter createFilter(FeatureSource<SimpleFeatureType, SimpleFeature> source) {
                    return finalFilter;
                }
            };
        }
        return new SpatialFilter(query, numHits, bounds, sourceAccessor){

            @Override
            protected Filter createFilter(FeatureSource<SimpleFeatureType, SimpleFeature> source) {
                return finalFilter;
            }
        };
    }

    private static class GeomExtractor
    extends DefaultFilterVisitor {
        private final FilterFactory2 _filterFactory;

        public GeomExtractor(FilterFactory2 factory) {
            this._filterFactory = factory;
        }

        public Filter visit(And filter, Object data) {
            List<Filter> newChildren = this.visitLogicFilter((BinaryLogicOperator)filter, data);
            if (newChildren.isEmpty()) {
                return null;
            }
            if (newChildren.size() == 1) {
                return newChildren.get(0);
            }
            return this._filterFactory.and(newChildren);
        }

        private List<Filter> visitLogicFilter(BinaryLogicOperator filter, Object data) {
            ArrayList<Filter> newChildren = new ArrayList<Filter>();
            for (Filter child : filter.getChildren()) {
                Filter newChild = (Filter)child.accept((FilterVisitor)this, data);
                if (newChild == null) continue;
                newChildren.add(newChild);
            }
            return newChildren;
        }

        public Not visit(Not filter, Object data) {
            Filter newChild = (Filter)filter.getFilter().accept((FilterVisitor)this, data);
            if (newChild == null) {
                return null;
            }
            return this._filterFactory.not(newChild);
        }

        public Filter visit(Or filter, Object data) {
            List<Filter> newChildren = this.visitLogicFilter((BinaryLogicOperator)filter, data);
            if (newChildren.isEmpty()) {
                return null;
            }
            if (newChildren.size() == 1) {
                return newChildren.get(0);
            }
            return this._filterFactory.or(newChildren);
        }

        public BBOX visit(BBOX filter, Object data) {
            return filter;
        }

        public Beyond visit(Beyond filter, Object data) {
            return filter;
        }

        public Contains visit(Contains filter, Object data) {
            return filter;
        }

        public Crosses visit(Crosses filter, Object data) {
            return filter;
        }

        public Disjoint visit(Disjoint filter, Object data) {
            return filter;
        }

        public DWithin visit(DWithin filter, Object data) {
            return filter;
        }

        public Equals visit(Equals filter, Object data) {
            return filter;
        }

        public Intersects visit(Intersects filter, Object data) {
            return filter;
        }

        public Within visit(Within filter, Object data) {
            return filter;
        }

        public Overlaps visit(Overlaps filter, Object data) {
            return filter;
        }

        public Touches visit(Touches filter, Object data) {
            return filter;
        }
    }

    private static class DisjointDetector
    extends DefaultFilterVisitor {
        private DisjointDetector() {
        }

        public Object visit(And filter, Object data) {
            for (Filter child : filter.getChildren()) {
                if (child.accept((FilterVisitor)this, data) == data) continue;
                return true;
            }
            return super.visit(filter, data);
        }

        public Object visit(Or filter, Object data) {
            for (Filter child : filter.getChildren()) {
                if (child.accept((FilterVisitor)this, data) == data) continue;
                return true;
            }
            return super.visit(filter, data);
        }

        public Object visit(Not filter, Object data) {
            if (filter.getFilter().accept((FilterVisitor)this, data) == data) {
                return true;
            }
            return data;
        }

        public Object visit(DWithin filter, Object data) {
            return true;
        }

        public Object visit(Beyond filter, Object data) {
            return true;
        }

        public Object visit(Disjoint filter, Object data) {
            return true;
        }
    }

    private static final class RenameGeometryPropertyNameVisitor
    extends DuplicatingFilterVisitor {
        Name geomName;

        private RenameGeometryPropertyNameVisitor(Name geomName) {
            this.geomName = geomName;
        }

        public Object visit(PropertyName expression, Object data) {
            return this.getFactory(data).property(this.geomName);
        }

        public Object visit(BBOX filter, Object extraData) {
            if (filter.getExpression2() instanceof Literal && ((Literal)filter.getExpression2()).getValue() instanceof BoundingBox) {
                BoundingBox expr2 = (BoundingBox)((Literal)filter.getExpression2()).getValue();
                FilterFactory2 factory = this.getFactory(extraData);
                return factory.bbox((Expression)factory.property(this.geomName), expr2);
            }
            if (filter.getExpression2() instanceof Literal && ((Literal)filter.getExpression2()).getValue() instanceof Polygon) {
                Polygon expr2 = (Polygon)((Literal)filter.getExpression2()).getValue();
                if (expr2.isRectangle()) {
                    FilterFactory2 factory = this.getFactory(extraData);
                    BBOX bbox = factory.bbox((Expression)factory.property(this.geomName), (BoundingBox)JTS.toEnvelope((Geometry)expr2));
                    return bbox;
                }
                return filter;
            }
            return filter;
        }
    }

    private static final class WithinUpdater
    extends DuplicatingFilterVisitor {
        private WithinUpdater() {
        }

        public Object visit(Within filter, Object extraData) {
            WithinImpl impl = (WithinImpl)filter;
            FilterFactory factory = CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());
            return new WithinOrEquals(factory, impl.getExpression1(), impl.getExpression2());
        }
    }
}

