/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.search.log;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jeeves.server.context.ServiceContext;
import org.apache.log4j.Logger;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.fao.geonet.kernel.search.log.LuceneQueryParamType;
import org.fao.geonet.kernel.search.log.QueryRequest;
import org.fao.geonet.kernel.search.log.SearchRequestParam;
import org.fao.geonet.utils.Log;
import org.springframework.beans.factory.annotation.Value;

public class SearcherLogger {
    @Value(value="${es.index.searchlogs}")
    private String index = "searchlogs";
    @Value(value="${es.index.searchlogs.type}")
    private String indexType = "searchlogs";

    public String getIndex() {
        return this.index;
    }

    public String getIndexType() {
        return this.indexType;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public void setIndexType(String indexType) {
        this.indexType = indexType;
    }

    public void logSearch(ServiceContext.ServiceDetails serviceDetails, Query query, int numHits, Sort sort, String geomFilterWKT, String guiService) {
        Logger log = Logger.getLogger((String)"geonetwork.search-logger");
        try {
            log.debug((Object)"Opening dbms...");
            if (query == null) {
                log.debug((Object)"Null Query object. cannot log search operation");
                return;
            }
            QueryRequest queryRequest = new QueryRequest(serviceDetails.getIpAddress(), new Date().getTime());
            List<SearchRequestParam> queryInfos = this.extractQueryTerms(query);
            queryRequest.setQueryInfos(queryInfos);
            queryRequest.setHits(numHits);
            queryRequest.setService(serviceDetails.getService());
            queryRequest.setLanguage(serviceDetails.getLanguage());
            queryRequest.setLuceneQuery(query.toString());
            if (sort != null) {
                queryRequest.setSortBy(this.concatSortFields(sort.getSort()));
            }
            queryRequest.setSpatialFilter(geomFilterWKT);
            queryRequest.isSimpleQuery();
            queryRequest.setAutoGeneratedQuery(guiService.equals("yes"));
            if (!queryRequest.storeToEs(this.index, this.indexType)) {
                log.warn((Object)"Unable to log query into database...");
            } else {
                log.debug((Object)"Query saved to database");
            }
        }
        catch (Exception e) {
            log.error((Object)("Error logging search: " + e.getMessage()), (Throwable)e);
        }
    }

    protected List<SearchRequestParam> extractQueryTerms(Query query) {
        if (query == null) {
            return null;
        }
        ArrayList<SearchRequestParam> result = new ArrayList<SearchRequestParam>();
        if (query instanceof BooleanQuery) {
            BooleanClause[] clauses;
            BooleanQuery bq = (BooleanQuery)query;
            for (BooleanClause clause : clauses = bq.getClauses()) {
                result.addAll(this.extractQueryTerms(clause.getQuery()));
            }
        } else {
            Optional<List<SearchRequestParam>> info = LuceneQueryParamType.createRequestParam(query);
            if (info.isPresent()) {
                for (SearchRequestParam s : (List)info.get()) {
                    result.add(s);
                }
            } else {
                Log.debug((String)"geonetwork.search-logger", (Object)("unknown queryInfo type: " + query.getClass().getName()));
            }
        }
        return result;
    }

    private String concatTermsText(Term[] terms, String separator) {
        if (terms == null || separator == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (Term t : terms) {
            sb.append(t.text()).append(separator);
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    private String concatTermsField(Term[] terms, String separator) {
        if (terms == null || separator == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (Term t : terms) {
            sb.append(t.field()).append(separator);
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    private String concatSortFields(SortField[] sortFields) {
        if (sortFields == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (SortField sf : sortFields) {
            if (sf == null) continue;
            sb.append(sf.getField()).append(" ").append(sf.getReverse() ? "DESC" : "ASC").append(",");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }
}

