/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.metadata;

import java.lang.reflect.Constructor;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.kernel.metadata.StatusActions;
import org.fao.geonet.utils.Log;

public class StatusActionsFactory {
    Class<StatusActions> statusRules;
    private String className;
    private static final String DEFAULT_STATUS_ACTION_CLASS = "org.fao.geonet.kernel.metadata.DefaultStatusActions";

    public StatusActionsFactory() {
        this(DEFAULT_STATUS_ACTION_CLASS);
    }

    public StatusActionsFactory(String className) {
        this.className = className;
        try {
            this.statusRules = Class.forName(this.className);
        }
        catch (ClassNotFoundException e) {
            Log.warning((String)"geonetwork.datamanager", (Object)String.format("Class name '%s' is not found. You MUST use a valid class name loaded in the classpath. The default status action class is used (ie. %s)", this.className, DEFAULT_STATUS_ACTION_CLASS));
            try {
                this.statusRules = Class.forName(DEFAULT_STATUS_ACTION_CLASS);
            }
            catch (ClassNotFoundException e1) {
                Log.error((String)"geonetwork.datamanager", (Object)String.format("Default class name '%s' is not found. This should not happen.", DEFAULT_STATUS_ACTION_CLASS));
            }
        }
    }

    public StatusActions createStatusActions(ServiceContext context) throws Exception {
        Constructor<StatusActions> constructor = this.statusRules.getConstructor(new Class[0]);
        StatusActions statusAction = constructor.newInstance(new Object[0]);
        statusAction.init(context);
        return statusAction;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }
}

