/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.metadata;

import com.google.common.base.Joiner;
import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Pattern;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.Group;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.MetadataDraft;
import org.fao.geonet.domain.MetadataStatus;
import org.fao.geonet.domain.Pair;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.domain.ReservedOperation;
import org.fao.geonet.domain.StatusValue;
import org.fao.geonet.domain.StatusValueNotificationLevel;
import org.fao.geonet.domain.StatusValueType;
import org.fao.geonet.domain.User;
import org.fao.geonet.events.md.MetadataStatusChanged;
import org.fao.geonet.kernel.AccessManager;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.datamanager.IMetadataManager;
import org.fao.geonet.kernel.datamanager.IMetadataStatus;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.datamanager.draft.DraftMetadataManager;
import org.fao.geonet.kernel.metadata.StatusActions;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.repository.GroupRepository;
import org.fao.geonet.repository.MetadataDraftRepository;
import org.fao.geonet.repository.MetadataRepository;
import org.fao.geonet.repository.StatusValueRepository;
import org.fao.geonet.repository.UserRepository;
import org.fao.geonet.repository.specification.GroupSpecs;
import org.fao.geonet.util.MailUtil;
import org.fao.geonet.utils.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;

public class DefaultStatusActions
implements StatusActions {
    public static final Pattern metadataLuceneField = Pattern.compile("\\{\\{index:([^\\}]+)\\}\\}");
    protected ServiceContext context;
    protected String language;
    protected DataManager dm;
    @Autowired
    protected IMetadataUtils metadataUtils;
    protected String siteUrl;
    protected String siteName;
    protected UserSession session;
    protected boolean emailNotes = true;
    private String replyTo;
    private String replyToDescr;
    private StatusValueRepository statusValueRepository;
    protected IMetadataStatus metadataStatusManager;

    @Override
    public void init(ServiceContext context) throws Exception {
        this.context = context;
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        this.statusValueRepository = (StatusValueRepository)applicationContext.getBean(StatusValueRepository.class);
        this.metadataUtils = (IMetadataUtils)applicationContext.getBean(IMetadataUtils.class);
        this.language = context.getLanguage();
        SettingManager sm = (SettingManager)applicationContext.getBean(SettingManager.class);
        this.siteName = sm.getSiteName();
        String from = sm.getValue("system/feedback/email");
        if (from == null || from.length() == 0) {
            context.error("Mail feedback address not configured, email notifications won't be sent.");
            this.emailNotes = false;
        }
        this.session = context.getUserSession();
        this.replyTo = this.session.getEmailAddr();
        if (this.replyTo != null) {
            this.replyToDescr = this.session.getName() + " " + this.session.getSurname();
        } else {
            this.replyTo = from;
            this.replyToDescr = this.siteName;
        }
        this.dm = (DataManager)applicationContext.getBean(DataManager.class);
        this.metadataStatusManager = (IMetadataStatus)applicationContext.getBean(IMetadataStatus.class);
        this.siteUrl = sm.getSiteURL(context);
    }

    @Override
    public void onEdit(int id, boolean minorEdit) throws Exception {
        if (Log.isTraceEnabled((String)"geonetwork.datamanager")) {
            Log.trace((String)"geonetwork.datamanager", (Object)("DefaultStatusActions.onEdit(" + id + ", " + minorEdit + ") with status " + this.dm.getCurrentStatus(id)));
        }
        if (!minorEdit && this.dm.getCurrentStatus(id).equals("2") && this.context.getBean(IMetadataManager.class) instanceof DraftMetadataManager) {
            ResourceBundle messages = ResourceBundle.getBundle("org.fao.geonet.api.Messages", new Locale(this.language));
            String changeMessage = String.format(messages.getString("status_email_text"), this.replyToDescr, this.replyTo, id);
            Log.trace((String)"geonetwork.datamanager", (Object)("Set DRAFT to current record with id " + id));
            this.dm.setStatus(this.context, id, Integer.valueOf("1"), new ISODate(), changeMessage);
        }
    }

    @Override
    public Set<Integer> onStatusChange(List<MetadataStatus> listOfStatus, boolean updateIndex) throws Exception {
        HashSet<Integer> unchanged = new HashSet<Integer>();
        for (MetadataStatus status : listOfStatus) {
            MetadataStatus currentStatus = this.dm.getStatus(status.getMetadataId());
            String currentStatusId = currentStatus != null ? String.valueOf(currentStatus.getStatusValue().getId()) : "";
            String statusId = status.getStatusValue().getId() + "";
            HashSet<Integer> listOfId = new HashSet<Integer>(1);
            listOfId.add(status.getMetadataId());
            if (status.getStatusValue().getType().equals((Object)StatusValueType.workflow) && statusId.equals(currentStatusId)) {
                if (this.context.isDebugEnabled()) {
                    this.context.debug(String.format("Metadata %s already has status %s ", status.getMetadataId(), status.getStatusValue().getId()));
                }
                unchanged.add(status.getMetadataId());
                continue;
            }
            this.metadataStatusManager.setStatusExt(status, updateIndex);
            Log.trace((String)"geonetwork.datamanager", (Object)"Issue workflow events.");
            ArrayList<String> unsuccessful = new ArrayList<String>();
            Exception statusChangeFailure = null;
            for (Integer mid : listOfId) {
                if (unchanged.contains(mid)) continue;
                try {
                    Log.debug((String)"geonetwork.datamanager", (Object)("  > Status changed for record (" + mid + ") to status " + status));
                    this.context.getApplicationContext().publishEvent((ApplicationEvent)new MetadataStatusChanged(this.metadataUtils.findOne(mid), status.getStatusValue(), status.getChangeMessage(), Integer.valueOf(status.getUserId())));
                }
                catch (Exception error) {
                    Log.error((String)"geonetwork.datamanager", (Object)String.format("Failed to update metadata %s to status %s. Error is: %s", mid, status.getStatusValue(), error.getMessage()), (Throwable)error);
                    unsuccessful.add(String.valueOf(mid));
                    if (statusChangeFailure != null) continue;
                    statusChangeFailure = error;
                }
            }
            if (!unsuccessful.isEmpty()) {
                if (statusChangeFailure instanceof UndeclaredThrowableException) {
                    throw new Exception("Unable to change status for metadata records: " + String.join((CharSequence)",", unsuccessful), statusChangeFailure);
                }
                throw statusChangeFailure;
            }
            try {
                this.notify(this.getUserToNotify(status), status);
            }
            catch (Exception e) {
                this.context.warning(String.format("Failed to send notification on status change for metadata %s with status %s. Error is: %s", status.getMetadataId(), status.getStatusValue().getId(), e.getMessage()));
            }
        }
        return unchanged;
    }

    private void applyRulesForStatusChange(MetadataStatus status, boolean updateIndex) throws Exception {
        String statusId = status.getStatusValue().getId() + "";
        if (statusId.equals("2")) {
            AccessManager accessManager = this.context.getBean(AccessManager.class);
            if (!accessManager.canReview(this.context, String.valueOf(status.getMetadataId()))) {
                throw new SecurityException(String.format("You can't edit record with ID %s", String.valueOf(status.getMetadataId())));
            }
        } else if (statusId.equals("1")) {
            this.unsetAllOperations(status.getMetadataId());
        }
    }

    private void notify(List<User> userToNotify, MetadataStatus status) throws Exception {
        if (userToNotify == null || userToNotify.isEmpty()) {
            return;
        }
        ResourceBundle messages = ResourceBundle.getBundle("org.fao.geonet.api.Messages", new Locale(this.language));
        String translatedStatusName = this.getTranslatedStatusName(status.getStatusValue().getId());
        String subjectTemplate = "";
        try {
            subjectTemplate = messages.getString("status_change_" + status.getStatusValue().getName() + "_email_subject");
        }
        catch (MissingResourceException e) {
            subjectTemplate = messages.getString("status_change_default_email_subject");
        }
        String subject = MessageFormat.format(subjectTemplate, this.siteName, translatedStatusName, this.replyToDescr);
        HashSet<Integer> listOfId = new HashSet<Integer>(1);
        listOfId.add(status.getMetadataId());
        String textTemplate = "";
        try {
            textTemplate = messages.getString("status_change_" + status.getStatusValue().getName() + "_email_text");
        }
        catch (MissingResourceException e) {
            textTemplate = messages.getString("status_change_default_email_text");
        }
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        SettingManager sm = (SettingManager)applicationContext.getBean(SettingManager.class);
        textTemplate = textTemplate.replace("{{link}}", sm.getNodeURL() + "api/records/'{{'index:_uuid'}}'");
        UserRepository userRepository = this.context.getBean(UserRepository.class);
        User owner = (User)userRepository.findOne((Serializable)status.getOwner());
        String message = MessageFormat.format(textTemplate, this.replyToDescr, status.getChangeMessage(), translatedStatusName, status.getChangeDate(), status.getDueDate(), status.getCloseDate(), owner == null ? "" : Joiner.on((String)" ").skipNulls().join((Object)owner.getName(), (Object)owner.getSurname(), new Object[0]), this.siteUrl);
        IMetadataUtils metadataRepository = (IMetadataUtils)ApplicationContextHolder.get().getBean(IMetadataUtils.class);
        AbstractMetadata metadata = metadataRepository.findOne(status.getMetadataId());
        subject = MailUtil.compileMessageWithIndexFields(subject, metadata.getUuid(), this.language);
        message = MailUtil.compileMessageWithIndexFields(message, metadata.getUuid(), this.language);
        for (User user : userToNotify) {
            String salutation = Joiner.on((String)" ").skipNulls().join((Object)user.getName(), (Object)user.getSurname(), new Object[0]);
            salutation = StringUtils.isEmpty((String)salutation) ? "" : salutation + ",\n\n";
            this.sendEmail(user.getEmail(), subject, salutation + message);
        }
    }

    protected List<User> getUserToNotify(MetadataStatus status) {
        StatusValueNotificationLevel notificationLevel = status.getStatusValue().getNotificationLevel();
        if (status.getStatusValue().getId() == Integer.parseInt("1") && (StringUtils.isEmpty((String)status.getPreviousState()) || Integer.parseInt(status.getPreviousState()) != Integer.parseInt("4"))) {
            return new ArrayList<User>();
        }
        HashSet<Integer> listOfId = new HashSet<Integer>(1);
        listOfId.add(status.getMetadataId());
        return DefaultStatusActions.getUserToNotify(notificationLevel, listOfId, status.getOwner());
    }

    public static List<User> getUserToNotify(StatusValueNotificationLevel notificationLevel, Set<Integer> recordIds, Integer ownerId) {
        UserRepository userRepository = (UserRepository)ApplicationContextHolder.get().getBean(UserRepository.class);
        List<Object> users = new ArrayList<User>();
        if (notificationLevel != null) {
            SettingManager settingManager;
            String adminEmail;
            if (notificationLevel == StatusValueNotificationLevel.statusUserOwner) {
                User owner = (User)userRepository.findOne((Serializable)ownerId);
                users.add(owner);
            } else if (notificationLevel == StatusValueNotificationLevel.recordProfileReviewer) {
                List results = userRepository.findAllByGroupOwnerNameAndProfile(recordIds, Profile.Reviewer);
                Collections.sort(results, Comparator.comparing(s -> ((User)s.two()).getName()));
                for (Pair p : results) {
                    users.add((User)p.two());
                }
            } else if (notificationLevel == StatusValueNotificationLevel.recordUserAuthor) {
                List records = ((MetadataRepository)ApplicationContextHolder.get().getBean(MetadataRepository.class)).findAll(recordIds);
                for (Object r : records) {
                    users.add((User)userRepository.findOne((Serializable)r.getSourceInfo().getOwner()));
                }
                List recordsDraft = ((MetadataDraftRepository)ApplicationContextHolder.get().getBean(MetadataDraftRepository.class)).findAll(recordIds);
                for (MetadataDraft r : recordsDraft) {
                    users.add((User)userRepository.findOne((Serializable)r.getSourceInfo().getOwner()));
                }
            } else if (notificationLevel.name().startsWith("catalogueProfile")) {
                String profileId = notificationLevel.name().replace("catalogueProfile", "");
                Profile profile = Profile.findProfileIgnoreCase((String)profileId);
                users = userRepository.findAllByProfile(profile);
            } else if (notificationLevel == StatusValueNotificationLevel.catalogueAdministrator && StringUtils.isNotEmpty((String)(adminEmail = (settingManager = (SettingManager)ApplicationContextHolder.get().getBean(SettingManager.class)).getValue("system/feedback/email")))) {
                HashSet<String> emails = new HashSet<String>(1);
                emails.add(adminEmail);
                User catalogueAdmin = new User().setEmailAddresses(emails);
                users.add(catalogueAdmin);
            }
        }
        return users;
    }

    public static List<Group> getGroupToNotify(StatusValueNotificationLevel notificationLevel, List<String> groupNames) {
        GroupRepository groupRepository = (GroupRepository)ApplicationContextHolder.get().getBean(GroupRepository.class);
        List<Object> groups = new ArrayList<Group>();
        if (notificationLevel != null && notificationLevel == StatusValueNotificationLevel.recordGroupEmail) {
            groups = groupRepository.findAll(GroupSpecs.inGroupNames(groupNames));
        }
        return groups;
    }

    private void unsetAllOperations(int mdId) throws Exception {
        Log.trace((String)"geonetwork.datamanager", (Object)("DefaultStatusActions.unsetAllOperations(" + mdId + ")"));
        int allGroup = 1;
        for (ReservedOperation op : ReservedOperation.values()) {
            this.dm.forceUnsetOperation(this.context, mdId, allGroup, op.getId());
        }
    }

    private String getTranslatedStatusName(int statusValueId) {
        String translatedStatusName = "";
        StatusValue s = this.statusValueRepository.findOneById(statusValueId);
        translatedStatusName = s == null ? statusValueId + " (Status not found in database translation table. Check the content of the StatusValueDes table.)" : s.getLabel(this.language);
        return translatedStatusName;
    }

    protected void sendEmail(String sendTo, String subject, String message) {
        if (!this.emailNotes) {
            this.context.info("Would send email \nTo: " + sendTo + "\nSubject: " + subject + "\n Message:\n" + message);
        } else {
            ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
            SettingManager sm = (SettingManager)applicationContext.getBean(SettingManager.class);
            if (StringUtils.isNotBlank((String)sm.getValue("system/feedback/mailServer/username")) && StringUtils.isNotBlank((String)sm.getValue("system/feedback/mailServer/host"))) {
                ArrayList<String> to = new ArrayList<String>();
                to.add(sendTo);
                MailUtil.sendMail(to, subject, message, null, sm, this.replyTo, this.replyToDescr);
            }
        }
    }
}

