/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc17.db;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.SqlJetTransactionMode;
import org.tmatesoft.sqljet.core.table.ISqlJetCursor;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetInsertStatement;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetSelectStatement;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetStatement;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNExternal;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDbRoot;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbShared;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbStatementUtil;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbCreateSchema;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbNodesBase;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbNodesCurrent;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSchema;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbStatements;
import org.tmatesoft.svn.core.wc2.ISvnObjectReceiver;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnWcDbProperties
extends SvnWcDbShared {
    private static final int WC__NO_REVERT_FILES = 4;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SVNProperties readProperties(SVNWCDbRoot root, File relpath) throws SVNException {
        SVNSqlJetStatement stmt;
        SVNProperties props;
        block5: {
            block4: {
                SVNProperties sVNProperties;
                props = null;
                stmt = null;
                try {
                    stmt = root.getSDb().getStatement(SVNWCDbStatements.SELECT_ACTUAL_PROPS);
                    stmt.bindf("is", root.getWcId(), relpath);
                    if (stmt.next() && !SvnWcDbStatementUtil.isColumnNull(stmt, SVNWCDbSchema.ACTUAL_NODE__Fields.properties)) {
                        props = SvnWcDbStatementUtil.getColumnProperties(stmt, SVNWCDbSchema.ACTUAL_NODE__Fields.properties);
                    }
                    if (props == null) break block4;
                    sVNProperties = props;
                }
                catch (Throwable throwable) {
                    SvnWcDbStatementUtil.reset(stmt);
                    throw throwable;
                }
                SvnWcDbStatementUtil.reset(stmt);
                return sVNProperties;
            }
            props = SvnWcDbProperties.readPristineProperties(root, relpath);
            if (props != null) break block5;
            SVNProperties sVNProperties = new SVNProperties();
            SvnWcDbStatementUtil.reset(stmt);
            return sVNProperties;
        }
        SvnWcDbStatementUtil.reset(stmt);
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SVNProperties readPristineProperties(SVNWCDbRoot root, File relpath) throws SVNException {
        SVNSqlJetStatement stmt = root.getSDb().getStatement(SVNWCDbStatements.SELECT_NODE_PROPS);
        try {
            ISVNWCDb.SVNWCDbStatus presence;
            stmt.bindf("is", root.getWcId(), relpath);
            if (!stmt.next()) {
                SvnWcDbProperties.nodeNotFound(root.getAbsPath(relpath));
            }
            if ((presence = SvnWcDbStatementUtil.getColumnPresence(stmt)) == ISVNWCDb.SVNWCDbStatus.BaseDeleted) {
                boolean haveRow = stmt.next();
                assert (haveRow);
                presence = SvnWcDbStatementUtil.getColumnPresence(stmt);
            }
            if (presence == ISVNWCDb.SVNWCDbStatus.Normal || presence == ISVNWCDb.SVNWCDbStatus.Incomplete) {
                SVNProperties props = SvnWcDbStatementUtil.getColumnProperties(stmt, SVNWCDbSchema.NODES__Fields.properties);
                if (props == null) {
                    props = new SVNProperties();
                }
                SVNProperties sVNProperties = props;
                return sVNProperties;
            }
            SVNProperties sVNProperties = null;
            return sVNProperties;
        }
        finally {
            SvnWcDbStatementUtil.reset(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readPropertiesRecursively(SVNWCDbRoot root, File relpath, SVNDepth depth, boolean baseProperties, boolean pristineProperties, Collection<String> changelists, ISvnObjectReceiver<SVNProperties> receiver) throws SVNException {
        SVNSqlJetSelectStatement stmt = null;
        root.getSDb().getTemporaryDb().beginTransaction(SqlJetTransactionMode.WRITE);
        try {
            try {
                SvnWcDbProperties.cacheProperties(root, relpath, depth, baseProperties, pristineProperties, changelists);
                stmt = new SVNSqlJetSelectStatement(root.getSDb().getTemporaryDb(), SVNWCDbSchema.NODE_PROPS_CACHE);
                while (stmt.next()) {
                    SVNProperties props = SvnWcDbStatementUtil.getColumnProperties(stmt, SVNWCDbSchema.NODE_PROPS_CACHE__Fields.properties);
                    File target = SvnWcDbStatementUtil.getColumnPath(stmt, SVNWCDbSchema.NODE_PROPS_CACHE__Fields.local_Relpath);
                    File absolutePath = root.getAbsPath(target);
                    receiver.receive(SvnTarget.fromFile(absolutePath), props);
                }
            }
            catch (Throwable throwable) {
                SvnWcDbStatementUtil.reset(stmt);
                SVNWCDbCreateSchema dropCache = new SVNWCDbCreateSchema(root.getSDb().getTemporaryDb(), SVNWCDbCreateSchema.DROP_NODE_PROPS_CACHE, -1);
                try {
                    dropCache.done();
                }
                finally {
                    dropCache.reset();
                }
                throw throwable;
            }
            SvnWcDbStatementUtil.reset(stmt);
            SVNWCDbCreateSchema dropCache = new SVNWCDbCreateSchema(root.getSDb().getTemporaryDb(), SVNWCDbCreateSchema.DROP_NODE_PROPS_CACHE, -1);
            try {
                dropCache.done();
            }
            finally {
                dropCache.reset();
            }
        }
        catch (SVNException e) {
            root.getSDb().getTemporaryDb().rollback();
            throw e;
        }
        finally {
            root.getSDb().getTemporaryDb().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setActualProps(SVNWCDbRoot root, File localRelPath, SVNProperties properties) throws SVNException {
        SVNSqlJetStatement stmt = root.getSDb().getStatement(SVNWCDbStatements.UPDATE_ACTUAL_PROPS);
        long affectedRows = 0L;
        try {
            stmt.bindf("is", root.getWcId(), localRelPath);
            stmt.bindProperties(3, properties);
            affectedRows = stmt.exec();
        }
        finally {
            stmt.reset();
        }
        if (affectedRows == 1L || properties.size() == 0) {
            return;
        }
        try {
            stmt = root.getSDb().getStatement(SVNWCDbStatements.INSERT_ACTUAL_PROPS);
            stmt.bindf("is", root.getWcId(), localRelPath);
            if (localRelPath != null) {
                stmt.bindString(3, SVNFileUtil.getFilePath(SVNFileUtil.getFileDir(localRelPath)));
            }
            stmt.bindProperties(4, properties);
            stmt.exec();
        }
        finally {
            stmt.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void upgradeApplyProperties(SVNWCDbRoot root, File dirAbsPath, File localRelPath, SVNProperties baseProps, SVNProperties workingProps, SVNProperties revertProps, int originalFormat) throws SVNException {
        SVNProperties diffs;
        long affectedRows;
        long topOpDepth = -1L;
        long belowOpDepth = -1L;
        ISVNWCDb.SVNWCDbStatus topPresence = ISVNWCDb.SVNWCDbStatus.NotPresent;
        ISVNWCDb.SVNWCDbStatus belowPresence = ISVNWCDb.SVNWCDbStatus.NotPresent;
        ISVNWCDb.SVNWCDbKind kind = ISVNWCDb.SVNWCDbKind.Unknown;
        SVNSqlJetStatement stmt = root.getSDb().getStatement(SVNWCDbStatements.SELECT_NODE_INFO);
        try {
            stmt.bindf("is", root.getWcId(), localRelPath);
            boolean haveRow = stmt.next();
            if (haveRow) {
                topOpDepth = SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.op_depth);
                topPresence = SvnWcDbStatementUtil.getColumnPresence(stmt, SVNWCDbSchema.NODES__Fields.presence);
                kind = SvnWcDbStatementUtil.getColumnKind(stmt, SVNWCDbSchema.NODES__Fields.kind);
                haveRow = stmt.next();
                if (haveRow) {
                    belowOpDepth = SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.op_depth);
                    belowPresence = SvnWcDbStatementUtil.getColumnPresence(stmt, SVNWCDbSchema.NODES__Fields.presence);
                }
            }
        }
        finally {
            stmt.reset();
        }
        if (originalFormat > 4 && revertProps == null && topOpDepth != -1L && topPresence == ISVNWCDb.SVNWCDbStatus.Normal && belowOpDepth != -1L && belowPresence != ISVNWCDb.SVNWCDbStatus.NotPresent) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT, "The properties of ''{0}'' are in an indeterminate state and cannot be upgraded. See issue #2530.", (Object)SVNFileUtil.createFilePath(dirAbsPath, localRelPath));
            SVNErrorManager.error(err, SVNLogType.WC);
            return;
        }
        if (topOpDepth == -1L || belowOpDepth == -1L && revertProps != null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT, "Insufficient NODES rows for ''{0}''", (Object)SVNFileUtil.createFilePath(dirAbsPath, localRelPath));
            SVNErrorManager.error(err, SVNLogType.WC);
            return;
        }
        if (revertProps != null || belowOpDepth == -1L) {
            stmt = root.getSDb().getStatement(SVNWCDbStatements.UPDATE_NODE_PROPS);
            try {
                stmt.bindf("isi", root.getWcId(), localRelPath, topOpDepth);
                stmt.bindProperties(4, baseProps);
                affectedRows = stmt.exec();
                assert (affectedRows == 1L);
            }
            finally {
                stmt.reset();
            }
        }
        if (belowOpDepth != -1L) {
            SVNProperties props = revertProps != null ? revertProps : baseProps;
            stmt = root.getSDb().getStatement(SVNWCDbStatements.UPDATE_NODE_PROPS);
            try {
                stmt.bindf("isi", root.getWcId(), localRelPath, belowOpDepth);
                stmt.bindProperties(4, props);
                affectedRows = stmt.exec();
                assert (affectedRows == 1L);
            }
            finally {
                stmt.reset();
            }
        }
        if (workingProps != null && baseProps != null && (diffs = FSRepositoryUtil.getPropsDiffs(workingProps, baseProps)).isEmpty()) {
            workingProps.clear();
        }
        if (workingProps != null) {
            SvnWcDbProperties.setActualProps(root, localRelPath, workingProps);
        }
        if (kind == ISVNWCDb.SVNWCDbKind.Dir) {
            String externals;
            SVNProperties props = workingProps;
            if (props == null) {
                props = baseProps;
            }
            String string = externals = props != null ? props.getStringValue("svn:externals") : null;
            if (externals != null && !"".equals(externals)) {
                SVNExternal[] externalsList;
                for (SVNExternal externalItem : externalsList = SVNExternal.parseExternals(SVNFileUtil.createFilePath(dirAbsPath, localRelPath), externals)) {
                    File itemRelPah = SVNFileUtil.createFilePath(localRelPath, externalItem.getPath());
                    stmt = root.getSDb().getStatement(SVNWCDbStatements.INSERT_EXTERNAL_UPGRADE);
                    try {
                        stmt.bindf("issssis", root.getWcId(), itemRelPah, SVNFileUtil.getFilePath(SVNFileUtil.getFileDir(itemRelPah)), SvnWcDbStatementUtil.getPresenceText(ISVNWCDb.SVNWCDbStatus.Normal), localRelPath, 1, "");
                        stmt.exec();
                    }
                    finally {
                        stmt.reset();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void upgradeApplyDavCache(SVNWCDbRoot root, File dirRelPath, Map<String, SVNProperties> cacheValues) throws SVNException {
        SVNSqlJetStatement selectRoot = root.getSDb().getStatement(SVNWCDbStatements.SELECT_WCROOT_NULL);
        long wcId = 0L;
        try {
            if (selectRoot.next()) {
                wcId = selectRoot.getColumnLong(SVNWCDbSchema.WCROOT__Fields.id);
            }
        }
        finally {
            selectRoot.reset();
        }
        for (String name : cacheValues.keySet()) {
            SVNProperties props = cacheValues.get(name);
            if (props.size() <= 0) continue;
            File localRelPath = SVNFileUtil.createFilePath(dirRelPath, name);
            SVNSqlJetStatement stmt = root.getSDb().getStatement(SVNWCDbStatements.UPDATE_BASE_NODE_DAV_CACHE);
            stmt.bindf("is", wcId, localRelPath);
            stmt.bindProperties(3, props);
            try {
                stmt.exec();
            }
            finally {
                stmt.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cacheProperties(SVNWCDbRoot root, File relpath, SVNDepth depth, boolean baseProperties, boolean pristineProperties, Collection<String> changelists) throws SVNException {
        SVNSqlJetStatement stmt = null;
        InsertIntoPropertiesCache insertStmt = null;
        SVNSqlJetSelectStatement propertiesSelectStmt = null;
        root.getSDb().beginTransaction(SqlJetTransactionMode.READ_ONLY);
        try {
            SvnWcDbProperties.collectTargets(root, relpath, depth, changelists);
            stmt = new SVNWCDbCreateSchema(root.getSDb().getTemporaryDb(), SVNWCDbCreateSchema.NODE_PROPS_CACHE, -1);
            try {
                stmt.done();
            }
            finally {
                stmt.reset();
            }
            propertiesSelectStmt = baseProperties ? new SVNWCDbNodesBase(root.getSDb()) : (pristineProperties ? new SVNWCDbNodesCurrent(root.getSDb()) : new SVNWCDbNodesCurrent(root.getSDb()));
            insertStmt = new InsertIntoPropertiesCache(root.getSDb().getTemporaryDb());
            stmt = new SVNSqlJetSelectStatement(root.getSDb().getTemporaryDb(), SVNWCDbSchema.TARGETS_LIST);
            stmt.bindf("i", root.getWcId());
            while (stmt.next()) {
                byte[] props;
                String kind;
                String localRelpath;
                block38: {
                    localRelpath = SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.TARGETS_LIST__Fields.local_relpath);
                    long wcId = SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.TARGETS_LIST__Fields.wc_id);
                    kind = SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.TARGETS_LIST__Fields.kind);
                    propertiesSelectStmt.bindf("is", wcId, localRelpath);
                    props = null;
                    try {
                        if (!propertiesSelectStmt.next()) break block38;
                        ISVNWCDb.SVNWCDbStatus presence = SvnWcDbStatementUtil.getColumnPresence(propertiesSelectStmt);
                        if (baseProperties) {
                            if (presence == ISVNWCDb.SVNWCDbStatus.Normal || presence == ISVNWCDb.SVNWCDbStatus.Incomplete) {
                                props = SvnWcDbStatementUtil.getColumnBlob(propertiesSelectStmt, SVNWCDbSchema.NODES__Fields.properties);
                            }
                            break block38;
                        }
                        if (pristineProperties) {
                            long rowOpDepth;
                            if (presence == ISVNWCDb.SVNWCDbStatus.Normal || presence == ISVNWCDb.SVNWCDbStatus.Incomplete || presence == ISVNWCDb.SVNWCDbStatus.BaseDeleted) {
                                props = SvnWcDbStatementUtil.getColumnBlob(propertiesSelectStmt, SVNWCDbSchema.NODES__Fields.properties);
                            }
                            if (props != null || (rowOpDepth = SvnWcDbStatementUtil.getColumnInt64(propertiesSelectStmt, SVNWCDbSchema.NODES__Fields.op_depth)) <= 0L || SvnWcDbStatementUtil.getColumnPresence(propertiesSelectStmt, SVNWCDbSchema.NODES__Fields.presence) != ISVNWCDb.SVNWCDbStatus.BaseDeleted) break block38;
                            SelectRowWithMaxOpDepth query = new SelectRowWithMaxOpDepth(root.getSDb(), rowOpDepth);
                            try {
                                query.bindf("is", wcId, localRelpath);
                                if (query.next()) {
                                    props = SvnWcDbStatementUtil.getColumnBlob(query, SVNWCDbSchema.NODES__Fields.properties);
                                }
                                break block38;
                            }
                            finally {
                                SvnWcDbStatementUtil.reset(query);
                            }
                        }
                        if (presence == ISVNWCDb.SVNWCDbStatus.Normal || presence == ISVNWCDb.SVNWCDbStatus.Incomplete) {
                            props = SvnWcDbStatementUtil.getColumnBlob(propertiesSelectStmt, SVNWCDbSchema.NODES__Fields.properties);
                        }
                        SVNSqlJetSelectStatement query = new SVNSqlJetSelectStatement(root.getSDb(), SVNWCDbSchema.ACTUAL_NODE);
                        byte[] actualProps = null;
                        try {
                            query.bindf("is", wcId, localRelpath);
                            if (query.next()) {
                                actualProps = SvnWcDbStatementUtil.getColumnBlob(query, SVNWCDbSchema.ACTUAL_NODE__Fields.properties);
                            }
                        }
                        finally {
                            SvnWcDbStatementUtil.reset(query);
                        }
                        props = actualProps != null ? actualProps : props;
                    }
                    finally {
                        SvnWcDbStatementUtil.reset(propertiesSelectStmt);
                    }
                }
                if (props == null || props.length <= 2) continue;
                try {
                    insertStmt.putInsertValue(SVNWCDbSchema.NODE_PROPS_CACHE__Fields.local_Relpath, localRelpath);
                    insertStmt.putInsertValue(SVNWCDbSchema.NODE_PROPS_CACHE__Fields.kind, kind);
                    insertStmt.putInsertValue(SVNWCDbSchema.NODE_PROPS_CACHE__Fields.properties, props);
                    insertStmt.exec();
                }
                finally {
                    insertStmt.reset();
                }
            }
        }
        catch (Throwable throwable) {
            try {
                SvnWcDbStatementUtil.reset(stmt);
                SvnWcDbStatementUtil.reset(insertStmt);
                SvnWcDbStatementUtil.reset(propertiesSelectStmt);
                SVNWCDbCreateSchema dropTargets = new SVNWCDbCreateSchema(root.getSDb().getTemporaryDb(), SVNWCDbCreateSchema.DROP_TARGETS_LIST, -1);
                try {
                    dropTargets.done();
                }
                finally {
                    dropTargets.reset();
                }
            }
            finally {
                root.getSDb().commit();
            }
            throw throwable;
        }
        try {
            SvnWcDbStatementUtil.reset(stmt);
            SvnWcDbStatementUtil.reset(insertStmt);
            SvnWcDbStatementUtil.reset(propertiesSelectStmt);
            SVNWCDbCreateSchema dropTargets = new SVNWCDbCreateSchema(root.getSDb().getTemporaryDb(), SVNWCDbCreateSchema.DROP_TARGETS_LIST, -1);
            try {
                dropTargets.done();
            }
            finally {
                dropTargets.reset();
            }
        }
        finally {
            root.getSDb().commit();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InsertIntoPropertiesCache
    extends SVNSqlJetInsertStatement {
        private HashMap<String, Object> insertValues = new HashMap();

        public InsertIntoPropertiesCache(SVNSqlJetDb sDb) throws SVNException {
            super(sDb, SVNWCDbSchema.NODE_PROPS_CACHE);
        }

        public void putInsertValue(Enum<?> f, Object value) {
            this.insertValues.put(f.toString(), value);
        }

        @Override
        public void reset() throws SVNException {
            super.reset();
            this.insertValues.clear();
        }

        @Override
        protected Map<String, Object> getInsertValues() throws SVNException {
            return this.insertValues;
        }
    }

    private static class SelectRowWithMaxOpDepth
    extends SVNSqlJetSelectStatement {
        private long opDepth;

        public SelectRowWithMaxOpDepth(SVNSqlJetDb sDb, long opDepth) throws SVNException {
            super(sDb, SVNWCDbSchema.NODES);
            this.opDepth = opDepth;
        }

        protected ISqlJetCursor openCursor() throws SVNException {
            try {
                return super.openCursor().reverse();
            }
            catch (SqlJetException e) {
                return null;
            }
        }

        protected boolean isFilterPassed() throws SVNException {
            long rowOpDepth = this.getColumnLong(SVNWCDbSchema.NODES__Fields.op_depth);
            return rowOpDepth < this.opDepth;
        }
    }
}

