/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.search.provider.iface;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Table;
import org.hibernate.annotations.CollectionOfElements;
import org.hibernate.annotations.MapKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="JZ_IR_SERVICE_DESCRIPTOR")
public class IRServiceDescriptor {
    private Long id;
    private String protocol;
    private String code;
    private Map preferences = new HashMap();
    private List auth_styles = new ArrayList();

    public IRServiceDescriptor() {
    }

    public IRServiceDescriptor(String simple_string_descriptor) {
        if (simple_string_descriptor != null) {
            String[] assignments = IRServiceDescriptor.tokenize(simple_string_descriptor);
            System.err.println("Processing " + assignments.length + " assignments");
            for (int i = 0; i < assignments.length; ++i) {
                String[] components = assignments[i].split("=");
                System.err.println(components[0] + "=" + components[1]);
                if (components.length != 2) continue;
                if (components[0].equals("proto")) {
                    this.setProtocol(components[1]);
                    continue;
                }
                if (components[0].equals("code")) {
                    this.setCode(components[1]);
                    continue;
                }
                if (components[1].startsWith("'")) {
                    this.preferences.put(components[0], components[1].substring(1, components[1].length() - 1));
                    continue;
                }
                this.preferences.put(components[0], components[1]);
            }
            if (this.code == null) {
                this.code = UUID.randomUUID().toString();
            }
        }
    }

    private static String[] tokenize(String descriptor) {
        return descriptor.split(",(?=([^']*'[^']*')*(?![^']*'))");
    }

    @Id
    @Column(name="ID")
    @GeneratedValue(strategy=GenerationType.AUTO)
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Column(name="CODE", length=50)
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Column(name="PROTO", length=50)
    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    @CollectionOfElements(fetch=FetchType.EAGER)
    @JoinTable(name="JZ_IR_DESCRIPTOR_PROPS", joinColumns={@JoinColumn(name="DESCRIPTOR_ID")})
    @MapKey(columns={@Column(name="PROP_NAME", length=128)})
    @Column(name="PROP_VALUE", length=128)
    public Map<String, String> getPreferences() {
        return this.preferences;
    }

    public void setPreferences(Map<String, String> preferences) {
        this.preferences = preferences;
    }

    public void setPreference(String name, Object value) {
        this.preferences.put(name, value);
    }

    public Object getPreference(String name, Object default_value) {
        Object result = this.preferences.get(name);
        if (result == null) {
            return default_value;
        }
        return result;
    }

    public String toString() {
        return this.code + " " + this.protocol + " " + this.preferences;
    }
}

