/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;

public final class ConvertDeclaredTypesToJSDoc
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    private final AbstractCompiler compiler;

    ConvertDeclaredTypesToJSDoc(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node scriptRoot) {
        NodeTraversal.traverse(this.compiler, scriptRoot, this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        Node.TypeDeclarationNode type = n.getDeclaredTypeExpression();
        if (type == null) {
            return;
        }
        JSDocInfo info = n.getJSDocInfo();
        Preconditions.checkState((info == null || info.getType() == null ? 1 : 0) != 0, (Object)"Nodes must not have both type declarations and JSDoc types");
        JSDocInfoBuilder builder = JSDocInfoBuilder.maybeCopyFrom(info);
        Node typeRoot = this.convertWithLocation(type);
        JSTypeExpression typeExpression = new JSTypeExpression(typeRoot, n.getSourceFileName());
        if (n.isFunction()) {
            builder.recordReturnType(typeExpression);
        } else if (n.getType() == 179) {
            builder.recordType(typeExpression);
        } else {
            builder.recordType(typeExpression);
            builder.recordInlineType();
        }
        info = builder.build();
        n.setJSDocInfo(info);
        n.setDeclaredTypeExpression(null);
    }

    private Node convertWithLocation(Node type) {
        return this.convertDeclaredTypeToJSDoc(type).copyInformationFrom(type);
    }

    private Node convertDeclaredTypeToJSDoc(Node type) {
        Preconditions.checkArgument((boolean)(type instanceof Node.TypeDeclarationNode));
        switch (type.getType()) {
            case 200: {
                return IR.string("string");
            }
            case 201: {
                return IR.string("boolean");
            }
            case 202: {
                return IR.string("number");
            }
            case 209: {
                return IR.string("void");
            }
            case 206: {
                return new Node(304);
            }
            case 211: {
                return this.convertNamedType(type);
            }
            case 215: {
                Node arrayType = IR.string("Array");
                Node memberType = this.convertWithLocation(type.getFirstChild());
                arrayType.addChildToFront(new Node(125, memberType).copyInformationFrom(type));
                return new Node(306, arrayType);
            }
            case 204: {
                Node namedType = type.getFirstChild();
                Node result = this.convertWithLocation(namedType);
                Node typeParameterTarget = result.getType() == 306 ? result.getFirstChild() : result;
                Node parameters = IR.block().copyInformationFrom(type);
                typeParameterTarget.addChildToFront(parameters);
                for (Node param = namedType.getNext(); param != null; param = param.getNext()) {
                    parameters.addChildToBack(this.convertWithLocation(param));
                }
                return result;
            }
        }
        throw new IllegalArgumentException("Unexpected node type for type conversion: " + type.getType());
    }

    private Node convertNamedType(Node type) {
        Node propTree = type.getFirstChild();
        String dotted = propTree.getQualifiedName();
        return new Node(306, IR.string(dotted));
    }
}

