/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.repository.specification;

import java.util.ArrayList;
import java.util.Arrays;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.SetJoin;
import javax.persistence.criteria.Subquery;
import org.fao.geonet.domain.Link;
import org.fao.geonet.domain.Link_;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.domain.MetadataLink_;
import org.fao.geonet.domain.MetadataSourceInfo_;
import org.fao.geonet.domain.Metadata_;
import org.fao.geonet.domain.OperationAllowed;
import org.fao.geonet.domain.OperationAllowedId_;
import org.fao.geonet.domain.OperationAllowed_;
import org.fao.geonet.domain.ReservedOperation;
import org.springframework.data.jpa.domain.Specification;

public class LinkSpecs {
    private LinkSpecs() {
    }

    public static Specification<Link> filter(final String urlPartToContain, final Integer state, final String associatedRecord, final Integer[] groupPublishedIds, final Integer[] groupOwnerIds, final Integer[] editingGroupIds) {
        return new Specification<Link>(){

            public Predicate toPredicate(Root<Link> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                Predicate groupOwnerPredicate;
                SetJoin metadataJoin;
                ArrayList<Predicate> predicates = new ArrayList<Predicate>();
                if (state != null) {
                    Path statePath = root.get(Link_.lastState);
                    predicates.add(cb.equal((Expression)statePath, (Object)state));
                }
                if (urlPartToContain != null) {
                    Path urlPath = root.get(Link_.url);
                    predicates.add(cb.like((Expression)urlPath, cb.literal((Object)String.format("%%%s%%", urlPartToContain))));
                }
                if (associatedRecord != null) {
                    metadataJoin = root.join(Link_.records, JoinType.INNER);
                    predicates.add(cb.like((Expression)metadataJoin.get("metadataUuid"), cb.literal((Object)String.format("%%%s%%", associatedRecord))));
                }
                metadataJoin = root.join(Link_.records, JoinType.INNER);
                Subquery subquery = query.subquery(Integer.class);
                Root opAllowRoot = subquery.from(OperationAllowed.class);
                Root metadataRoot = subquery.from(Metadata.class);
                boolean editinGroupQuery = editingGroupIds != null && editingGroupIds.length > 0;
                boolean groupPublishedQuery = groupPublishedIds != null && groupPublishedIds.length > 0;
                boolean groupOwnerQuery = groupOwnerIds != null && groupOwnerIds.length > 0;
                ArrayList<Predicate> subQueryPredicates = new ArrayList<Predicate>();
                if (editinGroupQuery) {
                    groupOwnerPredicate = metadataRoot.get(Metadata_.sourceInfo).get(MetadataSourceInfo_.groupOwner).in((Object[])editingGroupIds);
                    Predicate metadataOperations = cb.equal((Expression)metadataRoot.get(Metadata_.id), (Expression)opAllowRoot.get(OperationAllowed_.id).get(OperationAllowedId_.metadataId));
                    Predicate editableGroups = opAllowRoot.get(OperationAllowed_.id).get(OperationAllowedId_.groupId).in(Arrays.asList(editingGroupIds));
                    Predicate operationTypeEdit = cb.equal((Expression)opAllowRoot.get(OperationAllowed_.id).get(OperationAllowedId_.operationId), cb.literal((Object)ReservedOperation.editing.getId()));
                    subQueryPredicates.add(cb.or((Expression)cb.and((Expression)metadataOperations, (Expression)groupOwnerPredicate), (Expression)cb.and((Expression)editableGroups, (Expression)operationTypeEdit)));
                }
                if (groupPublishedQuery) {
                    Predicate publishedToIndicatedGroup = opAllowRoot.get(OperationAllowed_.id).get(OperationAllowedId_.groupId).in((Object[])groupPublishedIds);
                    Predicate operationTypeView = cb.equal((Expression)opAllowRoot.get(OperationAllowed_.id).get(OperationAllowedId_.operationId), cb.literal((Object)ReservedOperation.view.getId()));
                    subQueryPredicates.add(cb.and((Expression)publishedToIndicatedGroup, (Expression)operationTypeView));
                }
                if (groupOwnerQuery) {
                    groupOwnerPredicate = metadataRoot.get(Metadata_.sourceInfo).get(MetadataSourceInfo_.groupOwner).in((Object[])groupOwnerIds);
                    subQueryPredicates.add(groupOwnerPredicate);
                }
                if (subQueryPredicates.size() > 0) {
                    subquery.where(subQueryPredicates.toArray(new Predicate[0]));
                    Path opAllowedMetadataId = opAllowRoot.get(OperationAllowed_.id).get(OperationAllowedId_.metadataId);
                    subquery.select((Expression)opAllowedMetadataId);
                    predicates.add(metadataJoin.get(MetadataLink_.metadataId).in(new Expression[]{subquery}));
                }
                query.distinct(true);
                return cb.and(predicates.toArray(new Predicate[0]));
            }
        };
    }
}

