/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.repository;

import java.io.Serializable;
import javax.persistence.EntityManager;
import org.fao.geonet.repository.GeonetRepositoryImpl;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.support.JpaRepositoryFactory;
import org.springframework.data.jpa.repository.support.JpaRepositoryFactoryBean;
import org.springframework.data.querydsl.QueryDslPredicateExecutor;
import org.springframework.data.querydsl.QueryDslUtils;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;

public class GeonetRepositoryFactoryBean<R extends JpaRepository<T, I>, T, I extends Serializable>
extends JpaRepositoryFactoryBean<R, T, I> {
    protected RepositoryFactorySupport createRepositoryFactory(EntityManager entityManager) {
        return new GeonetRepositoryFactory(entityManager);
    }

    private static class GeonetRepositoryFactory<T, I extends Serializable>
    extends JpaRepositoryFactory {
        private EntityManager entityManager;

        public GeonetRepositoryFactory(EntityManager entityManager) {
            super(entityManager);
            this.entityManager = entityManager;
        }

        protected Object getTargetRepository(RepositoryMetadata metadata) {
            Class repositoryInterface = metadata.getRepositoryInterface();
            if (this.isQueryDslExecutor(repositoryInterface)) {
                return super.getTargetRepository(metadata);
            }
            return new GeonetRepositoryImpl(metadata.getDomainType(), this.entityManager);
        }

        protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
            if (this.isQueryDslExecutor(metadata.getRepositoryInterface())) {
                return super.getRepositoryBaseClass(metadata);
            }
            return GeonetRepositoryImpl.class;
        }

        private boolean isQueryDslExecutor(Class<?> repositoryInterface) {
            return QueryDslUtils.QUERY_DSL_PRESENT && QueryDslPredicateExecutor.class.isAssignableFrom(repositoryInterface);
        }
    }
}

