/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.domain;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.domain.GeonetEntity;
import org.fao.geonet.domain.InspireAtomFeedEntry;
import org.fao.geonet.utils.Xml;
import org.hibernate.annotations.Type;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;

@Entity
@Access(value=AccessType.PROPERTY)
@Table(name="InspireAtomFeed", indexes={@Index(name="idx_inspireatomfeed_metadataid", columnList="metadataid"), @Index(name="idx_inspireatomfeed_atomDatasetid", columnList="atomDatasetid"), @Index(name="idx_inspireatomfeed_atomDatasetns", columnList="atomDatasetns")})
@SequenceGenerator(name="inspire_atom_feed_id_seq", initialValue=100, allocationSize=1)
public class InspireAtomFeed
extends GeonetEntity
implements Serializable {
    static final String ID_SEQ_NAME = "inspire_atom_feed_id_seq";
    private int _id;
    private int _metadataId;
    private String _title;
    private String _atom;
    private String _atomUrl;
    private String _atomDatasetid;
    private String _atomDatasetns;
    private String _subtitle;
    private String _rights;
    private String _lang;
    private String _authorName;
    private String _authorEmail;
    private List<InspireAtomFeedEntry> _entryList = new ArrayList<InspireAtomFeedEntry>();

    public static InspireAtomFeed build(Element atomDoc) {
        Element authorEl;
        InspireAtomFeed inspireAtomFeed = new InspireAtomFeed();
        Namespace ns = Namespace.getNamespace((String)"f", (String)"http://www.w3.org/2005/Atom");
        Namespace nsXml = Namespace.getNamespace((String)"xml", (String)"http://www.w3.org/XML/1998/namespace");
        inspireAtomFeed.setTitle(StringUtils.left((String)atomDoc.getChildText("title", ns), (int)255));
        if (atomDoc.getChildText("subtitle", ns) != null) {
            inspireAtomFeed.setSubtitle(StringUtils.left((String)atomDoc.getChildText("subtitle", ns), (int)255));
        }
        if (atomDoc.getChildText("rights", ns) != null) {
            inspireAtomFeed.setRights(StringUtils.left((String)atomDoc.getChildText("rights", ns), (int)255));
        }
        if ((authorEl = atomDoc.getChild("author", ns)) != null) {
            inspireAtomFeed.setAuthorName(StringUtils.left((String)atomDoc.getChild("author", ns).getChildText("name", ns), (int)255));
            inspireAtomFeed.setAuthorEmail(StringUtils.left((String)atomDoc.getChild("author", ns).getChildText("email", ns), (int)255));
        }
        try {
            Element selfLinkEl = Xml.selectElement((Element)atomDoc, (String)"f:link[@rel='self']", (List)Lists.newArrayList((Object[])new Namespace[]{ns, nsXml}));
            if (selfLinkEl != null) {
                inspireAtomFeed.setLang(selfLinkEl.getAttributeValue("hreflang", ""));
            }
        }
        catch (JDOMException selfLinkEl) {
            // empty catch block
        }
        if (StringUtils.isEmpty((String)inspireAtomFeed.getLang())) {
            inspireAtomFeed.setLang(atomDoc.getAttributeValue("lang", nsXml, ""));
        }
        List entryList = atomDoc.getChildren("entry", ns);
        for (Element entry : entryList) {
            for (Element linkEl : entry.getChildren("link", ns)) {
                if (!linkEl.getAttributeValue("rel", "").equals("alternate") && !linkEl.getAttributeValue("rel", "").equals("section")) continue;
                InspireAtomFeedEntry inspireAtomFeedEntry = new InspireAtomFeedEntry();
                inspireAtomFeedEntry.setTitle(StringUtils.left((String)entry.getChildText("title", ns), (int)255));
                if (entry.getChildText("category", ns) != null) {
                    inspireAtomFeedEntry.setCrs(entry.getChild("category", ns).getAttributeValue("term"));
                }
                inspireAtomFeedEntry.setType(linkEl.getAttributeValue("type", ""));
                inspireAtomFeedEntry.setLang(linkEl.getAttributeValue("hreflang", ""));
                inspireAtomFeedEntry.setUrl(linkEl.getAttributeValue("href"));
                inspireAtomFeed.addEntry(inspireAtomFeedEntry);
            }
        }
        return inspireAtomFeed;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="inspire_atom_feed_id_seq")
    @Column(nullable=false)
    public int getId() {
        return this._id;
    }

    public InspireAtomFeed setId(int _id) {
        this._id = _id;
        return this;
    }

    public int getMetadataId() {
        return this._metadataId;
    }

    public void setMetadataId(Integer metadataId) {
        this._metadataId = metadataId;
    }

    @Column(length=255)
    public String getTitle() {
        return this._title;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    @Column
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    public String getAtom() {
        return this._atom;
    }

    public void setAtom(String atom) {
        this._atom = atom;
    }

    @Column(length=255)
    public String getAtomUrl() {
        return this._atomUrl;
    }

    public void setAtomUrl(String atomUrl) {
        this._atomUrl = atomUrl;
    }

    @Column(length=255)
    public String getAtomDatasetid() {
        return this._atomDatasetid;
    }

    @Column(length=255)
    public void setAtomDatasetid(String atomDatasetid) {
        this._atomDatasetid = atomDatasetid;
    }

    public String getAtomDatasetns() {
        return this._atomDatasetns;
    }

    public void setAtomDatasetns(String atomDatasetns) {
        this._atomDatasetns = atomDatasetns;
    }

    @Column(length=255)
    public String getSubtitle() {
        return this._subtitle;
    }

    public void setSubtitle(String subtitle) {
        this._subtitle = subtitle;
    }

    @Column(length=255)
    public String getRights() {
        return this._rights;
    }

    public void setRights(String rights) {
        this._rights = rights;
    }

    @Column(length=3)
    public String getLang() {
        return this._lang;
    }

    public void setLang(String lang) {
        this._lang = lang;
    }

    @Column(length=255)
    public String getAuthorName() {
        return this._authorName;
    }

    public void setAuthorName(String authorName) {
        this._authorName = authorName;
    }

    @Column(length=255)
    public String getAuthorEmail() {
        return this._authorEmail;
    }

    public void setAuthorEmail(String authorEmail) {
        this._authorEmail = authorEmail;
    }

    @ElementCollection(fetch=FetchType.EAGER, targetClass=InspireAtomFeedEntry.class)
    public List<InspireAtomFeedEntry> getEntryList() {
        return this._entryList;
    }

    public void setEntryList(List<InspireAtomFeedEntry> entryList) {
        this._entryList = entryList;
    }

    public void addEntry(InspireAtomFeedEntry entry) {
        this._entryList.add(entry);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InspireAtomFeed that = (InspireAtomFeed)o;
        if (this._id != that._id) {
            return false;
        }
        if (this._metadataId != that._metadataId) {
            return false;
        }
        if (!Objects.equals(this._title, that._title)) {
            return false;
        }
        if (!Objects.equals(this._atom, that._atom)) {
            return false;
        }
        if (!Objects.equals(this._atomUrl, that._atomUrl)) {
            return false;
        }
        if (!Objects.equals(this._atomDatasetid, that._atomDatasetid)) {
            return false;
        }
        if (!Objects.equals(this._atomDatasetns, that._atomDatasetns)) {
            return false;
        }
        if (!Objects.equals(this._subtitle, that._subtitle)) {
            return false;
        }
        if (!Objects.equals(this._rights, that._rights)) {
            return false;
        }
        if (!Objects.equals(this._lang, that._lang)) {
            return false;
        }
        if (!Objects.equals(this._authorName, that._authorName)) {
            return false;
        }
        if (!Objects.equals(this._authorEmail, that._authorEmail)) {
            return false;
        }
        return Objects.equals(this._entryList, that._entryList);
    }

    public int hashCode() {
        return Objects.hash(this._id, this._metadataId, this._title, this._atom, this._atomUrl, this._atomDatasetid, this._atomDatasetns, this._subtitle, this._rights, this._lang, this._authorName, this._authorEmail, this._entryList);
    }
}

