/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.route53.binders;

import java.util.Iterator;
import javax.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.StringPayload;
import org.jclouds.rest.Binder;
import org.jclouds.route53.domain.ChangeBatch;
import org.jclouds.route53.functions.SerializeRRS;

@Singleton
public class BindChangeBatch
implements Binder {
    private static final SerializeRRS xml = new SerializeRRS();

    public <R extends HttpRequest> R bindToRequest(R request, Object payload) {
        ChangeBatch from = (ChangeBatch)((Object)ChangeBatch.class.cast(payload));
        StringBuilder b = new StringBuilder();
        b.append("<ChangeResourceRecordSetsRequest xmlns=\"https://route53.amazonaws.com/doc/2012-02-29/\"><ChangeBatch>");
        if (from.getComment().isPresent()) {
            b.append("<Comment>").append((String)from.getComment().get()).append("</Comment>");
        }
        b.append("<Changes>");
        Iterator iterator = from.iterator();
        while (iterator.hasNext()) {
            ChangeBatch.ActionOnResourceRecordSet change = (ChangeBatch.ActionOnResourceRecordSet)iterator.next();
            b.append("<Change>").append("<Action>").append((Object)change.getAction()).append("</Action>").append(xml.apply(change.getRRS())).append("</Change>");
        }
        b.append("</Changes>");
        b.append("</ChangeBatch></ChangeResourceRecordSetsRequest>");
        StringPayload xmlPayload = Payloads.newStringPayload((String)b.toString());
        xmlPayload.getContentMetadata().setContentType("application/xml");
        return (R)((HttpRequest.Builder)request.toBuilder().payload((Payload)xmlPayload)).build();
    }
}

