/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.attachments;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.s3.model.CopyObjectResult;
import com.amazonaws.services.s3.model.ListObjectsV2Result;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Nullable;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.api.records.attachments.AbstractStore;
import org.fao.geonet.api.records.attachments.FilesystemStoreResource;
import org.fao.geonet.api.records.attachments.FilesystemStoreResourceContainer;
import org.fao.geonet.api.records.attachments.Store;
import org.fao.geonet.domain.MetadataResource;
import org.fao.geonet.domain.MetadataResourceContainer;
import org.fao.geonet.domain.MetadataResourceVisibility;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.resources.S3Credentials;
import org.springframework.beans.factory.annotation.Autowired;

public class S3Store
extends AbstractStore {
    @Autowired
    S3Credentials s3;
    @Autowired
    SettingManager settingManager;

    @Override
    public List<MetadataResource> getResources(ServiceContext context, String metadataUuid, MetadataResourceVisibility visibility, String filter, Boolean approved) throws Exception {
        int metadataId = this.canEdit(context, metadataUuid, approved);
        String resourceTypeDir = this.getMetadataDir(metadataId) + "/" + visibility.toString();
        ArrayList<MetadataResource> resourceList = new ArrayList<MetadataResource>();
        if (filter == null) {
            filter = "*.*";
        }
        PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:" + filter);
        ListObjectsV2Result objects = this.s3.getClient().listObjectsV2(this.s3.getBucket(), resourceTypeDir);
        for (S3ObjectSummary object : objects.getObjectSummaries()) {
            String key = object.getKey();
            String filename = S3Store.getFilename(key);
            Path keyPath = new File(filename).toPath().getFileName();
            if (!matcher.matches(keyPath)) continue;
            MetadataResource resource = this.createResourceDescription(metadataUuid, visibility, filename, object.getSize(), object.getLastModified(), metadataId, approved);
            resourceList.add(resource);
        }
        resourceList.sort(MetadataResourceVisibility.sortByFileName);
        return resourceList;
    }

    private MetadataResource createResourceDescription(String metadataUuid, MetadataResourceVisibility visibility, String resourceId, long size, Date lastModification, int metadataId, boolean approved) {
        return new FilesystemStoreResource(metadataUuid, metadataId, this.getFilename(metadataUuid, resourceId), this.settingManager.getNodeURL() + "api/records/", visibility, size, lastModification, approved);
    }

    private static String getFilename(String key) {
        String[] splittedKey = key.split("/");
        return splittedKey[splittedKey.length - 1];
    }

    @Override
    public Store.ResourceHolder getResource(ServiceContext context, String metadataUuid, MetadataResourceVisibility visibility, String resourceId, Boolean approved) throws Exception {
        int metadataId = this.canDownload(context, metadataUuid, visibility, approved);
        try {
            S3Object object = this.s3.getClient().getObject(this.s3.getBucket(), this.getKey(metadataUuid, metadataId, visibility, resourceId));
            return new ResourceHolderImpl(object, this.createResourceDescription(metadataUuid, visibility, resourceId, object.getObjectMetadata().getContentLength(), object.getObjectMetadata().getLastModified(), metadataId, approved));
        }
        catch (AmazonServiceException ignored) {
            throw new ResourceNotFoundException(String.format("Metadata resource '%s' not found for metadata '%s'", resourceId, metadataUuid)).withMessageKey("exception.resourceNotFound.resource", new String[]{resourceId}).withDescriptionKey("exception.resourceNotFound.resource.description", new String[]{resourceId, metadataUuid});
        }
    }

    private String getKey(String metadataUuid, int metadataId, MetadataResourceVisibility visibility, String resourceId) throws Exception {
        this.checkResourceId(resourceId);
        String metadataDir = this.getMetadataDir(metadataId);
        return metadataDir + "/" + visibility.toString() + "/" + this.getFilename(metadataUuid, resourceId);
    }

    @Override
    public MetadataResource putResource(ServiceContext context, String metadataUuid, String filename, InputStream is, @Nullable Date changeDate, MetadataResourceVisibility visibility, Boolean approved) throws Exception {
        int metadataId = this.canEdit(context, metadataUuid, approved);
        String key = this.getKey(metadataUuid, metadataId, visibility, filename);
        ObjectMetadata metadata = new ObjectMetadata();
        if (changeDate != null) {
            metadata.setLastModified(changeDate);
        }
        PutObjectResult putAnswer = this.s3.getClient().putObject(this.s3.getBucket(), key, is, metadata);
        return this.createResourceDescription(metadataUuid, visibility, filename, putAnswer.getMetadata().getContentLength(), putAnswer.getMetadata().getLastModified(), metadataId, approved);
    }

    @Override
    public MetadataResource patchResourceStatus(ServiceContext context, String metadataUuid, String resourceId, MetadataResourceVisibility visibility, Boolean approved) throws Exception {
        int metadataId = this.canEdit(context, metadataUuid, approved);
        String sourceKey = null;
        ObjectMetadata metadata = null;
        for (MetadataResourceVisibility sourceVisibility : MetadataResourceVisibility.values()) {
            String key = this.getKey(metadataUuid, metadataId, sourceVisibility, resourceId);
            try {
                metadata = this.s3.getClient().getObjectMetadata(this.s3.getBucket(), key);
                if (sourceVisibility == visibility) {
                    return this.createResourceDescription(metadataUuid, visibility, resourceId, metadata.getContentLength(), metadata.getLastModified(), metadataId, approved);
                }
                sourceKey = key;
                break;
            }
            catch (AmazonServiceException amazonServiceException) {
            }
        }
        if (sourceKey != null) {
            String destKey = this.getKey(metadataUuid, metadataId, visibility, resourceId);
            CopyObjectResult copyResult = this.s3.getClient().copyObject(this.s3.getBucket(), sourceKey, this.s3.getBucket(), destKey);
            this.s3.getClient().deleteObject(this.s3.getBucket(), sourceKey);
            return this.createResourceDescription(metadataUuid, visibility, resourceId, metadata.getContentLength(), copyResult.getLastModifiedDate(), metadataId, approved);
        }
        throw new ResourceNotFoundException(String.format("Metadata resource '%s' not found for metadata '%s'", resourceId, metadataUuid));
    }

    @Override
    public String delResources(ServiceContext context, String metadataUuid, Boolean approved) throws Exception {
        int metadataId = this.canEdit(context, metadataUuid, approved);
        try {
            ListObjectsV2Result objects = this.s3.getClient().listObjectsV2(this.s3.getBucket(), this.getMetadataDir(metadataId));
            for (S3ObjectSummary object : objects.getObjectSummaries()) {
                this.s3.getClient().deleteObject(this.s3.getBucket(), object.getKey());
            }
            return String.format("Metadata '%s' directory removed.", metadataId);
        }
        catch (AmazonServiceException e) {
            return String.format("Unable to remove metadata '%s' directory.", metadataId);
        }
    }

    @Override
    public String delResource(ServiceContext context, String metadataUuid, String resourceId, Boolean approved) throws Exception {
        int metadataId = this.canEdit(context, metadataUuid, approved);
        for (MetadataResourceVisibility visibility : MetadataResourceVisibility.values()) {
            if (!this.tryDelResource(metadataUuid, metadataId, visibility, resourceId)) continue;
            return String.format("MetadataResource '%s' removed.", resourceId);
        }
        return String.format("Unable to remove resource '%s'.", resourceId);
    }

    @Override
    public String delResource(ServiceContext context, String metadataUuid, MetadataResourceVisibility visibility, String resourceId, Boolean approved) throws Exception {
        int metadataId = this.canEdit(context, metadataUuid, approved);
        if (this.tryDelResource(metadataUuid, metadataId, visibility, resourceId)) {
            return String.format("MetadataResource '%s' removed.", resourceId);
        }
        return String.format("Unable to remove resource '%s'.", resourceId);
    }

    private boolean tryDelResource(String metadataUuid, int metadataId, MetadataResourceVisibility visibility, String resourceId) throws Exception {
        String key = this.getKey(metadataUuid, metadataId, visibility, resourceId);
        if (this.s3.getClient().doesObjectExist(this.s3.getBucket(), key)) {
            this.s3.getClient().deleteObject(this.s3.getBucket(), key);
            return true;
        }
        return false;
    }

    @Override
    public MetadataResource getResourceDescription(ServiceContext context, String metadataUuid, MetadataResourceVisibility visibility, String filename, Boolean approved) throws Exception {
        int metadataId = S3Store.getAndCheckMetadataId(metadataUuid, approved);
        String key = this.getKey(metadataUuid, metadataId, visibility, filename);
        try {
            ObjectMetadata metadata = this.s3.getClient().getObjectMetadata(this.s3.getBucket(), key);
            return this.createResourceDescription(metadataUuid, visibility, filename, metadata.getContentLength(), metadata.getLastModified(), metadataId, approved);
        }
        catch (AmazonServiceException e) {
            return null;
        }
    }

    @Override
    public MetadataResourceContainer getResourceContainerDescription(ServiceContext context, String metadataUuid, Boolean approved) throws Exception {
        int metadataId = S3Store.getAndCheckMetadataId(metadataUuid, approved);
        return new FilesystemStoreResourceContainer(metadataUuid, metadataId, metadataUuid, this.settingManager.getNodeURL() + "api/records/", approved);
    }

    private String getMetadataDir(int metadataId) {
        return this.s3.getKeyPrefix() + metadataId;
    }

    private static class ResourceHolderImpl
    implements Store.ResourceHolder {
        private Path path;
        private final MetadataResource metadata;

        public ResourceHolderImpl(S3Object object, MetadataResource metadata) throws IOException {
            this.path = Files.createTempFile("", S3Store.getFilename(object.getKey()), new FileAttribute[0]);
            this.metadata = metadata;
            try (S3ObjectInputStream in = object.getObjectContent();){
                Files.copy((InputStream)in, this.path, StandardCopyOption.REPLACE_EXISTING);
            }
        }

        @Override
        public Path getPath() {
            return this.path;
        }

        @Override
        public MetadataResource getMetadata() {
            return this.metadata;
        }

        @Override
        public void close() throws IOException {
            if (this.path != null) {
                Files.delete(this.path);
                this.path = null;
            }
        }

        protected void finalize() throws Throwable {
            this.close();
            super.finalize();
        }
    }
}

