/*
 * Decompiled with CFR 0.152.
 */
package org.apache.env;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Properties;
import org.apache.env.WhichClass;
import org.apache.env.WhichJar;
import org.apache.env.WhichProject;

public abstract class WhichFactory {
    public static final String DEFAULT_WHICHCLASS = "org.apache.env.Which";
    public static final String SERVICE_NAME = "WhichFactory";
    private static final String WHICHFACTORY_PROPS = "org/apache/env/WhichFactory.properties";
    protected static Properties installedWhichers = new Properties();

    public static WhichProject newWhichProject(String string, String string2) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class clazz;
        try {
            clazz = WhichClass.findClass(string, string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                String string3 = installedWhichers.getProperty(string);
                if (null == string3) {
                    throw new ClassNotFoundException();
                }
                clazz = WhichClass.findClass(string3, string2);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                clazz = WhichClass.findClass(DEFAULT_WHICHCLASS + string, string2);
            }
        }
        if (null == clazz) {
            throw new ClassNotFoundException(string);
        }
        return (WhichProject)clazz.newInstance();
    }

    private static void loadWhichInstall(Properties properties, String string) {
        if (null == properties) {
            properties = new Properties();
        }
        try {
            InputStream inputStream = null;
            try {
                Class[] classArray = new Class[]{};
                Object[] objectArray = new Object[]{};
                Method method = Thread.class.getMethod("getContextClassLoader", classArray);
                if (method != null) {
                    ClassLoader classLoader = (ClassLoader)method.invoke((Object)Thread.currentThread(), objectArray);
                    inputStream = classLoader.getResourceAsStream(string);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (null == inputStream) {
                inputStream = WhichJar.class.getResourceAsStream("/" + string);
            }
            properties.load(inputStream);
            inputStream.close();
        }
        catch (Exception exception) {
            System.err.println("WhichFactory loadJarTable threw: " + exception.toString());
            exception.printStackTrace();
        }
    }

    static {
        WhichFactory.loadWhichInstall(installedWhichers, WHICHFACTORY_PROPS);
    }
}

