/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudwatch.options;

import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Set;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.cloudwatch.domain.Dimension;
import org.jclouds.cloudwatch.domain.Unit;
import org.jclouds.http.options.BaseHttpRequestOptions;

public class GetMetricStatisticsOptions
extends BaseHttpRequestOptions {
    private Set<Dimension> dimensions;

    public GetMetricStatisticsOptions dimension(Dimension dimension) {
        if (this.dimensions == null) {
            this.dimensions = Sets.newLinkedHashSet();
        }
        this.dimensions.add(dimension);
        return this;
    }

    public GetMetricStatisticsOptions dimensions(Set<Dimension> dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    public GetMetricStatisticsOptions instanceId(String instanceId) {
        String[] parts = AWSUtils.parseHandle((String)instanceId);
        this.formParameters.put((Object)"Dimensions.member.1.Name", (Object)"InstanceId");
        this.formParameters.put((Object)"Dimensions.member.1.Value", Preconditions.checkNotNull((Object)parts[1]));
        return this;
    }

    public GetMetricStatisticsOptions unit(Unit unit) {
        this.formParameters.put((Object)"Unit", (Object)unit.toString());
        return this;
    }

    public Multimap<String, String> buildFormParameters() {
        Multimap formParameters = super.buildFormParameters();
        int dimensionIndex = 1;
        if (this.dimensions != null) {
            for (Dimension dimension : this.dimensions) {
                formParameters.put((Object)("Dimensions.member." + dimensionIndex + ".Name"), (Object)dimension.getName());
                formParameters.put((Object)("Dimensions.member." + dimensionIndex + ".Value"), (Object)dimension.getValue());
                ++dimensionIndex;
            }
        }
        return formParameters;
    }

    public static class Builder {
        public static GetMetricStatisticsOptions instanceId(String instanceId) {
            GetMetricStatisticsOptions options = new GetMetricStatisticsOptions();
            return options.instanceId(instanceId);
        }

        public static GetMetricStatisticsOptions unit(Unit unit) {
            GetMetricStatisticsOptions options = new GetMetricStatisticsOptions();
            return options.unit(unit);
        }

        public static GetMetricStatisticsOptions dimension(Dimension dimension) {
            GetMetricStatisticsOptions options = new GetMetricStatisticsOptions();
            return options.dimension(dimension);
        }

        public static GetMetricStatisticsOptions dimensions(Set<Dimension> dimensions) {
            GetMetricStatisticsOptions options = new GetMetricStatisticsOptions();
            return options.dimensions(dimensions);
        }
    }
}

