/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet;

import com.google.common.util.concurrent.Callables;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.servlet.ServletContext;
import javax.sql.DataSource;
import jeeves.server.sources.http.ServletPathFinder;
import org.fao.geonet.Constants;
import org.fao.geonet.DatabaseMigrationTask;
import org.fao.geonet.Logger;
import org.fao.geonet.SystemInfo;
import org.fao.geonet.domain.Pair;
import org.fao.geonet.lib.DatabaseType;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Version;
import org.locationtech.jts.util.Assert;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.web.context.WebApplicationContext;

public class DatabaseMigration
implements BeanPostProcessor {
    private static final int VERSION_NUMBER_ID_BEFORE_2_11 = 15;
    private static final int SUBVERSION_NUMBER_ID_BEFORE_2_11 = 16;
    private static final String JAVA_MIGRATION_PREFIX = "java:";
    @Autowired
    private SystemInfo systemInfo;
    @Autowired
    private ApplicationContext _applicationContext;
    private Callable<Map<String, List<String>>> _migration;
    private String initAfter;
    private Logger _logger = Log.createLogger((String)"geonetwork.databasemigration");
    private boolean foundErrors;

    public final Object postProcessBeforeInitialization(Object bean, String beanName) {
        return bean;
    }

    public final Object postProcessAfterInitialization(Object bean, String beanName) {
        block7: {
            try {
                if (!Class.forName(this.initAfter).isInstance(bean)) break block7;
                this._logger.debug(String.format("DB Migration / Running '%s' after initialization of '%s'.", bean.getClass(), this.initAfter));
                try {
                    ServletContext servletContext;
                    try {
                        servletContext = (ServletContext)this._applicationContext.getBean(ServletContext.class);
                    }
                    catch (NoSuchBeanDefinitionException e) {
                        if (this._applicationContext instanceof WebApplicationContext) {
                            WebApplicationContext context = (WebApplicationContext)this._applicationContext;
                            servletContext = context.getServletContext();
                        }
                        this._logger.warning("No servletContext found.  Database migration aborted.");
                        return bean;
                    }
                    String version = this.systemInfo.getVersion();
                    String subVersion = this.systemInfo.getSubVersion();
                    ServletPathFinder pathFinder = new ServletPathFinder(servletContext);
                    Path path = pathFinder.getAppPath();
                    DataSource ds = bean instanceof JpaTransactionManager ? ((JpaTransactionManager)bean).getDataSource() : (DataSource)bean;
                    this.migrateDatabase(servletContext, path, ds, version, subVersion);
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
                return bean;
            }
            catch (ClassNotFoundException e) {
                this._logger.error(String.format("DB Migration / '%s' is an invalid value for initAfter. Class not found. Error is %s", this.initAfter, e.getMessage()));
                this._logger.error((Throwable)e);
            }
        }
        return bean;
    }

    public final void setMigration(Map<String, List<String>> migration) {
        this._migration = Callables.returning(migration);
    }

    public final void setMigrationLoader(Callable<Map<String, List<String>>> migration) {
        this._migration = migration;
    }

    private void migrateDatabase(ServletContext servletContext, Path path, DataSource dataSource, String webappVersion, String subVersion) throws Exception {
        this._logger.info("  - Migration ...");
        try (Connection conn = dataSource.getConnection();
             Statement statement = conn.createStatement();){
            this.foundErrors = this.doMigration(webappVersion, subVersion, servletContext, path, conn, statement);
            conn.commit();
        }
        catch (Exception e) {
            this._logger.warning("  - Migration: Exception running migration for version: " + webappVersion + " subversion: " + subVersion + ". " + e.getMessage());
            throw e;
        }
    }

    boolean doMigration(String webappVersion, String subVersion, ServletContext servletContext, Path path, Connection conn, Statement statement) throws Exception {
        Pair<String, String> dbVersionInfo = this.getDatabaseVersion(statement);
        String dbVersion = (String)dbVersionInfo.one();
        String dbSubVersion = (String)dbVersionInfo.two();
        boolean anyMigrationError = false;
        this._logger.info("      Webapp   version:" + webappVersion + " subversion:" + subVersion);
        this._logger.info("      Database version:" + dbVersion + " subversion:" + dbSubVersion);
        if (dbVersion == null) {
            this._logger.warning("      Unable to retrieve the current GeoNetwork version from the database. If this is an initial run of the software, then the database will be auto-populated. Else check that the database is properly configured");
            return true;
        }
        if (webappVersion == null) {
            this._logger.warning("      Unable to retrieve the GeoNetwork version from the application code.");
            return true;
        }
        Version from = new Version();
        Version to = new Version();
        try {
            from = Version.parseVersionNumber((String)dbVersion);
        }
        catch (Exception e) {
            this._logger.warning("      Error parsing the GeoNetwork version (" + dbVersion + "." + dbSubVersion + ") from the database: " + e.getMessage());
            this._logger.error((Throwable)e);
        }
        try {
            to = Version.parseVersionNumber((String)webappVersion);
        }
        catch (Exception e) {
            this._logger.warning("      Error parsing GeoNetwork version (" + webappVersion + "." + subVersion + ") from the application code: " + e.getMessage());
            this._logger.error((Throwable)e);
        }
        switch (from.compareTo(to)) {
            case 1: {
                this._logger.info("      Running on a newer database version.");
                break;
            }
            case 0: {
                this._logger.info("      Application version equals the Database version, no migration task to apply.");
                break;
            }
            case -1: {
                boolean anyMigrationAction = false;
                String dbType = DatabaseType.lookup((Connection)conn).toString();
                this._logger.debug("      Migrating from " + from + " to " + to + " (dbtype:" + dbType + ")...");
                this._logger.info("      Loading SQL migration step configuration from <?xml version=\"1.0\" encoding=\"UTF-8\"?>\n ...");
                for (Map.Entry<String, List<String>> migrationEntry : this._migration.call().entrySet()) {
                    Version versionNumber = Version.parseVersionNumber((String)migrationEntry.getKey());
                    if (versionNumber.compareTo(from) <= 0 || versionNumber.compareTo(to) >= 1) continue;
                    this._logger.info("       - running tasks for " + versionNumber + "...");
                    for (String file : migrationEntry.getValue()) {
                        if (file.startsWith(JAVA_MIGRATION_PREFIX)) {
                            anyMigrationAction = true;
                            anyMigrationError |= this.runJavaMigration(conn, file);
                            continue;
                        }
                        int lastSep = file.lastIndexOf(47);
                        Assert.isTrue((lastSep > -1 ? 1 : 0) != 0, (String)(file + " has the wrong format"));
                        Path filePath = path.resolve(file.substring(0, lastSep));
                        String filePrefix = file.substring(lastSep + 1);
                        anyMigrationAction = true;
                        this._logger.info("         - SQL migration file:" + filePath + " prefix:" + filePrefix + " ...");
                        try {
                            Lib.db.insertData(servletContext, statement, path, filePath, filePrefix);
                        }
                        catch (Exception e) {
                            this._logger.info("          Errors occurs during SQL migration file: " + e.getMessage());
                            this._logger.error((Throwable)e);
                            anyMigrationError = true;
                        }
                    }
                }
                if (anyMigrationAction && !anyMigrationError) {
                    this._logger.info("      Successful migration.\n      Catalogue administrator still need to update the catalogue\n      logo and data directory in order to complete the migration process.\n      Lucene index rebuild is also recommended after migration.");
                }
                if (!anyMigrationAction) {
                    this._logger.warning("      No migration task found between webapp and database version.\n      The system may be unstable or may failed to start if you try to run \n      the current GeoNetwork " + webappVersion + " with an older database (ie. " + dbVersion + "\n      ). Try to run the migration task manually on the current database\n      before starting the application or start with a new empty database.\n      Sample SQL scripts for migration could be found in WEB-INF/sql/migrate folder.\n");
                }
                if (!anyMigrationError) break;
                this._logger.warning("      Error occurs during migration. Check the log file for more details.");
                break;
            }
            default: {
                throw new Error("Unrecognized value: " + to.compareTo(from) + " when comparing " + to + " -> " + from);
            }
        }
        return anyMigrationError;
    }

    private boolean runJavaMigration(Connection conn, String file) {
        try {
            String className = file.substring(JAVA_MIGRATION_PREFIX.length());
            this._logger.info("         - Java migration class:" + className);
            DatabaseMigrationTask task = (DatabaseMigrationTask)Class.forName(className).newInstance();
            task.setContext(this._applicationContext);
            task.update(conn);
            return false;
        }
        catch (SQLException e) {
            StringBuilder error = new StringBuilder();
            this.formatSqlException(e, error);
            SQLException next = e.getNextException();
            while (next != null) {
                this.formatSqlException(next, error);
                next = e.getNextException();
            }
            try {
                ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream();
                PrintStream writer = new PrintStream((OutputStream)byteArrayStream, true, Constants.ENCODING);
                e.printStackTrace(writer);
                error.append("\n    Stack Trace: \n").append(byteArrayStream.toString(Constants.ENCODING));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            this._logger.error("          Errors occurs during Java migration file: " + error);
            return true;
        }
        catch (Throwable e) {
            this._logger.error("          Errors occurs during Java migration file: " + e.getMessage());
            this._logger.error(e);
            return true;
        }
    }

    private void formatSqlException(SQLException e, StringBuilder error) {
        error.append("\n    SQLState: ").append(e.getSQLState());
        error.append("\n    Error Code: ").append(e.getErrorCode());
        error.append("\n    Message: ").append(e.getMessage());
    }

    private Pair<String, String> getDatabaseVersion(Statement statement) throws SQLException {
        String version = null;
        String subversion = null;
        try {
            version = this.newLookup(statement, "system/platform/version");
            subversion = this.newLookup(statement, "system/platform/subVersion");
            if (version == null) {
                version = this.oldLookup(statement, 15);
                subversion = this.oldLookup(statement, 16);
            }
        }
        catch (SQLException e) {
            this._logger.info("     Error getting database version: " + e.getMessage() + ". Probably due to an old version. Trying with new Settings structure.");
        }
        return Pair.read((Object)version, (Object)subversion);
    }

    private String newLookup(Statement statement, String key) throws SQLException {
        String newGetVersion = "SELECT value FROM Settings WHERE name = '" + key + "'";
        try (ResultSet results = statement.executeQuery(newGetVersion);){
            if (results.next()) {
                String string = results.getString(1);
                return string;
            }
            String string = null;
            return string;
        }
    }

    private String oldLookup(Statement statement, int key) throws SQLException {
        String newGetVersion = "SELECT value FROM Settings WHERE id = " + key;
        try (ResultSet results = statement.executeQuery(newGetVersion);){
            if (results.next()) {
                String string = results.getString(1);
                return string;
            }
            String string = null;
            return string;
        }
    }

    public boolean isFoundErrors() {
        return this.foundErrors;
    }

    public String getInitAfter() {
        return this.initAfter;
    }

    public void setInitAfter(String initAfter) {
        this.initAfter = initAfter;
    }
}

