/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.gson.annotations.SerializedName;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.jclouds.chef.domain.ChecksumStatus;
import org.jclouds.chef.util.CollectionUtils;
import org.jclouds.javax.annotation.Nullable;

public class UploadSandbox {
    private final URI uri;
    private final Map<List<Byte>, ChecksumStatus> checksums;
    @SerializedName(value="sandbox_id")
    private final String sandboxId;

    public static Builder builder() {
        return new Builder();
    }

    @ConstructorProperties(value={"uri", "checksums", "sandbox_id"})
    protected UploadSandbox(URI uri, @Nullable Map<List<Byte>, ChecksumStatus> checksums, String sandboxId) {
        this.uri = uri;
        this.checksums = CollectionUtils.copyOfOrEmpty(checksums);
        this.sandboxId = sandboxId;
    }

    public URI getUri() {
        return this.uri;
    }

    public Map<List<Byte>, ChecksumStatus> getChecksums() {
        return this.checksums;
    }

    public String getSandboxId() {
        return this.sandboxId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.checksums == null ? 0 : this.checksums.hashCode());
        result = 31 * result + (this.sandboxId == null ? 0 : this.sandboxId.hashCode());
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UploadSandbox other = (UploadSandbox)obj;
        if (this.checksums == null ? other.checksums != null : !this.checksums.equals(other.checksums)) {
            return false;
        }
        if (this.sandboxId == null ? other.sandboxId != null : !this.sandboxId.equals(other.sandboxId)) {
            return false;
        }
        return !(this.uri == null ? other.uri != null : !this.uri.equals(other.uri));
    }

    public String toString() {
        return "UploadSandbox [checksums=" + this.checksums + ", id=" + this.sandboxId + ", uri=" + this.uri + "]";
    }

    public static class Builder {
        private URI uri;
        private ImmutableMap.Builder<List<Byte>, ChecksumStatus> checksums = ImmutableMap.builder();
        private String sandboxId;

        public Builder uri(URI uri) {
            this.uri = (URI)Preconditions.checkNotNull((Object)uri, (Object)"uri");
            return this;
        }

        public Builder checksum(List<Byte> key, ChecksumStatus value) {
            this.checksums.put(Preconditions.checkNotNull(key, (Object)"key"), Preconditions.checkNotNull((Object)value, (Object)"value"));
            return this;
        }

        public Builder checksums(Map<List<Byte>, ChecksumStatus> checksums) {
            this.checksums.putAll((Map)Preconditions.checkNotNull(checksums, (Object)"checksums"));
            return this;
        }

        public Builder sandboxId(String sandboxId) {
            this.sandboxId = (String)Preconditions.checkNotNull((Object)sandboxId, (Object)"sandboxId");
            return this;
        }

        public UploadSandbox build() {
            return new UploadSandbox(this.uri, (Map<List<Byte>, ChecksumStatus>)this.checksums.build(), this.sandboxId);
        }
    }
}

