/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.binders;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.Map;
import javax.inject.Inject;
import org.jclouds.chef.options.CreateClientOptions;
import org.jclouds.http.HttpRequest;
import org.jclouds.json.Json;
import org.jclouds.rest.binders.BindToJsonPayload;
import org.jclouds.rest.internal.GeneratedHttpRequest;

public class BindCreateClientOptionsToJsonPayload
extends BindToJsonPayload {
    @Inject
    public BindCreateClientOptionsToJsonPayload(Json jsonBinder) {
        super(jsonBinder);
    }

    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        Preconditions.checkArgument((boolean)(Preconditions.checkNotNull(request, (Object)"request") instanceof GeneratedHttpRequest), (Object)"this binder is only valid for GeneratedHttpRequests");
        GeneratedHttpRequest gRequest = (GeneratedHttpRequest)request;
        Preconditions.checkState((gRequest.getInvocation().getArgs() != null ? 1 : 0) != 0, (Object)"args should be initialized at this point");
        String name = Preconditions.checkNotNull((Object)postParams.remove("name"), (Object)"name").toString();
        CreateClientOptions options = (CreateClientOptions)Iterables.find((Iterable)gRequest.getInvocation().getArgs(), (Predicate)Predicates.instanceOf(CreateClientOptions.class));
        return (R)this.bindToRequest(request, new CreateClientParams(name, options));
    }

    private static class CreateClientParams {
        private String name;
        private boolean admin;

        public CreateClientParams(String name, CreateClientOptions options) {
            this.name = name;
            this.admin = options.isAdmin();
        }
    }
}

