/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.simple;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geotools.feature.GeometryAttributeImpl;
import org.geotools.feature.simple.SimpleFeatureTypeImpl;
import org.geotools.feature.type.AttributeDescriptorImpl;
import org.geotools.feature.type.Types;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.geometry.jts.coordinatesequence.CoordinateSequences;
import org.geotools.util.Converters;
import org.geotools.util.SuppressFBWarnings;
import org.geotools.util.Utilities;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.GeometryAttribute;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.GeometryType;
import org.opengis.feature.type.Name;
import org.opengis.filter.identity.FeatureId;
import org.opengis.filter.identity.Identifier;
import org.opengis.geometry.BoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class SimpleFeatureImpl
implements SimpleFeature {
    protected FeatureId id;
    protected SimpleFeatureType featureType;
    protected Object[] values;
    protected Map<String, Integer> index;
    protected Map<Object, Object> userData;
    protected Map<Object, Object>[] attributeUserData;
    protected boolean validating;

    public SimpleFeatureImpl(List<Object> values, SimpleFeatureType featureType, FeatureId id) {
        this(values.toArray(), featureType, id, false, SimpleFeatureImpl.index(featureType));
    }

    public SimpleFeatureImpl(Object[] values, SimpleFeatureType featureType, FeatureId id, boolean validating) {
        this(values, featureType, id, validating, SimpleFeatureImpl.index(featureType));
    }

    public SimpleFeatureImpl(Object[] values, SimpleFeatureType featureType, FeatureId id, boolean validating, Map<String, Integer> index) {
        this.id = id;
        this.featureType = featureType;
        this.values = values;
        this.validating = validating;
        this.index = index;
        if (validating) {
            this.validate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Integer> index(SimpleFeatureType featureType) {
        if (featureType instanceof SimpleFeatureTypeImpl) {
            return ((SimpleFeatureTypeImpl)featureType).index;
        }
        SimpleFeatureType simpleFeatureType = featureType;
        synchronized (simpleFeatureType) {
            Object cache = featureType.getUserData().get("indexLookup");
            if (cache instanceof Map) {
                return (Map)cache;
            }
            Map<String, Integer> generatedIndex = SimpleFeatureTypeImpl.buildIndex(featureType);
            featureType.getUserData().put("indexLookup", generatedIndex);
            return generatedIndex;
        }
    }

    public FeatureId getIdentifier() {
        return this.id;
    }

    public String getID() {
        return this.id.getID();
    }

    public int getNumberOfAttributes() {
        return this.values.length;
    }

    public Object getAttribute(int index) throws IndexOutOfBoundsException {
        return this.values[index];
    }

    public Object getAttribute(String name) {
        Integer idx = this.index.get(name);
        if (idx != null) {
            return this.getAttribute(idx);
        }
        return null;
    }

    public Object getAttribute(Name name) {
        return this.getAttribute(name.getLocalPart());
    }

    public int getAttributeCount() {
        return this.values.length;
    }

    public List<Object> getAttributes() {
        return new ArrayList<Object>(Arrays.asList(this.values));
    }

    public Object getDefaultGeometry() {
        GeometryDescriptor geometryDescriptor;
        Object defaultGeometry;
        Integer idx = this.index.get(null);
        Object object = defaultGeometry = idx != null ? this.getAttribute(idx) : null;
        if (defaultGeometry == null && (geometryDescriptor = this.featureType.getGeometryDescriptor()) != null) {
            Integer defaultGeomIndex = this.index.get(geometryDescriptor.getName().getLocalPart());
            defaultGeometry = this.getAttribute(defaultGeomIndex);
        }
        return defaultGeometry;
    }

    public SimpleFeatureType getFeatureType() {
        return this.featureType;
    }

    public SimpleFeatureType getType() {
        return this.featureType;
    }

    public void setAttribute(int index, Object value) throws IndexOutOfBoundsException {
        Object converted = Converters.convert((Object)value, (Class)this.getFeatureType().getDescriptor(index).getType().getBinding());
        if (this.validating) {
            Types.validate(this.featureType.getDescriptor(index), converted);
        }
        this.values[index] = converted;
    }

    public void setAttribute(String name, Object value) {
        Integer idx = this.index.get(name);
        if (idx == null) {
            throw new IllegalAttributeException("Unknown attribute " + name);
        }
        this.setAttribute(idx, value);
    }

    public void setAttribute(Name name, Object value) {
        this.setAttribute(name.getLocalPart(), value);
    }

    public void setAttributes(List<Object> values) {
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = values.get(i);
        }
    }

    public void setAttributes(Object[] values) {
        this.setAttributes(Arrays.asList(values));
    }

    public void setDefaultGeometry(Object geometry) {
        Integer geometryIndex = this.index.get(null);
        if (geometryIndex != null) {
            this.setAttribute(geometryIndex, geometry);
        }
    }

    public BoundingBox getBounds() {
        CoordinateReferenceSystem crs = this.featureType.getCoordinateReferenceSystem();
        ReferencedEnvelope bounds = ReferencedEnvelope.create(crs);
        for (Object o : this.values) {
            if (!(o instanceof Geometry)) continue;
            Geometry g = (Geometry)o;
            if (bounds.isNull()) {
                bounds.init(JTS.bounds(g, crs));
                continue;
            }
            bounds.expandToInclude(JTS.bounds(g, crs));
        }
        return bounds;
    }

    public GeometryAttribute getDefaultGeometryProperty() {
        GeometryDescriptor geometryDescriptor = this.featureType.getGeometryDescriptor();
        GeometryAttributeImpl geometryAttribute = null;
        if (geometryDescriptor != null) {
            Object defaultGeometry = this.getDefaultGeometry();
            geometryAttribute = new GeometryAttributeImpl(defaultGeometry, geometryDescriptor, null);
        }
        return geometryAttribute;
    }

    public void setDefaultGeometryProperty(GeometryAttribute geometryAttribute) {
        if (geometryAttribute != null) {
            this.setDefaultGeometry(geometryAttribute.getValue());
        } else {
            this.setDefaultGeometry(null);
        }
    }

    public Collection<Property> getProperties() {
        return new AttributeList();
    }

    public Collection<Property> getProperties(Name name) {
        return this.getProperties(name.getLocalPart());
    }

    public Collection<Property> getProperties(String name) {
        Integer idx = this.index.get(name);
        if (idx != null) {
            Set<Attribute> c = Collections.singleton(new Attribute(idx));
            return c;
        }
        return Collections.emptyList();
    }

    public Property getProperty(Name name) {
        return this.getProperty(name.getLocalPart());
    }

    public Property getProperty(String name) {
        Integer idx = this.index.get(name);
        if (idx == null) {
            return null;
        }
        int index = idx;
        AttributeDescriptor descriptor = this.featureType.getDescriptor(index);
        if (descriptor instanceof GeometryDescriptor) {
            return new GeometryAttributeImpl(this.values[index], (GeometryDescriptor)descriptor, null);
        }
        return new Attribute(index);
    }

    public Collection<? extends Property> getValue() {
        return this.getProperties();
    }

    public void setValue(Collection<Property> values) {
        int i = 0;
        for (Property p : values) {
            this.values[i++] = p.getValue();
        }
    }

    public void setValue(Object newValue) {
        this.setValue((Collection)newValue);
    }

    public AttributeDescriptor getDescriptor() {
        return new AttributeDescriptorImpl((AttributeType)this.featureType, this.featureType.getName(), 0, Integer.MAX_VALUE, true, null);
    }

    public Name getName() {
        return this.featureType.getName();
    }

    public boolean isNillable() {
        return true;
    }

    public Map<Object, Object> getUserData() {
        if (this.userData == null) {
            this.userData = new HashMap<Object, Object>();
        }
        return this.userData;
    }

    public boolean hasUserData() {
        return this.userData != null && !this.userData.isEmpty();
    }

    public int hashCode() {
        return this.id.hashCode() * this.featureType.hashCode();
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH"})
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SimpleFeatureImpl)) {
            return false;
        }
        SimpleFeatureImpl feat = (SimpleFeatureImpl)obj;
        if (this.id == null && feat.getIdentifier() != null) {
            return false;
        }
        if (!this.id.equals(feat.getIdentifier())) {
            return false;
        }
        if (!feat.getFeatureType().equals(this.featureType)) {
            return false;
        }
        int ii = this.values.length;
        for (int i = 0; i < ii; ++i) {
            Object otherAtt = feat.getAttribute(i);
            if (this.values[i] == null) {
                if (otherAtt == null) continue;
                return false;
            }
            if (this.values[i] instanceof Geometry) {
                if (!(otherAtt instanceof Geometry)) {
                    return false;
                }
                if (CoordinateSequences.equalsND((Geometry)this.values[i], (Geometry)otherAtt)) continue;
                return false;
            }
            if (this.values[i].equals(otherAtt)) continue;
            return false;
        }
        return true;
    }

    public void validate() {
        for (int i = 0; i < this.values.length; ++i) {
            AttributeDescriptor descriptor = this.getType().getDescriptor(i);
            Types.validate(descriptor, this.values[i]);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("SimpleFeatureImpl:");
        sb.append(this.getType().getName().getLocalPart());
        sb.append("=");
        sb.append(this.getValue());
        return sb.toString();
    }

    class SimpleGeometryAttribute
    extends Attribute
    implements GeometryAttribute {
        SimpleGeometryAttribute(int index) {
            super(index);
        }

        public GeometryType getType() {
            return (GeometryType)super.getType();
        }

        public GeometryDescriptor getDescriptor() {
            return (GeometryDescriptor)super.getDescriptor();
        }

        public BoundingBox getBounds() {
            ReferencedEnvelope bounds = new ReferencedEnvelope(SimpleFeatureImpl.this.featureType.getCoordinateReferenceSystem());
            Object value = SimpleFeatureImpl.this.getAttribute(this.index);
            if (value instanceof Geometry) {
                bounds.init(((Geometry)value).getEnvelopeInternal());
            }
            return bounds;
        }

        public void setBounds(BoundingBox bounds) {
        }

        @Override
        public int hashCode() {
            return 17 * super.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof SimpleGeometryAttribute)) {
                return false;
            }
            return super.equals(obj);
        }
    }

    class Attribute
    implements org.opengis.feature.Attribute {
        int index;

        Attribute(int index) {
            this.index = index;
        }

        public Identifier getIdentifier() {
            return null;
        }

        public AttributeDescriptor getDescriptor() {
            return SimpleFeatureImpl.this.featureType.getDescriptor(this.index);
        }

        public AttributeType getType() {
            return SimpleFeatureImpl.this.featureType.getType(this.index);
        }

        public Name getName() {
            return this.getDescriptor().getName();
        }

        public Map<Object, Object> getUserData() {
            if (SimpleFeatureImpl.this.attributeUserData == null) {
                SimpleFeatureImpl.this.attributeUserData = new HashMap[SimpleFeatureImpl.this.values.length];
            }
            if (SimpleFeatureImpl.this.attributeUserData[this.index] == null) {
                SimpleFeatureImpl.this.attributeUserData[this.index] = new HashMap<Object, Object>();
            }
            return SimpleFeatureImpl.this.attributeUserData[this.index];
        }

        public Object getValue() {
            return SimpleFeatureImpl.this.values[this.index];
        }

        public boolean isNillable() {
            return this.getDescriptor().isNillable();
        }

        public void setValue(Object newValue) {
            SimpleFeatureImpl.this.values[this.index] = newValue;
        }

        public int hashCode() {
            return 37 * this.getDescriptor().hashCode() + 37 * (this.getValue() == null ? 0 : this.getValue().hashCode());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Attribute)) {
                return false;
            }
            Attribute other = (Attribute)obj;
            if (!Utilities.equals((Object)this.getDescriptor(), (Object)other.getDescriptor())) {
                return false;
            }
            if (!Utilities.deepEquals((Object)this.getValue(), (Object)other.getValue())) {
                return false;
            }
            return Utilities.equals((Object)this.getIdentifier(), (Object)other.getIdentifier());
        }

        public void validate() {
            Types.validate(this.getDescriptor(), SimpleFeatureImpl.this.values[this.index]);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("SimpleFeatureImpl.Attribute: ");
            sb.append(this.getDescriptor().getName().getLocalPart());
            if (!this.getDescriptor().getName().getLocalPart().equals(this.getDescriptor().getType().getName().getLocalPart()) || SimpleFeatureImpl.this.id != null) {
                sb.append("<");
                sb.append(this.getDescriptor().getType().getName().getLocalPart());
                if (SimpleFeatureImpl.this.id != null) {
                    sb.append(" id=");
                    sb.append(SimpleFeatureImpl.this.id);
                }
                sb.append(">");
            }
            sb.append("=");
            sb.append(SimpleFeatureImpl.this.values[this.index]);
            return sb.toString();
        }
    }

    class AttributeList
    extends AbstractList<Property> {
        AttributeList() {
        }

        @Override
        public Property get(int index) {
            AttributeDescriptor descriptor = SimpleFeatureImpl.this.featureType.getDescriptor(index);
            if (descriptor instanceof GeometryDescriptor) {
                return new SimpleGeometryAttribute(index);
            }
            return new Attribute(index);
        }

        @Override
        public Attribute set(int index, Property element) {
            SimpleFeatureImpl.this.values[index] = element.getValue();
            return null;
        }

        @Override
        public int size() {
            return SimpleFeatureImpl.this.values.length;
        }
    }
}

