/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.server.http;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openrdf.sesame.server.SesameServer;
import org.openrdf.sesame.server.http.SesameServlet;
import org.openrdf.util.http.HttpServerUtil;
import org.openrdf.util.log.ThreadLog;

public class LogoutServlet
extends SesameServlet {
    protected void _doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this._handleFormURLEncodedRequest(request, response);
    }

    protected void _doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (HttpServerUtil.isMultipartFormRequest((HttpServletRequest)request)) {
            this._handleMultipartFormRequest(request, response);
        } else {
            this._handleFormURLEncodedRequest(request, response);
        }
    }

    private void _handleFormURLEncodedRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String successPage = HttpServerUtil.getParameter((HttpServletRequest)request, (String)"successPage");
        this._handleRequest(request, response, successPage);
    }

    private void _handleMultipartFormRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Map fileItemMap = HttpServerUtil.parseMultipartFormRequest((HttpServletRequest)request);
        String successPage = HttpServerUtil.getParameter((Map)fileItemMap, (String)"successPage");
        this._handleRequest(request, response, successPage);
    }

    private void _handleRequest(HttpServletRequest request, HttpServletResponse response, String successPage) throws IOException {
        SesameServer.setThreadLogFile("login.log");
        this._logIP(request);
        ThreadLog.log((String)">>> logout");
        ThreadLog.trace((String)("successPage = " + successPage));
        SesameServer.getLocalService().logout();
        ThreadLog.trace((String)"User logged out");
        HttpServerUtil.setNoCacheHeaders((HttpServletResponse)response);
        if (successPage != null) {
            String contextPath = request.getContextPath();
            response.sendRedirect(contextPath + successPage);
        } else {
            response.setStatus(200);
            response.setContentType("text/plain");
            PrintWriter writer = response.getWriter();
            writer.write("Logged out successfully");
            writer.close();
        }
    }
}

