/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.domain;

import java.io.Serializable;
import javax.persistence.Embeddable;
import org.fao.geonet.domain.Selection;
import org.fao.geonet.domain.User;

@Embeddable
public class UserSavedSelectionId
implements Serializable {
    private static final long serialVersionUID = 758566280699819800L;
    private int _userId;
    private int _selectionId;
    private String _metadataUuid;

    public UserSavedSelectionId() {
    }

    public UserSavedSelectionId(Selection selection, User user, String metadataUuid) {
        this.setUserId(user.getId());
        this.setSelectionId(selection.getId());
        this.setMetadataUuid(metadataUuid);
    }

    public int getUserId() {
        return this._userId;
    }

    public UserSavedSelectionId setUserId(int userId) {
        this._userId = userId;
        return this;
    }

    public int getSelectionId() {
        return this._selectionId;
    }

    public UserSavedSelectionId setSelectionId(int selectionId) {
        this._selectionId = selectionId;
        return this;
    }

    public String getMetadataUuid() {
        return this._metadataUuid;
    }

    public UserSavedSelectionId setMetadataUuid(String metadataUuid) {
        this._metadataUuid = metadataUuid;
        return this;
    }

    public String toString() {
        return String.format("Selection '%d' user '%d', uuid: '%s'.", this._selectionId, this._userId, this._metadataUuid);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this._selectionId;
        result = 31 * result + this._metadataUuid.hashCode();
        result = 31 * result + this._userId;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserSavedSelectionId other = (UserSavedSelectionId)obj;
        if (this._selectionId != other._selectionId) {
            return false;
        }
        return this._userId == other._userId;
    }
}

