/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.dbf;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.shapefile.dbf.DbaseFileException;
import org.geotools.data.shapefile.dbf.DbaseFileHeader;
import org.geotools.data.shapefile.files.StreamLogging;
import org.geotools.util.NIOUtilities;
import org.geotools.util.logging.Logging;

public class DbaseFileWriter {
    private DbaseFileHeader header;
    private FieldFormatter formatter;
    WritableByteChannel channel;
    private ByteBuffer buffer;
    private final byte[][] nullValues;
    private StreamLogging streamLogger = new StreamLogging("Dbase File Writer");
    private Charset charset;
    private TimeZone timeZone;
    private boolean reportFieldSizeErrors = Boolean.getBoolean("org.geotools.shapefile.reportFieldSizeErrors");

    public DbaseFileWriter(DbaseFileHeader header, WritableByteChannel out) throws IOException {
        this(header, out, null, null);
    }

    public DbaseFileWriter(DbaseFileHeader header, WritableByteChannel out, Charset charset) throws IOException {
        this(header, out, charset, null);
    }

    public DbaseFileWriter(DbaseFileHeader header, WritableByteChannel out, Charset charset, TimeZone timeZone) throws IOException {
        header.writeHeader(out);
        this.header = header;
        this.channel = out;
        this.charset = charset == null ? Charset.defaultCharset() : charset;
        this.timeZone = timeZone == null ? TimeZone.getDefault() : timeZone;
        this.formatter = new FieldFormatter(this.charset, this.timeZone, !this.reportFieldSizeErrors);
        this.streamLogger.open();
        this.nullValues = new byte[header.getNumFields()][];
        for (int i = 0; i < this.nullValues.length; ++i) {
            int nullChar;
            switch (header.getFieldType(i)) {
                case 'C': 
                case 'G': 
                case 'M': 
                case 'c': {
                    nullChar = 0;
                    break;
                }
                case 'L': 
                case 'l': {
                    nullChar = 63;
                    break;
                }
                case 'F': 
                case 'N': 
                case 'f': 
                case 'n': {
                    nullChar = 42;
                    break;
                }
                case 'D': 
                case 'd': {
                    nullChar = 48;
                    break;
                }
                case '@': {
                    nullChar = 0;
                    break;
                }
                default: {
                    nullChar = 48;
                }
            }
            this.nullValues[i] = new byte[header.getFieldLength(i)];
            Arrays.fill(this.nullValues[i], (byte)nullChar);
        }
        this.buffer = NIOUtilities.allocate((int)header.getRecordLength());
    }

    private void write() throws IOException {
        this.buffer.position(0);
        int r = this.buffer.remaining();
        while ((r -= this.channel.write(this.buffer)) > 0) {
        }
    }

    public void write(Object[] record) throws IOException, DbaseFileException {
        if (record.length != this.header.getNumFields()) {
            throw new DbaseFileException("Wrong number of fields " + record.length + " expected " + this.header.getNumFields());
        }
        this.buffer.position(0);
        this.buffer.put((byte)32);
        for (int i = 0; i < this.header.getNumFields(); ++i) {
            byte[] bytes;
            if (record[i] == null) {
                bytes = this.nullValues[i];
            } else {
                bytes = this.fieldBytes(record[i], i);
                if (bytes.length != this.nullValues[i].length) {
                    bytes = this.nullValues[i];
                }
            }
            this.buffer.put(bytes);
        }
        this.write();
    }

    private byte[] fieldBytes(Object obj, int col) throws UnsupportedEncodingException {
        String o;
        int fieldLen = this.header.getFieldLength(col);
        switch (this.header.getFieldType(col)) {
            case 'C': 
            case 'c': {
                o = this.formatter.getFieldString(fieldLen, obj.toString());
                break;
            }
            case 'L': 
            case 'l': {
                if (obj instanceof Boolean) {
                    o = (Boolean)obj != false ? "T" : "F";
                    break;
                }
                o = "?";
                break;
            }
            case 'G': 
            case 'M': {
                o = this.formatter.getFieldString(fieldLen, obj.toString());
                break;
            }
            case 'N': 
            case 'n': {
                if (this.header.getFieldDecimalCount(col) == 0) {
                    o = this.formatter.getFieldString(fieldLen, 0, (Number)obj);
                    break;
                }
            }
            case 'F': 
            case 'f': {
                o = this.formatter.getFieldString(fieldLen, this.header.getFieldDecimalCount(col), (Number)obj);
                break;
            }
            case 'D': 
            case 'd': {
                if (obj instanceof Calendar) {
                    o = this.formatter.getFieldString(((Calendar)obj).getTime());
                    break;
                }
                o = this.formatter.getFieldString((Date)obj);
                break;
            }
            case '@': {
                o = this.formatter.getFieldStringDateTime((Date)obj);
                if (!Boolean.getBoolean("org.geotools.shapefile.datetime")) break;
                char[] carr = o.toCharArray();
                byte[] barr = new byte[carr.length];
                for (int i = 0; i < carr.length; ++i) {
                    barr[i] = (byte)carr[i];
                }
                return barr;
            }
            default: {
                throw new RuntimeException("Unknown type " + this.header.getFieldType(col));
            }
        }
        return o.getBytes(this.charset.name());
    }

    public void close() throws IOException {
        if (this.channel != null && this.channel.isOpen()) {
            this.channel.close();
            this.streamLogger.close();
        }
        if (this.buffer != null) {
            NIOUtilities.clean((ByteBuffer)this.buffer, (boolean)false);
        }
        this.buffer = null;
        this.channel = null;
        this.formatter = null;
    }

    public boolean getReportFieldSizeErrors() {
        return this.reportFieldSizeErrors;
    }

    public void setReportFieldSizeErrors(boolean reportFieldSizeErrors) {
        this.reportFieldSizeErrors = reportFieldSizeErrors;
    }

    public DbaseFileHeader getHeader() {
        return this.header;
    }

    public static class FieldFormatter {
        private StringBuffer buffer = new StringBuffer(255);
        private NumberFormat numFormat = NumberFormat.getNumberInstance(Locale.US);
        private Calendar calendar;
        private final long MILLISECS_PER_DAY = 86400000L;
        private String emptyString;
        private static final int MAXCHARS = 255;
        private Charset charset;
        private boolean swallowFieldSizeErrors = false;
        private static Logger logger = Logging.getLogger(DbaseFileWriter.class);

        public FieldFormatter(Charset charset, TimeZone timeZone, boolean swallowFieldSizeErrors) {
            this.numFormat.setGroupingUsed(false);
            StringBuffer sb = new StringBuffer(255);
            sb.setLength(255);
            for (int i = 0; i < 255; ++i) {
                sb.setCharAt(i, ' ');
            }
            this.charset = charset;
            this.calendar = Calendar.getInstance(timeZone, Locale.US);
            this.emptyString = sb.toString();
            this.swallowFieldSizeErrors = swallowFieldSizeErrors;
        }

        public String getFieldString(int size, String s) {
            this.buffer.replace(0, size, this.emptyString);
            this.buffer.setLength(size);
            if (s != null) {
                int maxBytes = Math.min(size, s.length());
                this.buffer.replace(0, maxBytes, s);
                int currentBytes = this.buffer.toString().getBytes(this.charset).length;
                if (currentBytes > size) {
                    while (currentBytes > size) {
                        int index = this.buffer.length() - 1;
                        this.buffer.deleteCharAt(index);
                        currentBytes = this.buffer.toString().getBytes(this.charset).length;
                    }
                }
                if (currentBytes < size) {
                    int diff = size - currentBytes;
                    for (int i = 0; i < diff; ++i) {
                        this.buffer.append(' ');
                    }
                }
            }
            return this.buffer.toString();
        }

        public String getFieldString(Date d) {
            if (d != null) {
                this.buffer.delete(0, this.buffer.length());
                this.calendar.setTime(d);
                int year = this.calendar.get(1);
                int month = this.calendar.get(2) + 1;
                int day = this.calendar.get(5);
                if (year < 1000) {
                    if (year >= 100) {
                        this.buffer.append("0");
                    } else if (year >= 10) {
                        this.buffer.append("00");
                    } else {
                        this.buffer.append("000");
                    }
                }
                this.buffer.append(year);
                if (month < 10) {
                    this.buffer.append("0");
                }
                this.buffer.append(month);
                if (day < 10) {
                    this.buffer.append("0");
                }
                this.buffer.append(day);
            } else {
                this.buffer.setLength(8);
                this.buffer.replace(0, 8, this.emptyString);
            }
            this.buffer.setLength(8);
            return this.buffer.toString();
        }

        /*
         * Exception decompiling
         */
        public String getFieldStringDateTime(Date d) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public String getFieldString(int size, int decimalPlaces, Number n) {
            int diff;
            this.buffer.delete(0, this.buffer.length());
            if (n != null) {
                double dval = n.doubleValue();
                if (Double.isNaN(dval) || Double.isInfinite(dval)) {
                    this.buffer.append(n.toString());
                } else {
                    this.numFormat.setMaximumFractionDigits(decimalPlaces);
                    this.numFormat.setMinimumFractionDigits(decimalPlaces);
                    FieldPosition fp = new FieldPosition(1);
                    this.numFormat.format(n, this.buffer, fp);
                    if (fp.getBeginIndex() >= size) {
                        this.buffer.delete(0, this.buffer.length());
                        this.buffer.append(n.toString());
                        if (this.buffer.length() > size) {
                            logger.logp(Level.WARNING, this.getClass().getName(), "getFieldString", "Writing DBF data, value {0} cannot be represented in size {1,number}", new Object[]{n, size});
                            if (!this.swallowFieldSizeErrors) {
                                throw new IllegalArgumentException("Value " + n + " cannot be represented in size " + size);
                            }
                        }
                    }
                }
            }
            if ((diff = size - this.buffer.length()) > 0) {
                this.buffer.insert(0, this.emptyString.substring(0, diff));
            } else if (diff < 0) {
                this.buffer.setLength(size);
            }
            return this.buffer.toString();
        }
    }
}

