/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.geotools.geometry.jts.Decimator;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.LiteShape2;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.renderer.lite.LinesExtractor;
import org.geotools.renderer.lite.StyledShapePainter;
import org.geotools.renderer.style.LineStyle2D;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.GeometryFilter;
import org.locationtech.jts.geom.LineString;

public class ParallelLinesFiller {
    List<Line> lines;
    double xStep;
    double yStep;

    public ParallelLinesFiller(List<Line> lines, double xStep, double yStep) {
        this.lines = lines;
        this.xStep = xStep;
        this.yStep = yStep;
    }

    public static ParallelLinesFiller fromStipple(Shape shape) {
        Rectangle2D bounds = shape.getBounds2D();
        Geometry geometry = JTS.toGeometry(shape);
        LinesExtractor extractor = new LinesExtractor();
        geometry.apply((GeometryFilter)extractor);
        List<Line2D> segments = extractor.getLines();
        if (!extractor.isSimple() || segments.isEmpty()) {
            return null;
        }
        double by1 = bounds.getMinY();
        double by2 = bounds.getMaxY();
        double bx1 = bounds.getMinX();
        double bx2 = bounds.getMaxX();
        if (ParallelLinesFiller.equals(by1, by2)) {
            double w = bx2 - bx1;
            by1 -= w / 2.0;
            by2 += w / 2.0;
        } else if (ParallelLinesFiller.equals(bx1, bx2)) {
            double h = by2 - by1;
            bx1 -= h / 2.0;
            bx2 += h / 2.0;
        }
        ArrayList<Line> lines = new ArrayList<Line>();
        for (Line2D segment : segments) {
            double x1 = segment.getX1();
            double x2 = segment.getX2();
            double y1 = segment.getY1();
            double y2 = segment.getY2();
            if (ParallelLinesFiller.equals(x1, x2)) {
                if (ParallelLinesFiller.equals(y1, by1) && ParallelLinesFiller.equals(y2, by2)) {
                    lines.add(new Line(LineType.VERTICAL, x1 - bx1));
                    continue;
                }
                return null;
            }
            if (ParallelLinesFiller.equals(y1, y2)) {
                if (ParallelLinesFiller.equals(x1, bx1) && ParallelLinesFiller.equals(x2, bx2)) {
                    lines.add(new Line(LineType.HORIZONTAL, y1 - by1));
                    continue;
                }
                return null;
            }
            if (ParallelLinesFiller.equals(x1, bx1) && ParallelLinesFiller.equals(y1, by1) && ParallelLinesFiller.equals(x2, bx2) && ParallelLinesFiller.equals(y2, by2) || ParallelLinesFiller.equals(x1, bx2) && ParallelLinesFiller.equals(y1, by2) && ParallelLinesFiller.equals(x2, bx1) && ParallelLinesFiller.equals(y2, by1)) {
                lines.add(new Line(LineType.SLASH, 0.0));
                continue;
            }
            if (ParallelLinesFiller.equals(x1, bx1) && ParallelLinesFiller.equals(y1, by2) && ParallelLinesFiller.equals(x2, bx2) && ParallelLinesFiller.equals(y2, by1) || ParallelLinesFiller.equals(x1, bx2) && ParallelLinesFiller.equals(y1, by1) && ParallelLinesFiller.equals(x2, bx1) && ParallelLinesFiller.equals(y2, by2)) {
                lines.add(new Line(LineType.BACKSLASH, 0.0));
                continue;
            }
            return null;
        }
        double stepX = bx2 - bx1;
        double stepY = by2 - by1;
        if (stepX > 0.0 && stepY > 0.0) {
            return new ParallelLinesFiller(lines, stepX, stepY);
        }
        return null;
    }

    private static boolean equals(double d1, double d2) {
        return Math.abs(d1 - d2) < 0.001;
    }

    public void fillRectangle(Rectangle2D bounds, StyledShapePainter painter, Graphics2D graphics, LineStyle2D ls2d) {
        AffineTransform2D identityTransf = new AffineTransform2D(new AffineTransform());
        Decimator nullDecimator = new Decimator(-1.0, -1.0);
        GeometryFactory geomFactory = new GeometryFactory();
        Coordinate stippleCoord1 = new Coordinate(0.0, 0.0);
        Coordinate stippleCoord2 = new Coordinate(0.0, 0.0);
        LineString stippleLine = geomFactory.createLineString(new Coordinate[]{stippleCoord1, stippleCoord2});
        for (Line line : this.lines) {
            int steps;
            int ySteps;
            int xSteps;
            double x;
            double y;
            if (line.type == LineType.HORIZONTAL) {
                stippleCoord1.x = bounds.getMinX();
                stippleCoord2.x = bounds.getMaxX();
                for (y = bounds.getMinY() + line.initialOffset; y < bounds.getMaxY(); y += this.yStep) {
                    stippleCoord1.y = stippleCoord2.y = y;
                    this.paintLine(painter, graphics, ls2d, identityTransf, nullDecimator, stippleLine);
                }
                continue;
            }
            if (line.type == LineType.VERTICAL) {
                stippleCoord1.y = bounds.getMinY();
                stippleCoord2.y = bounds.getMaxY();
                for (x = bounds.getMinX() + line.initialOffset; x < bounds.getMaxX(); x += this.xStep) {
                    stippleCoord1.x = stippleCoord2.x = x;
                    this.paintLine(painter, graphics, ls2d, identityTransf, nullDecimator, stippleLine);
                }
                continue;
            }
            if (line.type == LineType.BACKSLASH) {
                stippleCoord1.x = bounds.getMinX();
                stippleCoord1.y = bounds.getMinY();
                for (x = bounds.getMinX(); x <= bounds.getMaxX(); x += this.xStep) {
                    xSteps = (int)Math.ceil((bounds.getMaxX() - x) / this.xStep);
                    ySteps = (int)Math.ceil((bounds.getMaxY() - bounds.getMinY()) / this.yStep);
                    steps = Math.min(xSteps, ySteps);
                    stippleCoord1.x = x;
                    stippleCoord2.x = stippleCoord1.x + (double)steps * this.xStep;
                    stippleCoord2.y = stippleCoord1.y + (double)steps * this.yStep;
                    this.paintLine(painter, graphics, ls2d, identityTransf, nullDecimator, stippleLine);
                }
                stippleCoord1.x = bounds.getMinX();
                for (y = bounds.getMinY() + this.yStep; y <= bounds.getMaxY(); y += this.yStep) {
                    xSteps = (int)Math.ceil((bounds.getMaxX() - bounds.getMinX()) / this.xStep);
                    ySteps = (int)Math.ceil((bounds.getMaxY() - y) / this.yStep);
                    steps = Math.min(xSteps, ySteps);
                    stippleCoord1.y = y;
                    stippleCoord2.x = stippleCoord1.x + (double)steps * this.xStep;
                    stippleCoord2.y = stippleCoord1.y + (double)steps * this.yStep;
                    this.paintLine(painter, graphics, ls2d, identityTransf, nullDecimator, stippleLine);
                }
                continue;
            }
            if (line.type != LineType.SLASH) continue;
            stippleCoord1.x = bounds.getMinX();
            stippleCoord1.y = bounds.getMinY();
            for (x = bounds.getMinX() + this.xStep; x <= bounds.getMaxX(); x += this.xStep) {
                xSteps = (int)Math.ceil((x - bounds.getMinX()) / this.xStep);
                ySteps = (int)Math.ceil((bounds.getMaxY() - bounds.getMinY()) / this.yStep);
                steps = Math.min(xSteps, ySteps);
                stippleCoord1.x = x;
                stippleCoord2.x = stippleCoord1.x - (double)steps * this.xStep;
                stippleCoord2.y = stippleCoord1.y + (double)steps * this.yStep;
                this.paintLine(painter, graphics, ls2d, identityTransf, nullDecimator, stippleLine);
            }
            stippleCoord1.x += this.xStep;
            for (y = bounds.getMinY(); y <= bounds.getMaxY(); y += this.yStep) {
                xSteps = (int)Math.ceil((stippleCoord1.x - bounds.getMinX()) / this.xStep);
                ySteps = (int)Math.ceil((bounds.getMaxY() - y) / this.yStep);
                steps = Math.min(xSteps, ySteps);
                stippleCoord1.y = y;
                stippleCoord2.x = stippleCoord1.x - (double)steps * this.xStep;
                stippleCoord2.y = stippleCoord1.y + (double)steps * this.yStep;
                this.paintLine(painter, graphics, ls2d, identityTransf, nullDecimator, stippleLine);
            }
        }
    }

    private void paintLine(StyledShapePainter painter, Graphics2D graphics, LineStyle2D lineStyle, AffineTransform2D identityTransf, Decimator nullDecimator, LineString stippleLine) {
        LiteShape2 stippleShape;
        stippleLine.geometryChanged();
        try {
            stippleShape = new LiteShape2((Geometry)stippleLine, identityTransf, nullDecimator, false);
        }
        catch (Exception e) {
            throw new RuntimeException("Unxpected exception building lite shape", e);
        }
        painter.paintLineStyle(graphics, stippleShape, lineStyle, false, 0.0f);
    }

    static class Line {
        LineType type;
        double initialOffset;

        public Line(LineType type, double initialOffset) {
            this.type = type;
            this.initialOffset = initialOffset;
        }
    }

    static enum LineType {
        HORIZONTAL,
        VERTICAL,
        SLASH,
        BACKSLASH;

    }
}

