/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.inspireatom.harvester;

import jeeves.server.context.ServiceContext;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.inspireatom.harvester.InspireAtomHarvester;
import org.fao.geonet.inspireatom.harvester.InspireAtomHarvesterJob;
import org.fao.geonet.inspireatom.harvester.InspireAtomHarvesterJobListener;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.QuartzSchedulerUtils;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.JobListener;
import org.quartz.Matcher;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.matchers.GroupMatcher;

public class InspireAtomHarvesterScheduler {
    private static final String SCHEDULER_ID = "inspireAtomHarvester";
    private static final String ATOM_HARVESTER_GROUP_NAME = "atomharvester";

    private InspireAtomHarvesterScheduler() {
    }

    public static void schedule(String cronSchedule, ServiceContext context, GeonetContext gc) throws SchedulerException {
        InspireAtomHarvesterScheduler.unSchedule();
        Scheduler scheduler = InspireAtomHarvesterScheduler.getScheduler();
        JobDetail job = JobBuilder.newJob(InspireAtomHarvesterJob.class).withIdentity("atomHarvesterId", ATOM_HARVESTER_GROUP_NAME).build();
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity("atomTriggerName", ATOM_HARVESTER_GROUP_NAME).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronSchedule)).build();
        scheduler.start();
        scheduler.scheduleJob(job, trigger);
        if (scheduler.getListenerManager().getJobListener("Atom Harvester Job configuration listener") == null) {
            scheduler.getListenerManager().addJobListener((JobListener)new InspireAtomHarvesterJobListener(new InspireAtomHarvester(gc)), (Matcher)GroupMatcher.jobGroupEquals((String)ATOM_HARVESTER_GROUP_NAME));
        }
        Log.info((String)"geonetwork.atom", (Object)"ATOM feed harvester scheduled");
    }

    public static void unSchedule() throws SchedulerException {
        Scheduler scheduler = InspireAtomHarvesterScheduler.getScheduler();
        scheduler.deleteJob(JobKey.jobKey((String)"atomHarvesterId", (String)ATOM_HARVESTER_GROUP_NAME));
        Log.info((String)"geonetwork.atom", (Object)"ATOM feed harvester unscheduled");
    }

    private static Scheduler getScheduler() throws SchedulerException {
        return QuartzSchedulerUtils.getScheduler((String)SCHEDULER_ID, (boolean)true);
    }

    public static void shutdown() {
        try {
            InspireAtomHarvesterScheduler.getScheduler().shutdown(true);
        }
        catch (SchedulerException e) {
            Log.warning((String)"geonetwork.atom", (Object)"Error stopping the scheduler", (Throwable)e);
        }
    }
}

