/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.user;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jeeves.server.UserSession;
import jeeves.services.ReadWriteController;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.domain.Address;
import org.fao.geonet.domain.Group;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.domain.User;
import org.fao.geonet.domain.UserGroup;
import org.fao.geonet.domain.responses.OkResponse;
import org.fao.geonet.repository.GroupRepository;
import org.fao.geonet.repository.UserGroupRepository;
import org.fao.geonet.repository.UserRepository;
import org.fao.geonet.repository.specification.UserGroupSpecs;
import org.fao.geonet.repository.specification.UserSpecs;
import org.fao.geonet.services.user.GroupElem;
import org.fao.geonet.util.PasswordUtil;
import org.locationtech.jts.util.Assert;
import org.springframework.context.ApplicationContext;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.domain.Specifications;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="admin.user.update")
@ReadWriteController
@Deprecated
public class Update {
    @RequestMapping(value={"/{portal}/{lang}/admin.user.resetpassword"}, produces={"application/xml", "application/json"})
    @ResponseBody
    @Deprecated
    public OkResponse resetPassword(HttpSession session, @RequestParam(value="id") String id, @RequestParam(value="password") String password, @RequestParam(value="password2") String password2) throws Exception {
        Assert.equals((Object)password, (Object)password2);
        new LoadCurrentUserInfo(session, id).invoke();
        UserRepository userRepository = (UserRepository)ApplicationContextHolder.get().getBean(UserRepository.class);
        User user = userRepository.findOne(id);
        this.setPassword("resetpw", password, user);
        userRepository.save((Object)user);
        return new OkResponse();
    }

    @RequestMapping(value={"/{portal}/{lang}/admin.user.update"}, produces={"application/xml", "application/json"})
    @ResponseBody
    public OkResponse run(HttpSession session, HttpServletRequest request, @RequestParam(value="operation") String operation, @RequestParam(value="id", required=false) String id, @RequestParam(value="username") String username, @RequestParam(value="password", required=false) String password, @RequestParam(value="profile", required=false) String profile_, @RequestParam(value="surname") String surname, @RequestParam(value="name") String name, @RequestParam(value="address", required=false) String address, @RequestParam(value="city", required=false) String city, @RequestParam(value="state", required=false) String state, @RequestParam(value="zip", required=false) String zip, @RequestParam(value="country", required=false) String country, @RequestParam(value="email") String email, @RequestParam(value="org", required=false) String organ, @RequestParam(value="kind", required=false) String kind, @RequestParam(value="enabled") Boolean enabled) throws Exception {
        User adminUser;
        List adminEnabledList;
        if (id == null && operation.equalsIgnoreCase("newuser")) {
            id = "";
        }
        LinkedList<GroupElem> groups = new LinkedList<GroupElem>();
        Profile profile = Profile.findProfileIgnoreCase((String)profile_);
        LoadCurrentUserInfo loadCurrentUserInfo = new LoadCurrentUserInfo(session, id).invoke();
        Profile myProfile = loadCurrentUserInfo.getMyProfile();
        String myUserId = loadCurrentUserInfo.getMyUserId();
        Map params = request.getParameterMap();
        for (Map.Entry entry : params.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith("groups_")) continue;
            for (String s : (String[])entry.getValue()) {
                groups.add(new GroupElem(key.substring(7), Integer.valueOf(s)));
            }
        }
        UserRepository userRepository = (UserRepository)ApplicationContextHolder.get().getBean(UserRepository.class);
        if (profile == Profile.Administrator && StringUtils.isNotEmpty((String)id) && enabled != null && enabled.equals(Boolean.FALSE) && (adminEnabledList = userRepository.findAll((Specification)Specifications.where((Specification)UserSpecs.hasProfile((Profile)Profile.Administrator)).and(UserSpecs.hasEnabled((Boolean)true)))).size() == 1 && (adminUser = (User)adminEnabledList.get(0)).getId() == Integer.parseInt(id)) {
            throw new IllegalArgumentException("Trying to disable all administrator users is not allowed");
        }
        UserGroupRepository userGroupRepository = (UserGroupRepository)ApplicationContextHolder.get().getBean(UserGroupRepository.class);
        this.checkAccessRights(operation, id, username, myProfile, myUserId, groups, userGroupRepository);
        User user = this.getUser(userRepository, operation, id, username);
        if (!myProfile.equals((Object)Profile.Administrator)) {
            List myUserAdminGroups = userGroupRepository.findGroupIds((Specification)Specifications.where((Specification)UserGroupSpecs.hasProfile((Profile)myProfile)).and(UserGroupSpecs.hasUserId((int)Integer.valueOf(myUserId))));
            List usergroups = userGroupRepository.findAll((Specification)Specifications.where((Specification)UserGroupSpecs.hasUserId((int)Integer.parseInt(id))));
            for (UserGroup ug : usergroups) {
                if (myUserAdminGroups.contains(ug.getGroup().getId())) continue;
                groups.add(new GroupElem(ug.getProfile().name(), ug.getGroup().getId()));
            }
        }
        this.setPassword(operation, password, user);
        if (operation.equalsIgnoreCase("resetpw")) {
            userRepository.save((Object)user);
        } else {
            this.updateOrSave(operation, username, surname, name, address, city, state, zip, country, email, organ, kind, enabled, profile, myProfile, groups, user);
        }
        return new OkResponse();
    }

    public void updateOrSave(String operation, String username, String surname, String name, String address, String city, String state, String zip, String country, String email, String organ, String kind, Boolean enabled, Profile profile, Profile myProfile, List<GroupElem> groups, User user) throws Exception {
        boolean hasNoAddress;
        if (username != null) {
            user.setUsername(username);
        }
        if (name != null) {
            user.setName(name);
        }
        if (surname != null) {
            user.setSurname(surname);
        }
        if (profile != null) {
            if (!myProfile.getAll().contains(profile)) {
                throw new IllegalArgumentException("Trying to set profile to " + profile + " max profile permitted is: " + myProfile);
            }
            user.setProfile(profile);
        }
        if (kind != null) {
            user.setKind(kind);
        }
        if (organ != null) {
            user.setOrganisation(organ);
        }
        if (enabled != null) {
            user.setEnabled(enabled);
        }
        Address addressEntity = (hasNoAddress = user.getAddresses().isEmpty()) ? new Address() : (Address)user.getAddresses().iterator().next();
        if (address != null) {
            addressEntity.setAddress(address);
        }
        if (city != null) {
            addressEntity.setCity(city);
        }
        if (state != null) {
            addressEntity.setState(state);
        }
        if (zip != null) {
            addressEntity.setZip(zip);
        }
        if (country != null) {
            addressEntity.setCountry(country);
        }
        if (hasNoAddress) {
            user.getAddresses().add(addressEntity);
        }
        if (email != null) {
            String[] emails;
            String[] stringArray;
            if (email.indexOf("|") >= 0) {
                stringArray = email.split("|");
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = email;
            }
            for (String mail : emails = stringArray) {
                user.getEmailAddresses().clear();
                user.getEmailAddresses().add(mail);
            }
        }
        UserRepository userRepository = (UserRepository)ApplicationContextHolder.get().getBean(UserRepository.class);
        if (!(operation.equals("newuser") || operation.equals("fullupdate") || operation.equals("editinfo"))) {
            throw new IllegalArgumentException("unknown user update operation " + operation);
        }
        user = (User)userRepository.save((Object)user);
        this.setUserGroups(user, groups);
    }

    public void setPassword(String operation, String password, User user) {
        if (password != null) {
            user.getSecurity().setPassword(PasswordUtil.encoder((ApplicationContext)ApplicationContextHolder.get()).encode((CharSequence)password));
        } else if (operation.equals("resetpw") || operation.equals("newuser")) {
            throw new IllegalArgumentException("password is a required parameter for operation: resetpw");
        }
    }

    private User getUser(UserRepository repo, String operation, String id, String username) {
        if ("newuser".equalsIgnoreCase(operation)) {
            if (username == null) {
                throw new IllegalArgumentException("username is a required parameter for newuser operation");
            }
            List existingUsers = repo.findByUsernameIgnoreCase(username);
            if (!existingUsers.isEmpty()) {
                throw new IllegalArgumentException("Users with username " + username + " ignore case already exists");
            }
            User user = repo.findOneByUsername(username);
            return new User();
        }
        User user = repo.findOne(id);
        if (user == null) {
            throw new IllegalArgumentException("No user found with id: " + id);
        }
        List usersWithUsernameIgnoreCase = repo.findByUsernameIgnoreCase(username);
        if (usersWithUsernameIgnoreCase.size() != 0 && (!usersWithUsernameIgnoreCase.stream().anyMatch(u -> u.getId() == Integer.parseInt(id)) || usersWithUsernameIgnoreCase.stream().anyMatch(u -> u.getUsername().equals(username) && u.getId() != Integer.parseInt(id)))) {
            throw new IllegalArgumentException(String.format("Another user with username '%s' ignore case already exists", user.getUsername()));
        }
        return user;
    }

    private void checkAccessRights(String operation, String id, String username, Profile myProfile, String myUserId, List<GroupElem> userGroups, UserGroupRepository groupRepository) {
        if ((operation.equals("newuser") || operation.equals("editinfo") || operation.equals("fullupdate")) && !myUserId.equals(id) && myProfile == Profile.UserAdmin) {
            List groupIds = groupRepository.findGroupIds(UserGroupSpecs.hasUserId((int)Integer.parseInt(myUserId)));
            for (GroupElem userGroup : userGroups) {
                boolean found = false;
                Iterator iterator = groupIds.iterator();
                while (iterator.hasNext()) {
                    int myGroup = (Integer)iterator.next();
                    if (userGroup.getId() != myGroup) continue;
                    found = true;
                }
                if (found) continue;
                throw new IllegalArgumentException("Tried to add group id " + userGroup.getId() + " to user " + username + " - not allowed because you are not a member of that group!");
            }
        }
    }

    private void setUserGroups(User user, List<GroupElem> userGroups) throws Exception {
        UserGroupRepository userGroupRepository = (UserGroupRepository)ApplicationContextHolder.get().getBean(UserGroupRepository.class);
        GroupRepository groupRepository = (GroupRepository)ApplicationContextHolder.get().getBean(GroupRepository.class);
        List all = userGroupRepository.findAll(UserGroupSpecs.hasUserId((int)user.getId()));
        HashSet<String> listOfAddedProfiles = new HashSet<String>();
        for (UserGroup ug : all) {
            String key = ug.getProfile().name() + ug.getGroup().getId();
            if (listOfAddedProfiles.contains(key)) continue;
            listOfAddedProfiles.add(key);
        }
        ArrayList toRemove = new ArrayList();
        toRemove.addAll(all);
        ArrayList<UserGroup> toAdd = new ArrayList<UserGroup>();
        for (GroupElem element : userGroups) {
            String key;
            UserGroup userGroup;
            Integer groupId = element.getId();
            Group group = (Group)groupRepository.findOne((Serializable)groupId);
            String profile = element.getProfile();
            if (profile.equals(Profile.Reviewer.name())) {
                userGroup = new UserGroup().setGroup(group).setProfile(Profile.Editor).setUser(user);
                key = Profile.Editor.toString() + group.getId();
                if (!listOfAddedProfiles.contains(key)) {
                    toAdd.add(userGroup);
                    listOfAddedProfiles.add(key);
                }
                for (UserGroup g : all) {
                    if (g.getGroup().getId() != groupId.intValue() || !g.getProfile().equals((Object)Profile.Editor)) continue;
                    toRemove.remove(g);
                }
            }
            userGroup = new UserGroup().setGroup(group).setProfile(Profile.findProfileIgnoreCase((String)profile)).setUser(user);
            key = profile + group.getId();
            if (!listOfAddedProfiles.contains(key)) {
                toAdd.add(userGroup);
                listOfAddedProfiles.add(key);
            }
            for (UserGroup g : all) {
                if (g.getGroup().getId() != groupId.intValue() || !g.getProfile().name().equalsIgnoreCase(profile)) continue;
                toRemove.remove(g);
            }
        }
        userGroupRepository.delete(toRemove);
        userGroupRepository.save(toAdd);
    }

    private static class LoadCurrentUserInfo {
        private HttpSession session;
        private String id;
        private Profile myProfile;
        private String myUserId;

        public LoadCurrentUserInfo(HttpSession session, String id) {
            this.session = session;
            this.id = id;
        }

        public Profile getMyProfile() {
            return this.myProfile;
        }

        public String getMyUserId() {
            return this.myUserId;
        }

        public LoadCurrentUserInfo invoke() {
            Object principal;
            Object securityContext;
            this.myProfile = Profile.Guest;
            this.myUserId = null;
            Object tmp = this.session.getAttribute("session");
            if (tmp instanceof UserSession) {
                UserSession usrSess = (UserSession)tmp;
                this.myProfile = usrSess.getProfile();
                this.myUserId = usrSess.getUserId();
            } else if (tmp == null && (securityContext = this.session.getAttribute("SPRING_SECURITY_CONTEXT")) instanceof SecurityContext && (principal = ((SecurityContext)securityContext).getAuthentication().getPrincipal()) instanceof User) {
                User user = (User)principal;
                this.myProfile = user.getProfile();
                this.myUserId = user.getId() + "";
            }
            if (this.myProfile != Profile.Administrator && this.myProfile != Profile.UserAdmin && !this.myUserId.equals(this.id)) {
                throw new IllegalArgumentException("You don't have rights to do this");
            }
            return this;
        }
    }
}

