/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.resources;

import com.google.common.collect.Maps;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import jeeves.server.context.ServiceContext;
import jeeves.server.dispatchers.ServiceManager;
import jeeves.services.ReadWriteController;
import org.fao.geonet.api.processing.XslProcessUtils;
import org.fao.geonet.api.processing.report.XsltMetadataProcessingReport;
import org.fao.geonet.domain.responses.IdResponse;
import org.fao.geonet.exceptions.BadParameterEx;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.services.metadata.XslProcessing;
import org.fao.geonet.services.resources.handlers.IResourceRemoveHandler;
import org.jdom.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@ReadWriteController
@Controller(value="resource.del.and.detach")
@Deprecated
public class RemoveAndProcess {
    @Autowired
    private DataManager dm;
    @Autowired
    private XslProcessing xslProcessing;
    @Autowired
    private ServiceManager serviceManager;

    @RequestMapping(value={"/{portal}/{lang}/resource.del.and.detach"}, produces={"application/xml", "application/json"})
    @ResponseBody
    public IdResponse serviceSpecificExec(@PathVariable String lang, HttpServletRequest request, @RequestParam(value="url") String url, @RequestParam(defaultValue="") String id, @RequestParam(defaultValue="") String uuid) throws Exception {
        try (ServiceContext context = this.serviceManager.createServiceContext("resource.del.and.detach", lang, request);){
            if (id.trim().isEmpty()) {
                id = this.dm.getMetadataId(uuid);
            }
            Lib.resource.checkEditPrivilege(context, id);
            URL resourceURL = new URL(url);
            String[] parameters = resourceURL.getQuery().split("&");
            String filename = "";
            String access = "";
            for (String param : parameters) {
                String[] parts;
                if (param.startsWith("fname")) {
                    parts = param.split("=");
                    filename = parts.length == 2 ? parts[1] : "";
                    continue;
                }
                if (!param.startsWith("access")) continue;
                parts = param.split("=");
                access = parts.length == 2 ? parts[1] : "";
            }
            IResourceRemoveHandler removeHook = (IResourceRemoveHandler)context.getBean("resourceRemoveHandler", IResourceRemoveHandler.class);
            removeHook.onDelete(context, request, Integer.parseInt(id), filename, access);
            HashMap allParams = Maps.newHashMap((Map)request.getParameterMap());
            allParams.put("name", new String[]{filename});
            allParams.put("protocol", new String[]{"WWW:DOWNLOAD-1.0-http--download"});
            String process = "onlinesrc-remove";
            XsltMetadataProcessingReport report = new XsltMetadataProcessingReport(process);
            String siteURL = ((SettingManager)context.getBean(SettingManager.class)).getSiteURL(context);
            Element processedMetadata = XslProcessUtils.process(context, id, process, true, true, true, report, siteURL, allParams);
            if (processedMetadata == null) {
                throw new BadParameterEx("Processing failed", (Object)("Not found:" + report.getNumberOfRecordNotFound() + ", Not owner:" + report.getNumberOfRecordsNotEditable() + ", No process found:" + report.getNoProcessFoundCount() + "."));
            }
            IdResponse idResponse = new IdResponse(id);
            return idResponse;
        }
    }
}

