/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.publisher;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import jeeves.interfaces.Service;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.Util;
import org.fao.geonet.api.mapservers.GeoFile;
import org.fao.geonet.api.mapservers.GeoServerNode;
import org.fao.geonet.api.mapservers.GeoServerRest;
import org.fao.geonet.api.records.attachments.Store;
import org.fao.geonet.domain.MapServer;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.repository.MapServerRepository;
import org.fao.geonet.utils.FilePathChecker;
import org.fao.geonet.utils.GeonetHttpRequestFactory;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Content;
import org.jdom.Element;

@Deprecated
public class Do
implements Service {
    public static final String MODULE = "geonetwork.GeoServerPublisher";
    private static final String DB = "DB";
    private static final String VECTOR = "vector";
    private static final String RASTER = "raster";
    private static final String SUCCESS = "Success";
    private static final String EXCEPTION = "Exception";
    private HashMap<Integer, GeoServerNode> geoserverNodes = new HashMap();
    private String errorCode = "";
    private Element report = null;

    private Element getReport() {
        return this.report;
    }

    private void setReport(Element report) {
        this.report = report;
    }

    private String getErrorCode() {
        return this.errorCode;
    }

    private void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public void init(Path appPath, ServiceConfig params) throws Exception {
        Log.createLogger((String)MODULE);
    }

    public Element exec(Element params, ServiceContext context) throws Exception {
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        MapServerRepository repo = (MapServerRepository)context.getBean(MapServerRepository.class);
        SettingManager settingsManager = (SettingManager)gc.getBean(SettingManager.class);
        String baseUrl = settingsManager.getSiteURL(context);
        ACTION action = ACTION.valueOf(Util.getParam((Element)params, (String)"action"));
        if (action.equals((Object)ACTION.LIST)) {
            return this.loadDbConfiguration(context);
        }
        if (action.equals((Object)ACTION.ADD_NODE)) {
            MapServer m = new MapServer().setName(Util.getParam((Element)params, (String)"name", (String)"")).setDescription(Util.getParam((Element)params, (String)"description", (String)"")).setConfigurl(Util.getParam((Element)params, (String)"configurl", (String)"")).setWmsurl(Util.getParam((Element)params, (String)"wmsurl", (String)"")).setWfsurl(Util.getParam((Element)params, (String)"wfsurl", (String)"")).setWcsurl(Util.getParam((Element)params, (String)"wcsurl", (String)"")).setStylerurl(Util.getParam((Element)params, (String)"stylerurl", (String)"")).setUsername(Util.getParam((Element)params, (String)"username", (String)"")).setPassword(Util.getParam((Element)params, (String)"password", (String)"")).setNamespace(Util.getParam((Element)params, (String)"namespace", (String)"")).setNamespacePrefix(Util.getParam((Element)params, (String)"namespaceprefix", (String)"")).setPushStyleInWorkspace(Util.getParam((Element)params, (String)"pushstyleinworkspace", (boolean)false));
            ((MapServerRepository)context.getBean(MapServerRepository.class)).save((Object)m);
            return new Element(action.toString()).setText("ok").setAttribute("id", String.valueOf(m.getId()));
        }
        if (action.equals((Object)ACTION.REMOVE_NODE)) {
            MapServer m = repo.findOneById(Util.getParam((Element)params, (String)"id"));
            if (m != null) {
                repo.delete((Object)m);
            }
            return new Element(action.toString()).setText("ok");
        }
        if (action.equals((Object)ACTION.UPDATE_NODE)) {
            MapServer m = repo.findOneById(Util.getParam((Element)params, (String)"id"));
            if (m != null) {
                m.setName(Util.getParam((Element)params, (String)"name", (String)"")).setDescription(Util.getParam((Element)params, (String)"description", (String)"")).setConfigurl(Util.getParam((Element)params, (String)"configurl", (String)"")).setWmsurl(Util.getParam((Element)params, (String)"wmsurl", (String)"")).setWfsurl(Util.getParam((Element)params, (String)"wfsurl", (String)"")).setWcsurl(Util.getParam((Element)params, (String)"wcsurl", (String)"")).setStylerurl(Util.getParam((Element)params, (String)"stylerurl", (String)"")).setNamespace(Util.getParam((Element)params, (String)"namespace", (String)"")).setNamespacePrefix(Util.getParam((Element)params, (String)"namespaceprefix", (String)"")).setPushStyleInWorkspace(Util.getParam((Element)params, (String)"pushstyleinworkspace", (boolean)false));
                repo.save((Object)m);
            }
            return new Element(action.toString()).setText("ok");
        }
        if (action.equals((Object)ACTION.UPDATE_NODE_ACCOUNT)) {
            MapServer m = repo.findOneById(Util.getParam((Element)params, (String)"id"));
            if (m != null) {
                m.setUsername(Util.getParam((Element)params, (String)"username", (String)"")).setPassword(Util.getParam((Element)params, (String)"password", (String)""));
                repo.save((Object)m);
            }
            return new Element(action.toString()).setText("ok");
        }
        if (action.equals((Object)ACTION.CREATE) || action.equals((Object)ACTION.UPDATE) || action.equals((Object)ACTION.DELETE) || action.equals((Object)ACTION.GET)) {
            String nodeId = Util.getParam((Element)params, (String)"nodeId");
            String metadataId = Util.getParam((Element)params, (String)"metadataId");
            String metadataUuid = Util.getParam((Element)params, (String)"metadataUuid", (String)"");
            String metadataTitle = Util.getParam((Element)params, (String)"metadataTitle", (String)"").replace("\\n", "");
            String metadataAbstract = Util.getParam((Element)params, (String)"metadataAbstract", (String)"").replace("\\n", "\n");
            MapServer m = repo.findOneById(nodeId);
            GeoServerNode g = new GeoServerNode(m);
            GeonetHttpRequestFactory requestFactory = (GeonetHttpRequestFactory)context.getBean(GeonetHttpRequestFactory.class);
            GeoServerRest gs = new GeoServerRest(requestFactory, g.getUrl(), g.getUsername(), g.getUserpassword(), g.getNamespacePrefix(), baseUrl, settingsManager.getNodeURL(), m.pushStyleInWorkspace());
            String file = Util.getParam((Element)params, (String)"file");
            String access = Util.getParam((Element)params, (String)"access");
            if (file.startsWith("jdbc:postgresql")) {
                String[] values = file.split("/");
                String[] serverInfo = values[2].split(":");
                String host = serverInfo[0];
                String port = serverInfo[1];
                String[] dbUserInfo = values[3].split("@");
                String[] userInfo = dbUserInfo[0].split(":");
                String user = userInfo[0];
                String password = userInfo[1];
                String[] dbInfo = dbUserInfo[1].split("#");
                String db = dbInfo[0];
                String table = dbInfo[1];
                return this.publishDbTable(action, gs, "postgis", host, port, user, password, db, table, "postgis", g.getNamespaceUrl(), metadataUuid, metadataTitle, metadataAbstract);
            }
            if (file.startsWith("file://") || file.startsWith("http://")) {
                return this.addExternalFile(action, gs, file, metadataUuid, metadataTitle, metadataAbstract);
            }
            FilePathChecker.verify((String)file);
            Store store = (Store)context.getBean("resourceStore", Store.class);
            try (Store.ResourceHolder resource = store.getResource(context, metadataUuid, file);){
                Element element = this.addZipFile(action, gs, resource.getPath(), file, metadataUuid, metadataTitle, metadataAbstract);
                return element;
            }
        }
        return null;
    }

    private Element loadDbConfiguration(ServiceContext context) {
        List mapservers = ((MapServerRepository)context.getBean(MapServerRepository.class)).findAll();
        this.geoserverNodes.clear();
        Element geoserverConfig = new Element("nodes");
        for (MapServer m : mapservers) {
            GeoServerNode g = new GeoServerNode(m);
            if (g == null) continue;
            this.geoserverNodes.put(m.getId(), g);
            Element node = new Element("node");
            node.addContent((Content)new Element("id").setText(m.getId() + ""));
            node.addContent((Content)new Element("name").setText(m.getName()));
            node.addContent((Content)new Element("description").setText(m.getDescription()));
            node.addContent((Content)new Element("namespacePrefix").setText(m.getNamespacePrefix()));
            node.addContent((Content)new Element("namespaceUrl").setText(m.getNamespace()));
            node.addContent((Content)new Element("adminUrl").setText(m.getConfigurl()));
            node.addContent((Content)new Element("wmsUrl").setText(m.getWmsurl()));
            node.addContent((Content)new Element("wfsUrl").setText(m.getWfsurl()));
            node.addContent((Content)new Element("wcsUrl").setText(m.getWcsurl()));
            node.addContent((Content)new Element("stylerUrl").setText(m.getStylerurl()));
            if (m.pushStyleInWorkspace()) {
                node.addContent((Content)new Element("pushStyleInWorkspace").setText("true"));
            } else {
                node.addContent((Content)new Element("pushStyleInWorkspace").setText("false"));
            }
            geoserverConfig.addContent((Content)node);
        }
        return geoserverConfig;
    }

    private Element publishDbTable(ACTION action, GeoServerRest g, String string, String host, String port, String user, String password, String db, String table, String dbType, String ns, String metadataUuid, String metadataTitle, String metadataAbstract) {
        try {
            if (action.equals((Object)ACTION.CREATE) || action.equals((Object)ACTION.UPDATE)) {
                StringBuilder report = new StringBuilder();
                if (!g.createDatabaseDatastore(db, host, port, db, user, password, dbType, ns)) {
                    report.append("Datastore: ").append(g.getStatus());
                }
                if (!g.createFeatureType(db, table, metadataUuid, metadataTitle, metadataAbstract)) {
                    report.append("Feature type: ").append(g.getStatus());
                }
                if (!g.createStyle(db, table)) {
                    report.append("Style: ").append(g.getStatus());
                }
            } else if (action.equals((Object)ACTION.DELETE)) {
                StringBuilder report = new StringBuilder();
                if (!g.deleteLayer(table)) {
                    report.append("Layer: ").append(g.getStatus());
                }
                if (report.length() > 0) {
                    this.setErrorCode(report.toString());
                    return this.report(EXCEPTION, DB, this.getErrorCode());
                }
            }
            if (g.getLayer(table)) {
                this.setReport(Xml.loadString((String)g.getResponse(), (boolean)false));
                return this.report(SUCCESS, DB, this.getReport());
            }
            this.setErrorCode(g.getStatus() + "");
            return this.report(EXCEPTION, DB, this.getErrorCode());
        }
        catch (Exception e) {
            this.setErrorCode(e.getMessage());
            Log.error((String)MODULE, (Object)("Exception " + e.getMessage()));
            return this.report(EXCEPTION, DB, this.getErrorCode());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Element addZipFile(ACTION action, GeoServerRest gs, Path f, String file, String metadataUuid, String metadataTitle, String metadataAbstract) throws IOException {
        Collection<String> rasterLayers;
        Collection<String> vectorLayers;
        if (f == null) {
            return this.report(EXCEPTION, null, "Could not find dataset file. Invalid zip file parameters: " + file + ".");
        }
        Throwable throwable = null;
        try (GeoFile gf = new GeoFile(f);){
            vectorLayers = gf.getVectorLayers(true);
            if (vectorLayers.size() > 0) {
                if (this.publishVector(f, gf, gs, action, metadataUuid, metadataTitle, metadataAbstract)) {
                    Element element = this.report(SUCCESS, VECTOR, this.getReport());
                    return element;
                }
                Element element = this.report(EXCEPTION, VECTOR, this.getErrorCode());
                return element;
            }
            rasterLayers = gf.getRasterLayers();
            if (rasterLayers.size() > 0) {
                if (this.publishRaster(f, gs, action, metadataUuid, metadataTitle, metadataAbstract)) {
                    Element e = this.report(SUCCESS, RASTER, this.getReport());
                    return e;
                }
                Element e = this.report(EXCEPTION, RASTER, this.getErrorCode());
                return e;
            }
        }
        catch (IllegalArgumentException e) {
            Element element = this.report(EXCEPTION, VECTOR, e.getMessage());
            return element;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        if (vectorLayers.size() != 0) return null;
        if (rasterLayers.size() != 0) return null;
        return this.report(EXCEPTION, RASTER, "No vector or raster layers found in file (" + file + ").");
    }

    private Element addExternalFile(ACTION action, GeoServerRest gs, String file, String metadataUuid, String metadataTitle, String metadataAbstract) throws IOException {
        if (this.publishExternal(file, gs, action, metadataUuid, metadataTitle, metadataAbstract)) {
            return this.report(SUCCESS, VECTOR, this.getReport());
        }
        return this.report(EXCEPTION, VECTOR, this.getErrorCode());
    }

    private Element report(String name, String type, String msg) {
        Element report = new Element(name);
        if (type != null) {
            report.setAttribute("type", type);
        }
        report.setAttribute("status", msg);
        return report;
    }

    private Element report(String name, String type, Element msg) {
        Element report = new Element(name);
        if (type != null) {
            report.setAttribute("type", type);
        }
        report.addContent((Content)msg);
        return report;
    }

    private boolean publishVector(Path f, GeoFile gf, GeoServerRest g, ACTION action, String metadataUuid, String metadataTitle, String metadataAbstract) {
        String ds = f.getFileName().toString();
        String dsName = ds.substring(0, ds.lastIndexOf("."));
        try {
            if (action.equals((Object)ACTION.CREATE)) {
                g.createDatastore(dsName, f);
                if (gf.containsSld().booleanValue()) {
                    g.createStyle(g.getDefaultWorkspace(), dsName, gf.getSld());
                } else {
                    g.createStyle(g.getDefaultWorkspace(), dsName);
                }
                g.createFeatureType(dsName, dsName, metadataUuid, metadataTitle, metadataAbstract);
            } else if (action.equals((Object)ACTION.UPDATE)) {
                g.createDatastore(dsName, f);
                g.createFeatureType(dsName, dsName, metadataUuid, metadataTitle, metadataAbstract);
            } else if (action.equals((Object)ACTION.DELETE)) {
                String report = "";
                if (!g.deleteLayer(dsName)) {
                    report = report + "Layer: " + g.getStatus();
                }
                if (!g.deleteFeatureType(dsName, dsName)) {
                    report = report + "Feature type: " + g.getStatus();
                }
                if (!g.deleteDatastore(dsName)) {
                    report = report + "Datastore: " + g.getStatus();
                }
                if (!report.equals("")) {
                    this.setErrorCode(report);
                    return false;
                }
            }
            if (!g.getLayer(dsName)) {
                this.setErrorCode(g.getStatus() + "");
                return false;
            }
            this.setReport(Xml.loadString((String)g.getResponse(), (boolean)false));
            return true;
        }
        catch (Exception e) {
            this.setErrorCode(e.getMessage());
            Log.error((String)MODULE, (Object)("Exception " + e.getMessage()));
            return false;
        }
    }

    private boolean publishExternal(String file, GeoServerRest g, ACTION action, String metadataUuid, String metadataTitle, String metadataAbstract) {
        String dsName = file.substring(file.lastIndexOf("/") + 1, file.lastIndexOf("."));
        boolean isRaster = GeoFile.fileIsRASTER(file);
        Log.error((String)MODULE, (Object)("Publish external: " + dsName + ", Raster: " + isRaster));
        try {
            if (action.equals((Object)ACTION.CREATE)) {
                if (isRaster) {
                    g.createCoverage(dsName, file, metadataUuid, metadataTitle, metadataAbstract);
                } else {
                    g.createDatastore(dsName, file);
                    g.createStyle(dsName);
                }
            } else if (action.equals((Object)ACTION.UPDATE)) {
                if (isRaster) {
                    g.createCoverage(dsName, file, metadataUuid, metadataTitle, metadataAbstract);
                } else {
                    g.createDatastore(dsName, file);
                }
            } else if (action.equals((Object)ACTION.DELETE)) {
                String report = "";
                if (!g.deleteLayer(dsName)) {
                    report = report + "Layer: " + g.getStatus();
                }
                if (!isRaster) {
                    if (!g.deleteFeatureType(dsName, dsName)) {
                        report = report + "Feature type: " + g.getStatus();
                    }
                    if (!g.deleteDatastore(dsName)) {
                        report = report + "Datastore: " + g.getStatus();
                    }
                }
                if (!report.equals("")) {
                    this.setErrorCode(report);
                    return false;
                }
            }
            if (!g.getLayer(dsName)) {
                this.setErrorCode(g.getStatus() + "");
                return false;
            }
            this.setReport(Xml.loadString((String)g.getResponse(), (boolean)false));
            return true;
        }
        catch (Exception e) {
            this.setErrorCode(e.getMessage());
            Log.error((String)MODULE, (Object)("Exception " + e.getMessage()));
            return false;
        }
    }

    private boolean publishRaster(Path f, GeoServerRest g, ACTION action, String metadataUuid, String metadataTitle, String metadataAbstract) {
        String cs = f.getFileName().toString();
        String csName = cs.substring(0, cs.lastIndexOf("."));
        try {
            if (action.equals((Object)ACTION.CREATE)) {
                g.createCoverage(csName, f, metadataUuid, metadataTitle, metadataAbstract);
            } else if (action.equals((Object)ACTION.UPDATE)) {
                g.createCoverage(csName, f, metadataUuid, metadataTitle, metadataAbstract);
            } else if (action.equals((Object)ACTION.DELETE)) {
                String report = "";
                if (!g.deleteLayer(csName)) {
                    report = report + "Layer: " + g.getStatus();
                }
                if (!g.deleteCoverage(csName, csName)) {
                    report = report + "Coverage: " + g.getStatus();
                }
                if (!g.deleteCoverageStore(csName)) {
                    report = report + "Coveragestore: " + g.getStatus();
                }
                if (!report.equals("")) {
                    this.setErrorCode(report);
                    return false;
                }
            }
            if (!g.getLayer(csName)) {
                this.setErrorCode(g.getStatus() + "");
                return false;
            }
            this.setReport(Xml.loadString((String)g.getResponse(), (boolean)false));
            return true;
        }
        catch (Exception e) {
            this.setErrorCode(e.getMessage());
            Log.error((String)MODULE, (Object)("Exception " + e.getMessage()));
            return false;
        }
    }

    private static enum ACTION {
        LIST,
        CREATE,
        UPDATE,
        DELETE,
        GET,
        ADD_NODE,
        REMOVE_NODE,
        UPDATE_NODE,
        UPDATE_NODE_ACCOUNT;

    }
}

