/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.metadata;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import jeeves.server.dispatchers.ServiceManager;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.SelectionManager;
import org.jdom.Element;
import org.jdom.xpath.XPath;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.NativeWebRequest;

@Controller
public class ExtractServicesLayers {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/{portal}/{lang}/selection.layers"})
    @ResponseBody
    public JSONObject getLayersFromSelectedMetadatas(@PathVariable String lang, @RequestParam(value="id", required=false) String paramId, NativeWebRequest webRequest) throws Exception {
        ServiceManager serviceManager = (ServiceManager)ApplicationContextHolder.get().getBean(ServiceManager.class);
        try (ServiceContext context = serviceManager.createServiceContext("selection.layers", lang, (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class));){
            Set set;
            DataManager dm = (DataManager)context.getBean(DataManager.class);
            UserSession us = context.getUserSession();
            SelectionManager sm = SelectionManager.getManager((UserSession)us);
            JSONObject ret = new JSONObject();
            JSONArray services = new JSONArray();
            JSONArray layers = new JSONArray();
            ArrayList<String> lst = new ArrayList<String>();
            if (paramId == null) {
                set = sm.getSelection("metadata");
                synchronized (set) {
                    for (String uuid : sm.getSelection("metadata")) {
                        String id = dm.getMetadataId(uuid);
                        lst.add(id);
                    }
                }
            } else {
                lst.add(paramId);
            }
            for (String id : lst) {
                List elems;
                String uuid;
                uuid = dm.getMetadataUuid(id);
                Element curMd = dm.getMetadata(context, id, false, false, false);
                XPath xpath = XPath.newInstance((String)"gmd:distributionInfo/gmd:MD_Distribution/gmd:transferOptions/gmd:MD_DigitalTransferOptions/gmd:onLine");
                try {
                    List tmp;
                    elems = tmp = xpath.selectNodes((Object)curMd);
                }
                catch (Exception e) {
                    continue;
                }
                for (Element curnode : elems) {
                    String sDescription;
                    XPath pLinkage = XPath.newInstance((String)"gmd:CI_OnlineResource/gmd:linkage/gmd:URL");
                    XPath pProtocol = XPath.newInstance((String)"gmd:CI_OnlineResource/gmd:protocol/gco:CharacterString");
                    XPath pName = XPath.newInstance((String)"gmd:CI_OnlineResource/gmd:name/gco:CharacterString");
                    XPath pDescription = XPath.newInstance((String)"gmd:CI_OnlineResource/gmd:description/gco:CharacterString");
                    Element eLinkage = (Element)pLinkage.selectSingleNode((Object)curnode);
                    Element eProtocol = (Element)pProtocol.selectSingleNode((Object)curnode);
                    Element eName = (Element)pName.selectSingleNode((Object)curnode);
                    Element eDescription = (Element)pDescription.selectSingleNode((Object)curnode);
                    if (eLinkage == null || eProtocol == null || eName == null) continue;
                    String sLinkage = eLinkage.getValue();
                    String sProtocol = eProtocol.getValue();
                    String sName = eName.getValue();
                    String string = sDescription = eDescription != null ? eDescription.getValue() : "";
                    if (sLinkage == null || sLinkage.equals("") || sProtocol == null || sProtocol.equals("")) continue;
                    String sProto2 = "WMS";
                    if (sProtocol.contains("OGC:WMS")) {
                        sProto2 = "WMS";
                    } else if (sProtocol.contains("OGC:WFS")) {
                        sProto2 = "WFS";
                    } else {
                        if (!sProtocol.contains("OGC:WCS")) continue;
                        sProto2 = "WMS";
                    }
                    if (sName == null || sName.equals("")) {
                        JSONObject serviceObj = new JSONObject();
                        serviceObj.put((Object)"owsurl", (Object)sLinkage);
                        serviceObj.put((Object)"owstype", (Object)sProto2);
                        serviceObj.put((Object)"text", (Object)sDescription);
                        serviceObj.put((Object)"mdid", (Object)id);
                        serviceObj.put((Object)"muuid", (Object)uuid);
                        services.add((Object)serviceObj);
                        continue;
                    }
                    JSONObject layerObj = new JSONObject();
                    layerObj.put((Object)"owsurl", (Object)sLinkage);
                    layerObj.put((Object)"owstype", (Object)sProto2);
                    layerObj.put((Object)"layername", (Object)sName);
                    layerObj.put((Object)"title", (Object)sDescription);
                    layerObj.put((Object)"mdid", (Object)id);
                    layerObj.put((Object)"muuid", (Object)uuid);
                    layers.add((Object)layerObj);
                }
            }
            ret.put((Object)"layers", (Object)layers);
            ret.put((Object)"services", (Object)services);
            set = ret;
            return set;
        }
    }
}

