/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.users.transfer;

import com.google.common.base.Optional;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.users.transfer.OwnerResponse;
import org.fao.geonet.api.users.transfer.TransferRequest;
import org.fao.geonet.api.users.transfer.UserGroupsResponse;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.Group;
import org.fao.geonet.domain.OperationAllowed;
import org.fao.geonet.domain.OperationAllowedId;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.domain.User;
import org.fao.geonet.domain.UserGroup;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.datamanager.IMetadataManager;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.repository.OperationAllowedRepository;
import org.fao.geonet.repository.UserGroupRepository;
import org.fao.geonet.repository.UserRepository;
import org.fao.geonet.repository.specification.MetadataSpecs;
import org.fao.geonet.repository.specification.OperationAllowedSpecs;
import org.fao.geonet.repository.specification.UserGroupSpecs;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import springfox.documentation.annotations.ApiIgnore;

@RequestMapping(value={"/{portal}/api/users", "/{portal}/api/0.1/users"})
@Api(value="users", tags={"users"}, description="User operations")
@Controller(value="usersTransfer")
public class TransferApi {
    @Autowired
    UserRepository userRepository;
    @Autowired
    IMetadataUtils metadataRepository;
    @Autowired
    UserGroupRepository userGroupRepository;
    @Autowired
    OperationAllowedRepository operationAllowedRepository;
    @Autowired
    IMetadataManager metadataManager;
    @Autowired
    DataManager dataManager;

    @ApiOperation(value="Get owners", notes="Return users who actually owns one or more records.", nickname="getOwners")
    @RequestMapping(path={"owners"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasRole('UserAdmin')")
    @ResponseBody
    public List<OwnerResponse> getUsers(@ApiIgnore HttpSession httpSession, HttpServletRequest request) throws Exception {
        List users = this.userRepository.findAll();
        ArrayList<OwnerResponse> ownerList = new ArrayList<OwnerResponse>();
        for (User u : users) {
            long userRecordsCount = this.metadataRepository.count(MetadataSpecs.hasOwner((int)u.getId()));
            if (userRecordsCount <= 0L) continue;
            ownerList.add(new OwnerResponse(u, userRecordsCount));
        }
        return ownerList;
    }

    @ApiOperation(value="Retrieve all user groups", notes="", nickname="retrieveAllUserGroups")
    @RequestMapping(value={"/groups"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="isAuthenticated()")
    @ResponseBody
    public List<UserGroupsResponse> retrieveAllUserGroups(@ApiIgnore HttpSession httpSession) throws Exception {
        UserSession session = ApiUtils.getUserSession(httpSession);
        Profile myProfile = session.getProfile();
        ArrayList<UserGroupsResponse> list = new ArrayList<UserGroupsResponse>();
        if (myProfile == Profile.Administrator || myProfile == Profile.UserAdmin) {
            List userGroups;
            List allAdmin = this.userRepository.findAllByProfile(Profile.Administrator);
            Group adminGroup = new Group();
            adminGroup.setName("allAdmins");
            for (User u : allAdmin) {
                list.add(new UserGroupsResponse(u, adminGroup, Profile.Administrator.name()));
            }
            if (myProfile == Profile.Administrator) {
                userGroups = this.userGroupRepository.findAll();
            } else {
                List myGroups = this.userGroupRepository.findAll(UserGroupSpecs.hasUserId((int)session.getUserIdAsInt())).stream().map(ug -> ug.getGroup().getId()).collect(Collectors.toList());
                userGroups = this.userGroupRepository.findAll(UserGroupSpecs.hasGroupIds(myGroups));
            }
            for (UserGroup ug2 : userGroups) {
                list.add(new UserGroupsResponse(ug2.getUser(), ug2.getGroup(), ug2.getProfile().name()));
            }
            return list;
        }
        throw new SecurityException("You don't have rights to do get the groups for this user");
    }

    @ApiOperation(value="Transfer privileges", notes="", nickname="saveOwners")
    @RequestMapping(value={"/owners"}, produces={"application/json"}, method={RequestMethod.PUT})
    @PreAuthorize(value="hasRole('UserAdmin')")
    @ResponseBody
    public ResponseEntity saveOwners(@RequestBody TransferRequest transfer, @ApiIgnore HttpSession httpSession, HttpServletRequest request) throws Exception {
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        try (ServiceContext context = ApiUtils.createServiceContext(request);){
            Set<String> sourcePriv = this.retrievePrivileges(context, transfer.getSourceUser(), transfer.getSourceGroup());
            Set<String> targetPriv = this.retrievePrivileges(context, null, transfer.getTargetGroup());
            this.dataManager.flush();
            int privCount = 0;
            HashSet<Integer> metadata = new HashSet<Integer>();
            if (sourcePriv.size() > 0) {
                for (String string : sourcePriv) {
                    StringTokenizer st = new StringTokenizer(string, "|");
                    int opId = Integer.parseInt(st.nextToken());
                    int mdId = Integer.parseInt(st.nextToken());
                    if (transfer.getSourceGroup() != transfer.getTargetGroup()) {
                        this.dataManager.unsetOperation(context, mdId, transfer.getSourceGroup(), opId);
                        if (!targetPriv.contains(string)) {
                            OperationAllowedId id = new OperationAllowedId().setGroupId(transfer.getTargetGroup()).setMetadataId(mdId).setOperationId(opId);
                            OperationAllowed operationAllowed = new OperationAllowed(id);
                            this.operationAllowedRepository.save((Object)operationAllowed);
                        }
                    }
                    metadata.add(mdId);
                    ++privCount;
                }
            }
            List sourceUserRecords = this.metadataRepository.findAllIdsBy(MetadataSpecs.hasOwner((int)transfer.getSourceUser()));
            metadata.addAll(sourceUserRecords);
            for (Integer i : metadata) {
                AbstractMetadata metadata1 = this.metadataRepository.findOne(i.intValue());
                metadata1.getSourceInfo().setGroupOwner(Integer.valueOf(transfer.getTargetGroup())).setOwner(Integer.valueOf(transfer.getTargetUser()));
                this.metadataManager.save(metadata1);
            }
            this.dataManager.flush();
            ArrayList<String> arrayList = new ArrayList<String>();
            ResponseEntity responseEntity = metadata.iterator();
            while (responseEntity.hasNext()) {
                int mdId = (Integer)responseEntity.next();
                arrayList.add(Integer.toString(mdId));
            }
            this.dataManager.indexMetadata(arrayList);
            responseEntity = new ResponseEntity(HttpStatus.CREATED);
            return responseEntity;
        }
    }

    private Set<String> retrievePrivileges(ServiceContext context, Integer userId, int groupId) throws SQLException {
        List opsAllowed = userId == null ? this.operationAllowedRepository.findAllById_GroupId(groupId) : this.operationAllowedRepository.findAllWithOwner(userId.intValue(), Optional.of((Object)OperationAllowedSpecs.hasGroupId((int)groupId)));
        HashSet<String> result = new HashSet<String>();
        for (OperationAllowed elem : opsAllowed) {
            int opId = elem.getId().getOperationId();
            int mdId = elem.getId().getMetadataId();
            result.add(opId + "|" + mdId);
        }
        return result;
    }
}

