/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.regions;

import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.regions.ListRegionsResponse;
import org.fao.geonet.api.regions.ThesaurusBasedRegionsDAO;
import org.fao.geonet.api.regions.model.Category;
import org.fao.geonet.api.tools.i18n.LanguageUtils;
import org.fao.geonet.kernel.KeywordBean;
import org.fao.geonet.kernel.region.RegionsDAO;
import org.fao.geonet.kernel.region.Request;
import org.fao.geonet.kernel.setting.SettingManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.context.request.NativeWebRequest;
import springfox.documentation.annotations.ApiIgnore;

@RequestMapping(value={"/{portal}/api/regions", "/{portal}/api/0.1/regions"})
@Api(value="regions", tags={"regions"}, description="Regions operations")
@Controller(value="regions")
public class RegionsApi {
    @Autowired
    private LanguageUtils languageUtils;
    @Autowired
    private SettingManager settingManager;
    @Value(value="${metadata.extentApi.disableFullUrlBackgroundMapServices:true}")
    private boolean disableFullUrlBackgroundMapServices;

    @ApiOperation(value="Get list of regions", nickname="getRegions")
    @RequestMapping(method={RequestMethod.GET}, produces={"application/xml", "application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(code=200, message="List of regions.")})
    @ResponseBody
    public ListRegionsResponse getRegions(@RequestParam(required=false) String label, @RequestParam(required=false) String categoryId, @RequestParam(defaultValue="-1") int maxRecords, @ApiIgnore @ApiParam(hidden=true) NativeWebRequest webRequest) throws Exception {
        HttpServletRequest nativeRequest = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class);
        try (ServiceContext context = ApiUtils.createServiceContext(nativeRequest);){
            ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
            Collection daos = applicationContext.getBeansOfType(RegionsDAO.class).values();
            ArrayList regions = Lists.newArrayList();
            for (RegionsDAO dao : daos) {
                if (!dao.includeInListing()) continue;
                Request request = RegionsApi.createRequest(label, categoryId, maxRecords, context, dao);
                regions.addAll(request.execute());
            }
            HttpServletResponse nativeResponse = (HttpServletResponse)webRequest.getNativeResponse(HttpServletResponse.class);
            nativeResponse.setHeader("Cache-Control", "no-cache");
            ListRegionsResponse listRegionsResponse = new ListRegionsResponse(regions);
            return listRegionsResponse;
        }
    }

    @ApiOperation(value="Get list of region types", nickname="getRegionTypes")
    @RequestMapping(path={"/types"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(code=200, message="List of region types.")})
    @ResponseBody
    public List<Category> getRegionTypes(HttpServletRequest request) throws Exception {
        try (ServiceContext context = ApiUtils.createServiceContext(request);){
            String language = this.languageUtils.iso3code(request.getLocales());
            Collection daos = ApplicationContextHolder.get().getBeansOfType(RegionsDAO.class).values();
            ArrayList<Category> response = new ArrayList<Category>();
            for (RegionsDAO dao : daos) {
                Category c;
                if (dao instanceof ThesaurusBasedRegionsDAO) {
                    List<KeywordBean> keywords = ((ThesaurusBasedRegionsDAO)dao).getRegionTopConcepts(context);
                    if (keywords == null) continue;
                    for (KeywordBean k : keywords) {
                        c = new Category(k.getUriCode(), k.getPreferredLabel(language));
                        response.add(c);
                    }
                    continue;
                }
                Collection ids = dao.getRegionCategoryIds(context);
                if (ids == null) continue;
                for (String id : ids) {
                    c = new Category(id, null);
                    response.add(c);
                }
            }
            ArrayList<Category> arrayList = response;
            return arrayList;
        }
    }

    public static Request createRequest(String label, String categoryId, int maxRecords, ServiceContext context, RegionsDAO dao) throws Exception {
        Request request = dao.createSearchRequest(context);
        if (label != null) {
            request.label(label);
        }
        if (categoryId != null) {
            request.categoryId(categoryId);
        }
        if (maxRecords > 0) {
            request.maxRecords(maxRecords);
        }
        return request;
    }

    /*
     * Exception decompiling
     */
    @ApiOperation(value="Get geometry as image", notes="A rendering of the geometry as a png.", nickname="getGeomAsImage")
    @RequestMapping(value={"/geom.png"}, produces={"image/png"}, method={RequestMethod.GET})
    public HttpEntity<byte[]> getGeomAsImage(@ApiParam(value="(optional) the background map projection. If not passed uses the region/getmap/mapproj setting. If the setting is not set defaults to EPSG:4326") @RequestParam(value="mapsrs", required=false) String mapSrs, @ApiParam(value="(optional) width of the image that is created. Only one of width and height are permitted") @RequestParam(value="width", required=false, defaultValue="300") Integer width, @ApiParam(value="(optional) height of the image that is created. Only one of width and height are permitted") @RequestParam(value="height", required=false) Integer height, @ApiParam(value="(optional) URL for loading a background image for regions or a key that references the namedBackgrounds (configured in config-spring-geonetwork.xml). A WMS Getmap request is the typical example. The URL must be parameterized with the following parameters: minx, maxx, miny, maxy, width, height") @RequestParam(value="background", required=false, defaultValue="settings") String background, @ApiParam(value="(optional) a wkt or gml encoded geometry.") @RequestParam(value="geom", required=false) String geomParam, @ApiParam(value="(optional) defines if geom is wkt or gml. Allowed values are wkt and gml. if not specified the it is assumed the geometry is wkt") @RequestParam(value="geomtype", defaultValue="WKT") String geomType, @ApiParam(value="") @RequestParam(value="geomsrs", defaultValue="EPSG:4326") String geomSrs, @ApiIgnore NativeWebRequest nativeWebRequest, @ApiIgnore HttpServletRequest request) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

