/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.formatters.groovy.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.fao.geonet.api.records.attachments.Store;
import org.fao.geonet.api.records.formatters.FormatType;
import org.fao.geonet.api.records.formatters.groovy.Environment;
import org.fao.geonet.api.records.formatters.groovy.Functions;
import org.fao.geonet.api.records.formatters.groovy.Handlers;
import org.fao.geonet.api.records.formatters.groovy.template.FileResult;
import org.fao.geonet.api.records.formatters.groovy.util.LinkBlock;
import org.fao.geonet.api.records.formatters.groovy.util.NavBarItem;
import org.fao.geonet.domain.MetadataResourceVisibility;

public class Summary {
    protected final Handlers handlers;
    protected final Environment env;
    protected final Functions functions;
    public List<LinkBlock> links = Lists.newArrayList();
    public List<LinkBlock> associated = Lists.newArrayList();
    private String logo;
    private List<String> thumbnails = Lists.newArrayList();
    private String title = "";
    private String abstr = "";
    private List<NavBarItem> navBar = Lists.newArrayList();
    private List<NavBarItem> navBarOverflow = Lists.newArrayList();
    private String content = "";
    private boolean addCompleteNavItem = true;
    private boolean addOverviewNavItem = true;
    private String keywords = "";
    private String extent = "";
    private String formats = "";

    public Summary(Handlers handlers, Environment env, Functions functions) throws Exception {
        this.handlers = handlers;
        this.env = env;
        this.functions = functions;
        Collection<String> logo = env.getIndexInfo().get("_logo");
        if (logo != null && !logo.isEmpty()) {
            this.logo = env.getLocalizedUrl() + "../.." + logo.iterator().next();
        }
    }

    public FileResult getResult() throws Exception {
        HashMap params = Maps.newHashMap();
        params.put("logo", this.logo);
        params.put("title", this.title != null ? this.title : "");
        params.put("pageTitle", this.title != null ? this.title.replace('\"', '\'') : "");
        params.put("abstract", this.abstr);
        params.put("thumbnail", this.thumbnailUrl());
        params.put("links", this.links);
        params.put("associated", this.associated);
        params.put("addOverviewNavItem", this.addOverviewNavItem);
        params.put("navBar", this.navBar);
        params.put("navBarOverflow", this.navBarOverflow);
        params.put("showNavOverflow", !this.navBarOverflow.isEmpty());
        params.put("addCompleteNavItem", this.addCompleteNavItem);
        params.put("content", this.content);
        params.put("extents", this.extent != null ? this.extent : "");
        params.put("formats", this.formats != null ? this.formats : "");
        params.put("keywords", this.keywords != null ? this.keywords : "");
        params.put("isHTML", this.env.getFormatType() == FormatType.html);
        params.put("isPDF", this.env.getFormatType() == FormatType.pdf || this.env.getFormatType() == FormatType.testpdf);
        return this.handlers.fileResult("html/view-header.html", params);
    }

    String thumbnailUrl() {
        String thumbnail = null;
        for (String t : this.thumbnails) {
            boolean isUrl = this.thumbnailIsUrl(t);
            boolean isSmall = this.isSmallThumbnail(t);
            if (!isUrl && this.resourceUrlExists(t) && !isSmall) {
                thumbnail = this.resourceThumbnailUrl(t);
                break;
            }
            if (isUrl) {
                thumbnail = t;
            }
            if (thumbnail != null || !this.resourceUrlExists(t)) continue;
            thumbnail = this.resourceThumbnailUrl(t);
        }
        if (thumbnail == null) {
            thumbnail = "";
        }
        return thumbnail;
    }

    private String resourceThumbnailUrl(String t) {
        return this.env.getLocalizedUrl() + "resources.get?fname=" + t + "&access=public&id=" + this.env.getMetadataId();
    }

    private boolean isSmallThumbnail(String img) {
        return img.matches(".*_s\\.[^.]+");
    }

    private boolean resourceUrlExists(String imgFile) {
        Store store = this.env.getBean("resourceStore", Store.class);
        try {
            return store.getResourceDescription(this.env.getContext(), this.env.getMetadataUUID(), MetadataResourceVisibility.PUBLIC, imgFile, Boolean.valueOf(true)) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean thumbnailIsUrl(String img) {
        return img.startsWith("http://") || img.startsWith("https://");
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public void setThumbnails(List<String> thumbnails) {
        this.thumbnails = thumbnails;
    }

    public void addThumbnail(String thumbnail) {
        this.thumbnails.add(thumbnail);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setAbstr(String abstr) {
        this.abstr = abstr;
    }

    public void addNavBarItem(NavBarItem item) {
        this.navBar.add(item);
    }

    public void setNavBar(List<NavBarItem> navBar) {
        this.navBar = navBar;
    }

    public void addNavBarOverflow(NavBarItem item) {
        this.navBarOverflow.add(item);
    }

    public void setNavBarOverflow(List<NavBarItem> navBarOverflow) {
        this.navBarOverflow = navBarOverflow;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public boolean isAddCompleteNavItem() {
        return this.addCompleteNavItem;
    }

    public void setAddCompleteNavItem(boolean addCompleteNavItem) {
        this.addCompleteNavItem = addCompleteNavItem;
    }

    public boolean isAddOverviewNavItem() {
        return this.addOverviewNavItem;
    }

    public void setAddOverviewNavItem(boolean addOverviewNavItem) {
        this.addOverviewNavItem = addOverviewNavItem;
    }

    public void setExtent(String extent) {
        this.extent = extent;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    public void setFormats(String formats) {
        this.formats = formats;
    }
}

