/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.formatters.groovy;

import com.google.common.io.Closer;
import groovy.lang.Closure;
import groovy.util.IndentPrinter;
import groovy.util.slurpersupport.GPathResult;
import groovy.xml.MarkupBuilder;
import java.io.Closeable;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.fao.geonet.api.records.formatters.ConfigFile;
import org.fao.geonet.api.records.formatters.FormatterParams;
import org.fao.geonet.api.records.formatters.SchemaLocalizations;
import org.fao.geonet.api.records.formatters.groovy.Environment;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.schema.SchemaPlugin;
import org.fao.geonet.util.LangUtils;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.springframework.context.ApplicationContext;

public class Functions
extends SchemaLocalizations {
    private final Environment env;
    private final FormatterParams fparams;
    private SchemaPlugin schemaPlugin;

    public Functions(FormatterParams fparams, Environment env) throws Exception {
        super((ApplicationContext)fparams.context.getApplicationContext(), env, fparams.schema, fparams.config.dependOn());
        this.env = env;
        this.schemaPlugin = SchemaManager.getSchemaPlugin((String)fparams.schema);
        this.fparams = fparams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String html(Closure htmlFunction) {
        Closer closer = Closer.create();
        try {
            StringWriter writer = (StringWriter)closer.register((Closeable)new StringWriter());
            IndentPrinter indentPrinter = new IndentPrinter((Writer)writer, " ", true, false);
            MarkupBuilder html = new MarkupBuilder(indentPrinter);
            htmlFunction.call((Object)html);
            String string = writer.toString();
            return string;
        }
        finally {
            try {
                closer.close();
            }
            catch (IOException e) {
                throw new Error(e);
            }
        }
    }

    public String translate(String key) throws Exception {
        return this.translate(key, null);
    }

    public String translate(String key, String file) throws Exception {
        String value = this.translateFromFormatterResources(key, file);
        if (value == null || value.isEmpty()) {
            value = this.translateFromSchema(this.fparams.schemaDir, key, file);
        }
        if (value == null || value.isEmpty()) {
            value = this.translateFromShared(key, file == null ? "formatter" : file);
        }
        if (value == null || value.isEmpty()) {
            return key;
        }
        return value;
    }

    private String translateFromSchema(Path schemaDir, String key, String file) throws Exception {
        ConfigFile configFile;
        Path formatterDir = schemaDir.resolve("formatter");
        Element translations = this.getFormatterTranslations(formatterDir);
        Element currLanTranslations = translations.getChild(this.env.getLang3());
        String translation = this.translateFrom(key, file, currLanTranslations);
        if (translation == null && (configFile = new ConfigFile(formatterDir, false, schemaDir)).dependOn() != null) {
            SchemaManager schemaManager = (SchemaManager)this.fparams.context.getBean(SchemaManager.class);
            Path parentSchemaDir = schemaManager.getSchemaDir(configFile.dependOn());
            translation = this.translateFromSchema(parentSchemaDir, key, file);
        }
        return translation;
    }

    private String translateFromFormatterResources(String key, String file) throws Exception {
        Element translations = this.getFormatterTranslations(this.fparams.formatDir);
        Element currLanTranslations = translations.getChild(this.env.getLang3());
        return this.translateFrom(key, file, currLanTranslations);
    }

    private String translateFrom(String key, String file, Element currLanTranslations) {
        if (currLanTranslations == null) {
            return null;
        }
        String translation = null;
        if (file == null) {
            Element element;
            List files = currLanTranslations.getChildren();
            Iterator iterator = files.iterator();
            while (iterator.hasNext() && (translation = (element = (Element)iterator.next()).getChildText(key)) == null) {
            }
        } else {
            Element fileTranslations = currLanTranslations.getChild(file);
            if (fileTranslations != null) {
                translation = fileTranslations.getChildText(key);
            }
        }
        return translation;
    }

    protected String translateFromShared(String key, String file) throws JDOMException, IOException {
        Map translations = LangUtils.translate((ApplicationContext)this.fparams.context.getApplicationContext(), (String)file, (String)key);
        String value = (String)translations.get(this.env.getLang3());
        if (value == null) {
            value = (String)translations.get("eng");
        }
        if (value == null && !translations.isEmpty()) {
            value = (String)translations.values().iterator().next();
        }
        return value;
    }

    public SchemaPlugin getSchemaPlugin() {
        return this.schemaPlugin;
    }

    private Element getFormatterTranslations(Path dir) throws Exception {
        return this.fparams.format.getPluginLocResources(this.fparams.context, dir);
    }

    public String getXPathFrom(GPathResult path) {
        if (path == null) {
            return "";
        }
        GPathResult parent = path.parent();
        if (parent == path) {
            return "";
        }
        StringBuilder currPath = new StringBuilder(this.getXPathFrom(parent));
        if (currPath.length() > 0) {
            currPath.append("/");
        }
        currPath.append(path.name());
        GPathResult singlingsAndSelf = (GPathResult)parent.getProperty(path.name());
        if (singlingsAndSelf.size() > 1) {
            int i = singlingsAndSelf.list().indexOf(path);
            currPath.append('[').append(i + 1).append(']');
        }
        return currPath.toString();
    }
}

