/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.formatters;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import jeeves.server.context.ServiceContext;
import jeeves.server.dispatchers.ServiceManager;
import jeeves.services.ReadWriteController;
import net.sf.json.JSONObject;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.Constants;
import org.fao.geonet.ZipUtil;
import org.fao.geonet.api.records.formatters.AbstractFormatService;
import org.fao.geonet.api.records.formatters.ConfigFile;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.utils.FilePathChecker;
import org.fao.geonet.utils.IO;
import org.fao.oaipmh.exceptions.BadArgumentException;
import org.locationtech.jts.util.Assert;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@ReadWriteController
public class Register
extends AbstractFormatService {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/{portal}/{lang}/md.formatter.register"}, produces={"application/json"})
    @ResponseBody
    public JSONObject serviceSpecificExec(HttpServletRequest request, @PathVariable String lang, @RequestParam(value="id", required=false) String xslid, @RequestParam(value="fname") MultipartFile file) throws Exception {
        ServiceManager serviceManager = (ServiceManager)ApplicationContextHolder.get().getBean(ServiceManager.class);
        Throwable throwable = null;
        try (ServiceContext context = serviceManager.createServiceContext("md.formatter.register", lang, request);){
            Throwable throwable2;
            int extentionIdx;
            if (xslid == null && (extentionIdx = (xslid = file.getOriginalFilename()).lastIndexOf(46)) != -1) {
                xslid = xslid.substring(0, extentionIdx);
            }
            FilePathChecker.verify((String)xslid);
            FilePathChecker.verify((String)file.getOriginalFilename());
            this.checkLegalId("id", xslid);
            Path userXslDir = ((GeonetworkDataDirectory)context.getBean(GeonetworkDataDirectory.class)).getFormatterDir();
            Path newBundle = userXslDir.resolve(xslid);
            Path uploadedFile = context.getUploadDir().resolve(file.getOriginalFilename());
            byte[] data = ByteStreams.toByteArray((InputStream)file.getInputStream());
            Files.write(uploadedFile, data, new OpenOption[0]);
            try {
                Files.createDirectories(newBundle, new FileAttribute[0]);
                try {
                    throwable2 = null;
                    try (FileSystem zipFs = ZipUtil.openZipFs((Path)uploadedFile);){
                        Path root;
                        Path viewFile = this.findViewFile(zipFs);
                        if (viewFile == null) {
                            throw new BadArgumentException("A formatter zip file must contain a view.xsl file as one of its root files");
                        }
                        Path viewXslContainerDir = null;
                        Iterator<Path> iterator = zipFs.getRootDirectories().iterator();
                        while (iterator.hasNext() && (viewXslContainerDir = this.findViewXslContainerDir(root = iterator.next())) == null) {
                        }
                        if (viewXslContainerDir == null) {
                            throw new IllegalArgumentException(uploadedFile + " does not have a view.xsl file within it");
                        }
                        IO.copyDirectoryOrFile(viewXslContainerDir, (Path)newBundle, (boolean)false);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                }
                catch (IllegalArgumentException | UnsupportedOperationException e) {
                    this.handleRawXsl(uploadedFile, newBundle);
                }
                catch (Exception e) {
                    IO.deleteFileOrDirectory((Path)newBundle);
                    throw e;
                }
                this.addOptionalFiles(newBundle);
                JSONObject response = new JSONObject();
                response.put((Object)"success", (Object)true);
                response.put((Object)"id", (Object)xslid);
                throwable2 = response;
            }
            catch (Throwable throwable4) {
                try {
                    IO.deleteFile((Path)uploadedFile, (boolean)false, (String)"geonetwork.formatter");
                    throw throwable4;
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            IO.deleteFile((Path)uploadedFile, (boolean)false, (String)"geonetwork.formatter");
            return throwable2;
        }
    }

    private Path findViewXslContainerDir(Path dir) throws IOException {
        if (Files.exists(dir.resolve("view.xsl"), new LinkOption[0])) {
            return dir;
        }
        try (DirectoryStream<Path> paths = Files.newDirectoryStream(dir, IO.DIRECTORIES_FILTER);){
            for (Path childDir : paths) {
                Path container = this.findViewXslContainerDir(childDir);
                if (container == null) continue;
                Path path = container;
                return path;
            }
        }
        return null;
    }

    private Path findViewFile(FileSystem zipFs) throws IOException {
        Path rootView = zipFs.getPath("view.xsl", new String[0]);
        if (Files.exists(rootView, new LinkOption[0])) {
            return rootView;
        }
        String groovyView = "view.groovy";
        rootView = zipFs.getPath("view.groovy", new String[0]);
        if (Files.exists(rootView, new LinkOption[0])) {
            return rootView;
        }
        Path rootDir = zipFs.getRootDirectories().iterator().next();
        try (DirectoryStream<Path> dirs = Files.newDirectoryStream(rootDir, IO.DIRECTORIES_FILTER);){
            Iterator<Path> dirIter = dirs.iterator();
            if (dirIter.hasNext()) {
                Path next = dirIter.next();
                Assert.isTrue((!dirIter.hasNext() ? 1 : 0) != 0, (String)"The formatter/view zip file must either have a single root directory which contains the view file or it must have all formatter resources at the root of the directory");
                rootView = next.resolve("view.xsl");
                if (Files.exists(rootView, new LinkOption[0])) {
                    Path path = rootView;
                    return path;
                }
                rootView = next.resolve("view.groovy");
                if (Files.exists(rootView, new LinkOption[0])) {
                    Path path = rootView;
                    return path;
                }
            }
        }
        return null;
    }

    private void addOptionalFiles(Path file) throws IOException {
        ConfigFile.generateDefault(file);
        Path locDir = file.resolve("loc");
        if (!Files.exists(locDir, new LinkOption[0])) {
            Files.createDirectories(locDir, new FileAttribute[0]);
            try (PrintStream out = new PrintStream(Files.newOutputStream(locDir.resolve("README"), new OpenOption[0]), true, Constants.ENCODING);){
                out.println("If a formatter requires localization that cannot be found in strings or schema ");
                out.println("localization the format bundle can have a loc subfolder containing translations.");
                out.println("");
                out.println("The xml document created will have the xml files from loc/<currentLoc>/ added to");
                out.println("xml documentation under the /root/resources tag.");
                out.println("");
                out.println("If a localization folder is not found then the default language will be used.  ");
                out.println("if the default language also does not exist then the first localization will be used");
                out.println("but it is recommended to always have the default language localization");
                out.println("(unless language is fixed in the config.properties)");
            }
        }
    }

    private void handleRawXsl(Path uploadedFile, Path dir) throws IOException {
        Files.createDirectories(dir, new FileAttribute[0]);
        IO.moveDirectoryOrFile((Path)uploadedFile, (Path)dir.resolve("view.xsl"), (boolean)false);
    }
}

