/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.processing;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.processing.MetadataSearchAndReplace;
import org.fao.geonet.api.processing.report.MetadataReplacementProcessingReport;
import org.fao.geonet.api.processing.report.ProcessingReport;
import org.fao.geonet.api.processing.report.registry.IProcessingReportRegistry;
import org.fao.geonet.kernel.DataManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import springfox.documentation.annotations.ApiIgnore;

@RequestMapping(value={"/{portal}/api/processes", "/{portal}/api/0.1/processes"})
@Api(value="processes", tags={"processes"}, description="Processing operations")
@Controller(value="process")
public class ProcessApi {
    @Autowired
    IProcessingReportRegistry registry;
    @Autowired
    DataManager dataMan;

    @ApiOperation(value="Get current process reports", notes="When processing, the report is stored in memory and allows to retrieve progress repport during processing. Usually, process reports are returned by the synchronous processing operation.", nickname="getProcessReport")
    @RequestMapping(path={"/reports"}, method={RequestMethod.GET}, produces={"application/json"})
    @ApiResponses(value={@ApiResponse(code=200, message="List of reports returned."), @ApiResponse(code=403, message="Operation not allowed. Only authenticated user can access it.")})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="isAuthenticated()")
    public List<ProcessingReport> getProcessReport() throws Exception {
        return this.registry.get();
    }

    @ApiOperation(value="Clear process reports list", nickname="deleteProcess")
    @RequestMapping(path={"/reports"}, method={RequestMethod.DELETE}, produces={"application/json"})
    @ApiResponses(value={@ApiResponse(code=204, message="Report registry cleared."), @ApiResponse(code=403, message="Operation not allowed. Only authenticated user can access it.")})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @PreAuthorize(value="isAuthenticated()")
    public void delete() throws Exception {
        this.registry.clear();
    }

    @ApiOperation(value="Search and replace values in one or more records", nickname="searchAndReplace", notes="Service to apply replacements to one or more records.\n To define a replacement, send the following parameters:\n * mdsection-139815551372=metadata\n * mdfield-1398155513728=id.contact.individualName\n * replaceValue-1398155513728=Juan\n * searchValue-1398155513728=Jose\n\nTODO: Would be good to provide a simple object to define list of changes instead of group of parameters.<br/>Batch editing can also be used for similar works.")
    @RequestMapping(value={"/search-and-replace"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasRole('Editor')")
    @ApiResponses(value={@ApiResponse(code=200, message="Replacements applied."), @ApiResponse(code=403, message="Operation not allowed. Only Editors can access it.")})
    public MetadataReplacementProcessingReport searchAndReplace(@RequestParam(defaultValue="massive-content-update") String process, @ApiParam(value="Record UUIDs. If null current selection is used.", required=false, example="") @RequestParam(required=false) String[] uuids, @ApiParam(value="Selection bucket name", required=false) @RequestParam(required=false) String bucket, @ApiParam(value="Test only (ie. metadata are not saved). Return the report only.", required=false) @RequestParam(defaultValue="false") boolean isTesting, @ApiParam(value="Case insensitive search.", required=false) @RequestParam(defaultValue="false") boolean isCaseInsensitive, @RequestParam(defaultValue="") @ApiParam(value="'record' to apply vacuum.xsl, 'element' to remove empty elements. Empty to not affect empty elements.", required=false) String vacuumMode, @ApiIgnore @RequestParam Map<String, String> allParams, @ApiIgnore HttpSession session, @ApiIgnore HttpServletRequest request) throws Exception {
        try (ServiceContext context = ApiUtils.createServiceContext(request);){
            UserSession userSession = ApiUtils.getUserSession(session);
            try (MetadataReplacementProcessingReport report = new MetadataReplacementProcessingReport("massive-content-update");){
                Set<String> records = ApiUtils.getUuidsParameterOrSelection(uuids, bucket, userSession);
                report.setTotalRecords(records.size());
                MetadataSearchAndReplace m = new MetadataSearchAndReplace(this.dataMan, process, isTesting, isCaseInsensitive, vacuumMode, allParams, context, records, report);
                m.process();
            }
            MetadataReplacementProcessingReport metadataReplacementProcessingReport = report;
            return metadataReplacementProcessingReport;
        }
    }
}

