/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.csw.services.getrecords;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.annotation.Nonnull;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.analysis.miscellaneous.PerFieldAnalyzerWrapper;
import org.apache.lucene.document.Document;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.ChainedFilter;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.CachingWrapperFilter;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.fao.geonet.Constants;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.Util;
import org.fao.geonet.csw.common.Csw;
import org.fao.geonet.csw.common.ResultType;
import org.fao.geonet.csw.common.exceptions.CatalogException;
import org.fao.geonet.csw.common.exceptions.InvalidParameterValueEx;
import org.fao.geonet.csw.common.exceptions.NoApplicableCodeEx;
import org.fao.geonet.domain.Pair;
import org.fao.geonet.domain.ReservedOperation;
import org.fao.geonet.exceptions.SearchExpiredEx;
import org.fao.geonet.kernel.AccessManager;
import org.fao.geonet.kernel.csw.services.getrecords.FieldMapper;
import org.fao.geonet.kernel.csw.services.getrecords.ResultItem;
import org.fao.geonet.kernel.region.Region;
import org.fao.geonet.kernel.region.RegionsDAO;
import org.fao.geonet.kernel.search.DuplicateDocFilter;
import org.fao.geonet.kernel.search.IndexAndTaxonomy;
import org.fao.geonet.kernel.search.LuceneConfig;
import org.fao.geonet.kernel.search.LuceneSearcher;
import org.fao.geonet.kernel.search.LuceneUtils;
import org.fao.geonet.kernel.search.MetadataRecordSelector;
import org.fao.geonet.kernel.search.SearchManager;
import org.fao.geonet.kernel.search.facet.SummaryType;
import org.fao.geonet.kernel.search.index.GeonetworkMultiReader;
import org.fao.geonet.kernel.search.spatial.SpatialIndexWriter;
import org.fao.geonet.kernel.setting.SettingInfo;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.geotools.gml2.GMLConfiguration;
import org.geotools.gml3.GML;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Encoder;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiPolygon;
import org.springframework.context.ApplicationContext;

public class CatalogSearcher
implements MetadataRecordSelector {
    private final Set<String> _selector;
    private final Set<String> _uuidselector;
    private final GMLConfiguration _configuration;
    private Query _query;
    private Filter _filter;
    private Sort _sort;
    private LuceneSearcher.LanguageSelection _lang;
    private long _searchToken;
    private ApplicationContext _applicationContext;

    public CatalogSearcher(GMLConfiguration configuration, Set<String> selector, Set<String> uuidselector, ApplicationContext applicationContext) {
        this._selector = selector;
        this._configuration = configuration;
        this._applicationContext = applicationContext;
        this._uuidselector = uuidselector;
        this._searchToken = -1L;
    }

    public static Query getGroupsQuery(ServiceContext context) throws Exception {
        AccessManager am = (AccessManager)context.getBean(AccessManager.class);
        Set hs = am.getUserGroups(context.getUserSession(), context.getIpAddress(), false);
        BooleanQuery query = new BooleanQuery();
        BooleanClause.Occur occur = LuceneUtils.convertRequiredAndProhibitedToOccur((boolean)false, (boolean)false);
        for (Integer groupId : hs) {
            TermQuery tq = new TermQuery(new Term(ReservedOperation.view.getLuceneIndexCode(), groupId.toString()));
            query.add((Query)tq, occur);
        }
        if (context.getUserSession().getUserId() != null) {
            TermQuery tq = new TermQuery(new Term("_owner", context.getUserSession().getUserId()));
            query.add((Query)tq, occur);
        }
        return query;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Pair<Element, List<ResultItem>> search(ServiceContext context, Element filterExpr, String filterVersion, String typeName, Sort sort, ResultType resultType, int startPosition, int maxRecords, int maxHitsInSummary, String cswServiceSpecificContraint) throws CatalogException {
        Pair<Element, List<ResultItem>> pair;
        if (Log.isDebugEnabled((String)"geonetwork.csw.search")) {
            Log.debug((String)"geonetwork.csw.search", (Object)"CatalogSearch search");
        }
        Element luceneExpr = this.filterToLucene(context, filterExpr);
        if (Log.isDebugEnabled((String)"geonetwork.csw.search")) {
            Log.debug((String)"geonetwork.csw.search", (Object)("after filter2lucene:\n" + Xml.getString((Element)luceneExpr)));
        }
        if (luceneExpr != null) {
            this.checkForErrors(luceneExpr);
            this.remapFields(luceneExpr);
        }
        if (Log.isDebugEnabled((String)"geonetwork.csw.search")) {
            Log.debug((String)"geonetwork.csw.search", (Object)("after remapfields:\n" + Xml.getString((Element)luceneExpr)));
        }
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        SearchManager sm = (SearchManager)gc.getBean(SearchManager.class);
        IndexAndTaxonomy indexAndTaxonomy = null;
        try {
            if (luceneExpr != null) {
                this.convertPhrases(luceneExpr);
                if (Log.isDebugEnabled((String)"geonetwork.csw.search")) {
                    Log.debug((String)"geonetwork.csw.search", (Object)("after convertphrases:\n" + Xml.getString((Element)luceneExpr)));
                }
            }
            this._lang = LuceneSearcher.determineLanguage((ServiceContext)context, (Element)filterExpr, (SettingInfo)sm.getSettingInfo());
            indexAndTaxonomy = sm.getIndexReader(this._lang.presentationLanguage, this._searchToken);
            Log.debug((String)"geonetwork.csw.search", (Object)("Found searcher with " + indexAndTaxonomy.version + " comparing with " + this._searchToken));
            if (this._searchToken != -1L && indexAndTaxonomy.version != this._searchToken) {
                throw new SearchExpiredEx("Search has expired/timed out - start a new search");
            }
            this._searchToken = indexAndTaxonomy.version;
            GeonetworkMultiReader reader = indexAndTaxonomy.indexReader;
            pair = this.performSearch(context, luceneExpr, filterExpr, filterVersion, sort, resultType, startPosition, maxRecords, maxHitsInSummary, cswServiceSpecificContraint, reader, indexAndTaxonomy.taxonomyReader);
        }
        catch (Exception e) {
            try {
                Log.error((String)"geonetwork.csw.search", (Object)"Error while searching metadata ");
                Log.error((String)"geonetwork.csw.search", (Object)("  (C) StackTrace:\n" + Util.getStackTrace((Throwable)e)));
                throw new NoApplicableCodeEx("Raised exception while searching metadata : " + e);
            }
            catch (Throwable throwable) {
                try {
                    if (indexAndTaxonomy == null) throw throwable;
                    sm.releaseIndexReader(indexAndTaxonomy);
                    throw throwable;
                }
                catch (Exception ex) {
                    Log.error((String)"geonetwork.csw.search", (Object)"Error while releasing index searcher ", (Throwable)ex);
                }
                throw throwable;
            }
        }
        try {
            if (indexAndTaxonomy == null) return pair;
            sm.releaseIndexReader(indexAndTaxonomy);
            return pair;
        }
        catch (Exception ex) {
            Log.error((String)"geonetwork.csw.search", (Object)"Error while releasing index searcher ", (Throwable)ex);
        }
        return pair;
    }

    private LuceneConfig getLuceneConfig() {
        return (LuceneConfig)this._applicationContext.getBean(LuceneConfig.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAllUuids(int maxHits, ServiceContext context) throws Exception {
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        SearchManager sm = (SearchManager)gc.getBean(SearchManager.class);
        LuceneConfig luceneConfig = this.getLuceneConfig();
        IndexAndTaxonomy indexAndTaxonomy = sm.getIndexReader(null, this._searchToken);
        try {
            Log.debug((String)"geonetwork.csw.search", (Object)("Found searcher with " + indexAndTaxonomy.version + " comparing with " + this._searchToken));
            if (indexAndTaxonomy.version != this._searchToken && luceneConfig.useNRTManagerReopenThread() && !Boolean.parseBoolean(System.getProperty("useNRTManagerReopenThread"))) {
                throw new SearchExpiredEx("Search has expired/timed out - start a new search");
            }
            GeonetworkMultiReader _reader = indexAndTaxonomy.indexReader;
            Pair searchResults = LuceneSearcher.doSearchAndMakeSummary((int)maxHits, (int)0, (int)maxHits, (String)this._lang.presentationLanguage, (SummaryType)luceneConfig.getSummaryTypes().get(ResultType.RESULTS.toString()), (LuceneConfig)luceneConfig, (IndexReader)_reader, (Query)this._query, (Filter)this.wrapSpatialFilter(), (Sort)this._sort, null, (boolean)false);
            TopDocs tdocs = (TopDocs)searchResults.one();
            Element summary = (Element)searchResults.two();
            int numHits = Integer.parseInt(summary.getAttributeValue("count"));
            if (Log.isDebugEnabled((String)"geonetwork.csw.search")) {
                Log.debug((String)"geonetwork.csw.search", (Object)("Records matched : " + numHits));
            }
            ArrayList<String> response = new ArrayList<String>();
            for (ScoreDoc sdoc : tdocs.scoreDocs) {
                Document doc = _reader.document(sdoc.doc, this._uuidselector);
                String uuid = doc.get("_uuid");
                if (uuid == null) continue;
                response.add(uuid);
            }
            ArrayList<String> arrayList = response;
            return arrayList;
        }
        finally {
            sm.releaseIndexReader(indexAndTaxonomy);
        }
    }

    private Element filterToLucene(ServiceContext context, Element filterExpr) throws NoApplicableCodeEx {
        if (filterExpr == null) {
            return null;
        }
        Path styleSheet = context.getAppPath().resolve("xml/csw/").resolve("filter-to-lucene.xsl");
        try {
            Element result = Xml.transform((Element)filterExpr, (Path)styleSheet);
            this.removeEmptyBranches(result);
            Log.info((String)"geonetwork.csw.search", (Object)("filterToLucene result:\n" + Xml.getString((Element)result)));
            return result;
        }
        catch (Exception e) {
            context.error("Error during Filter to Lucene conversion : " + e);
            context.error("  (C) StackTrace\n" + Util.getStackTrace((Throwable)e));
            throw new NoApplicableCodeEx("Error during Filter to Lucene conversion : " + e);
        }
    }

    private void removeEmptyBranches(Element element) {
        ArrayList children = new ArrayList(element.getChildren());
        for (Element e : children) {
            this.removeEmptyBranches(e);
        }
        if (element.getChildren().isEmpty() && element.getTextTrim().isEmpty() && element.getAttribute("fld") == null && !element.getName().equals("MatchAllDocsQuery")) {
            element.detach();
        }
    }

    private void checkForErrors(Element elem) throws InvalidParameterValueEx {
        List children = elem.getChildren();
        if (elem.getName().equals("error")) {
            String type = elem.getAttributeValue("type");
            String oper = "unknown";
            if (!children.isEmpty()) {
                oper = Xml.getString((Element)((Element)children.get(0)));
            }
            throw new InvalidParameterValueEx(type, oper);
        }
        for (Element aChildren : children) {
            this.checkForErrors(aChildren);
        }
    }

    private void convertPhrases(Element elem) throws InterruptedException, IOException {
        block3: {
            block2: {
                if (!elem.getName().equals("TermQuery")) break block2;
                String field = elem.getAttributeValue("fld");
                String text = elem.getAttributeValue("txt");
                Set tokenizedFieldSet = this.getLuceneConfig().getTokenizedField();
                if (!tokenizedFieldSet.contains(field) || text.indexOf(32) == -1) break block3;
                elem.setName("PhraseQuery");
                StringTokenizer st = new StringTokenizer(text, " ");
                while (st.hasMoreTokens()) {
                    Element term = new Element("TermQuery");
                    term.setAttribute("fld", field);
                    term.setAttribute("txt", st.nextToken());
                    elem.addContent((Content)term);
                }
                break block3;
            }
            List children = elem.getChildren();
            for (Element aChildren : children) {
                this.convertPhrases(aChildren);
            }
        }
    }

    private void remapFields(Element elem) {
        String field = elem.getAttributeValue("fld");
        if (field != null) {
            String mapped;
            if (field.equals("")) {
                field = "any";
            }
            if ((mapped = this.getFieldMapper().map(field)) != null) {
                elem.setAttribute("fld", mapped);
            } else {
                Log.info((String)"geonetwork.csw.search", (Object)("Unknown queryable field : " + field));
            }
        }
        List children = elem.getChildren();
        for (Element aChildren : children) {
            this.remapFields(aChildren);
        }
    }

    private FieldMapper getFieldMapper() {
        return (FieldMapper)this._applicationContext.getBean(FieldMapper.class);
    }

    private Pair<Element, List<ResultItem>> performSearch(ServiceContext context, Element luceneExpr, @Nonnull Element filterExpr, String filterVersion, Sort sort, ResultType resultType, int startPosition, int maxRecords, int maxHitsInSummary, String cswServiceSpecificContraint, GeonetworkMultiReader reader, TaxonomyReader taxonomyReader) throws Exception {
        boolean buildSummary;
        Query data;
        if (Log.isDebugEnabled((String)"geonetwork.csw.search")) {
            Log.debug((String)"geonetwork.csw.search", (Object)"CatalogSearcher performSearch()");
        }
        if (Log.isDebugEnabled((String)"geonetwork.csw.search")) {
            Log.debug((String)"geonetwork.csw.search", (Object)("CatS performsearch: filterXpr:\n" + Xml.getString((Element)filterExpr)));
        }
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        SearchManager sm = (SearchManager)gc.getBean(SearchManager.class);
        if (luceneExpr != null) {
            if (Log.isDebugEnabled((String)"geonetwork.csw.search")) {
                Log.debug((String)"geonetwork.csw.search", (Object)("Search criteria:\n" + Xml.getString((Element)luceneExpr)));
            }
        } else if (Log.isDebugEnabled((String)"geonetwork.csw.search")) {
            Log.debug((String)"geonetwork.csw.search", (Object)"## Search criteria: null");
        }
        boolean requestedLanguageOnTop = sm.getSettingInfo().getRequestedLanguageOnTop();
        LuceneConfig luceneConfig = this.getLuceneConfig();
        if (luceneExpr == null) {
            data = null;
            Log.info((String)"geonetwork.csw.search", (Object)"LuceneSearcher made null query");
        } else {
            PerFieldAnalyzerWrapper analyzer = SearchManager.getAnalyzer((String)this._lang.analyzerLanguage, (boolean)true);
            SettingInfo.SearchRequestLanguage requestedLanguageOnly = sm.getSettingInfo().getRequestedLanguageOnly();
            data = LuceneSearcher.makeLocalisedQuery((Element)luceneExpr, (PerFieldAnalyzerWrapper)analyzer, (LuceneConfig)luceneConfig, (String)this._lang.presentationLanguage, (SettingInfo.SearchRequestLanguage)requestedLanguageOnly);
            Log.info((String)"geonetwork.csw.search", (Object)("LuceneSearcher made query:\n" + data.toString()));
        }
        Query cswCustomFilterQuery = null;
        Log.info((String)"geonetwork.csw.search", (Object)("LuceneSearcher cswCustomFilter:\n" + cswServiceSpecificContraint));
        if (StringUtils.isNotEmpty((String)cswServiceSpecificContraint)) {
            cswCustomFilterQuery = LuceneSearcher.parseLuceneQuery((String)cswServiceSpecificContraint, (LuceneConfig)luceneConfig);
            Log.info((String)"geonetwork.csw.search", (Object)("LuceneSearcher cswCustomFilterQuery:\n" + cswCustomFilterQuery));
        }
        Query groups = CatalogSearcher.getGroupsQuery(context);
        if (sort == null) {
            List<Pair> fields = Collections.singletonList(Pair.read((Object)"relevance", (Object)true));
            sort = LuceneSearcher.makeSort(fields, (String)this._lang.presentationLanguage, (boolean)requestedLanguageOnTop);
        }
        BooleanQuery query = new BooleanQuery();
        BooleanClause.Occur occur = LuceneUtils.convertRequiredAndProhibitedToOccur((boolean)true, (boolean)false);
        if (data != null) {
            query.add(data, occur);
        }
        query.add(groups, occur);
        if (cswCustomFilterQuery != null) {
            query.add(cswCustomFilterQuery, occur);
        }
        if (Log.isDebugEnabled((String)"geonetwork.csw.search")) {
            Log.debug((String)"geonetwork.csw.search", (Object)("Lucene query: " + query.toString()));
        }
        int numHits = startPosition + maxRecords;
        this.updateRegionsInSpatialFilter(context, filterExpr);
        this._filter = sm.getSpatial().filter((Query)query, Integer.MAX_VALUE, filterExpr, filterVersion);
        boolean bl = buildSummary = resultType == ResultType.RESULTS_WITH_SUMMARY;
        if (buildSummary) {
            numHits = Math.max(maxHitsInSummary, numHits);
        }
        this._query = query;
        this._sort = sort;
        ServiceConfig config = new ServiceConfig();
        String geomWkt = null;
        this._query = LuceneSearcher.appendPortalFilter((Query)this._query, (LuceneConfig)luceneConfig);
        Pair searchResults = LuceneSearcher.doSearchAndMakeSummary((int)numHits, (int)(startPosition - 1), (int)(maxRecords + startPosition - 1), (String)this._lang.presentationLanguage, (SummaryType)luceneConfig.getSummaryTypes().get(resultType.toString()), (LuceneConfig)luceneConfig, (IndexReader)reader, (Query)this._query, (Filter)this.wrapSpatialFilter(), (Sort)this._sort, (TaxonomyReader)taxonomyReader, (boolean)buildSummary);
        TopDocs hits = (TopDocs)searchResults.one();
        Element summary = (Element)searchResults.two();
        numHits = Integer.parseInt(summary.getAttributeValue("count"));
        if (Log.isDebugEnabled((String)"geonetwork.csw.search")) {
            Log.debug((String)"geonetwork.csw.search", (Object)("Records matched : " + numHits));
        }
        try (IndexAndTaxonomy indexReader = sm.getIndexReader(this._lang.presentationLanguage, this._searchToken);){
            Query loggerQuery = this._query.rewrite((IndexReader)indexReader.indexReader);
            LuceneSearcher.logSearch((ServiceContext)context, (ServiceConfig)config, (Query)loggerQuery, (int)numHits, (Sort)this._sort, geomWkt, (SearchManager)sm);
        }
        catch (Throwable x) {
            Log.warning((String)"geonetwork.search", (Object)("Error rewriting Lucene query: " + this._query));
        }
        ArrayList<ResultItem> results = new ArrayList<ResultItem>();
        int iMax = hits.scoreDocs.length;
        for (int i = 0; i < iMax; ++i) {
            Document doc = reader.document(hits.scoreDocs[i].doc, this._selector);
            String id = doc.get("_id");
            ResultItem ri = new ResultItem(id);
            results.add(ri);
            for (String field : this.getFieldMapper().getMappedFields()) {
                String value = doc.get(field);
                if (value == null) continue;
                ri.add(field, value);
            }
        }
        summary.setName("Summary");
        summary.setNamespace(Csw.NAMESPACE_GEONET);
        return Pair.read((Object)summary, results);
    }

    private Filter wrapSpatialFilter() {
        DuplicateDocFilter duplicateRemovingFilter = new DuplicateDocFilter(this._query);
        DuplicateDocFilter cFilter = null;
        if (this._filter == null) {
            cFilter = duplicateRemovingFilter;
        } else {
            Filter[] filters = new Filter[]{duplicateRemovingFilter, this._filter};
            cFilter = new ChainedFilter(filters, 1);
        }
        cFilter = new CachingWrapperFilter((Filter)cFilter);
        return cFilter;
    }

    private void updateRegionsInSpatialFilter(ServiceContext context, Element filterExpr) throws Exception {
        Collection regionDAOs = context.getApplicationContext().getBeansOfType(RegionsDAO.class).values();
        for (Element regionEl : this.lookupGeoms(filterExpr)) {
            String[] regionIds;
            Attribute attribute = regionEl.getAttribute("id", FindRegionFilterElements.namespace);
            Geometry unionedGeom = null;
            ArrayList<Geometry> geoms = new ArrayList<Geometry>();
            block1: for (String regionId : regionIds = attribute.getValue().substring("region:".length()).split("\\s*,\\s*")) {
                for (RegionsDAO regionDAO : regionDAOs) {
                    Geometry geometry = regionDAO.getGeom(context, regionId, false, Region.WGS84);
                    if (geometry == null) continue;
                    geoms.add(geometry);
                    if (unionedGeom == null) {
                        unionedGeom = geometry;
                        continue block1;
                    }
                    unionedGeom = unionedGeom.union(geometry);
                    continue block1;
                }
            }
            this.updateWithinFilter(regionEl, geoms);
            this.setGeom(regionEl, unionedGeom);
        }
    }

    private void updateWithinFilter(Element regionEl, List<Geometry> geoms) throws IOException, JDOMException {
        if (geoms.size() < 2) {
            return;
        }
        Element withinFilter = this.findWithinFilter(regionEl);
        if (withinFilter != null) {
            Element parentElement = withinFilter.getParentElement();
            int index = parentElement.indexOf((Content)withinFilter);
            ArrayList<Element> ors = new ArrayList<Element>();
            ors.add(withinFilter);
            for (Geometry geometry : geoms) {
                Element newEl = (Element)withinFilter.clone();
                FindRegionFilterElements filter = new FindRegionFilterElements();
                Iterator children = regionEl.getDescendants((org.jdom.filter.Filter)filter);
                if (children.hasNext()) {
                    this.setGeom((Element)children.next(), geometry);
                }
                ors.add(newEl);
            }
            Element or = new Element("Or", "ogc", "http://www.opengis.net/ogc");
            parentElement.setContent(index, (Content)or);
            or.addContent(ors);
        }
    }

    private Element findWithinFilter(Element element) {
        if (element == null) {
            return null;
        }
        if (element.getName().equalsIgnoreCase("WITHIN")) {
            return element;
        }
        return this.findWithinFilter(element.getParentElement());
    }

    private void setGeom(Element element, Geometry fullGeom) throws IOException, JDOMException {
        Element parentElement = element.getParentElement();
        int index = parentElement.indexOf((Content)element);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Encoder encoder = new Encoder((Configuration)this._configuration);
        encoder.setOmitXMLDeclaration(true);
        encoder.setNamespaceAware(true);
        if (fullGeom instanceof MultiPolygon) {
            encoder.encode((Object)((MultiPolygon)fullGeom), GML.MultiPolygon, (OutputStream)out);
        } else {
            Log.debug((String)"geonetwork.csw.search", (Object)("Geometry " + fullGeom.getGeometryType() + " transformed to multi-polygon"));
            encoder.encode((Object)SpatialIndexWriter.toMultiPolygon((Geometry)fullGeom), GML.MultiPolygon, (OutputStream)out);
        }
        encoder.encode((Object)SpatialIndexWriter.toMultiPolygon((Geometry)fullGeom), GML.MultiPolygon, (OutputStream)out);
        Element geomElem = org.fao.geonet.csw.common.util.Xml.loadString(out.toString(Constants.ENCODING), false);
        parentElement.setContent(index, (Content)geomElem);
    }

    private ArrayList<Element> lookupGeoms(Element filterExpr) {
        FindRegionFilterElements filter = new FindRegionFilterElements();
        Iterator children = filterExpr.getDescendants((org.jdom.filter.Filter)filter);
        ArrayList<Element> elements = new ArrayList<Element>();
        while (children.hasNext()) {
            elements.add((Element)children.next());
        }
        return elements;
    }

    private static final class FindRegionFilterElements
    implements org.jdom.filter.Filter {
        private static final Namespace namespace = Namespace.getNamespace((String)"gml", (String)"http://www.opengis.net/gml");
        private static final long serialVersionUID = 1L;

        private FindRegionFilterElements() {
        }

        public boolean matches(Object obj) {
            if (obj instanceof Element) {
                Element element = (Element)obj;
                Attribute attribute = element.getAttribute("id", namespace);
                return attribute != null && attribute.getValue() != null;
            }
            return false;
        }
    }
}

