/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.httpclient;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import java.util.concurrent.TimeUnit;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.DnsResolver;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.impl.conn.SchemeRegistryFactory;
import org.apache.http.impl.conn.SystemDefaultDnsResolver;

public class InstrumentedClientConnManager
extends PoolingClientConnectionManager {
    public InstrumentedClientConnManager(MetricRegistry metricRegistry) {
        this(metricRegistry, SchemeRegistryFactory.createDefault());
    }

    public InstrumentedClientConnManager(MetricRegistry metricsRegistry, SchemeRegistry registry) {
        this(metricsRegistry, registry, -1L, TimeUnit.MILLISECONDS);
    }

    public InstrumentedClientConnManager(MetricRegistry metricsRegistry, SchemeRegistry registry, long connTTL, TimeUnit connTTLTimeUnit) {
        this(metricsRegistry, registry, connTTL, connTTLTimeUnit, (DnsResolver)new SystemDefaultDnsResolver(), null);
    }

    public InstrumentedClientConnManager(MetricRegistry metricsRegistry, SchemeRegistry schemeRegistry, long connTTL, TimeUnit connTTLTimeUnit, DnsResolver dnsResolver, String name) {
        super(schemeRegistry, connTTL, connTTLTimeUnit, dnsResolver);
        metricsRegistry.register(MetricRegistry.name(ClientConnectionManager.class, (String[])new String[]{name, "available-connections"}), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return InstrumentedClientConnManager.this.getTotalStats().getAvailable();
            }
        });
        metricsRegistry.register(MetricRegistry.name(ClientConnectionManager.class, (String[])new String[]{name, "leased-connections"}), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return InstrumentedClientConnManager.this.getTotalStats().getLeased();
            }
        });
        metricsRegistry.register(MetricRegistry.name(ClientConnectionManager.class, (String[])new String[]{name, "max-connections"}), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return InstrumentedClientConnManager.this.getTotalStats().getMax();
            }
        });
        metricsRegistry.register(MetricRegistry.name(ClientConnectionManager.class, (String[])new String[]{name, "pending-connections"}), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return InstrumentedClientConnManager.this.getTotalStats().getPending();
            }
        });
    }
}

