/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.features;

import com.google.common.collect.FluentIterable;
import javax.inject.Named;
import javax.ws.rs.POST;
import org.jclouds.Fallbacks;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.VirtualHost;
import org.jclouds.rest.annotations.XMLResponseParser;
import org.jclouds.ultradns.ws.domain.Task;
import org.jclouds.ultradns.ws.filters.SOAPWrapWithPasswordAuth;
import org.jclouds.ultradns.ws.xml.ElementTextHandler;
import org.jclouds.ultradns.ws.xml.TaskHandler;
import org.jclouds.ultradns.ws.xml.TaskListHandler;

@RequestFilters(value={SOAPWrapWithPasswordAuth.class})
@VirtualHost
public interface TaskApi {
    @Named(value="runTest")
    @POST
    @XMLResponseParser(value=ElementTextHandler.Guid.class)
    @Payload(value="<v01:runTest><value>{value}</value></v01:runTest>")
    public String runTest(@PayloadParam(value="value") String var1);

    @Named(value="getStatusForTask")
    @POST
    @XMLResponseParser(value=TaskHandler.class)
    @Payload(value="<v01:getStatusForTask><id><guid>{guid}</guid></id></v01:getStatusForTask>")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Task get(@PayloadParam(value="guid") String var1);

    @Named(value="getAllTasks")
    @POST
    @XMLResponseParser(value=TaskListHandler.class)
    @Payload(value="<v01:getAllTasks/>")
    public FluentIterable<Task> list();

    @Named(value="clearTask")
    @POST
    @Payload(value="<v01:clearTask><id><guid>{guid}</guid></id></v01:clearTask>")
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    public void clear(@PayloadParam(value="guid") String var1);
}

