/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Date;
import org.jclouds.ultradns.ws.domain.Zone;

public final class ZoneProperties {
    private final String name;
    private final Zone.Type type;
    private final int typeCode;
    private final Date modified;
    private final int resourceRecordCount;

    private ZoneProperties(String name, Zone.Type type, int typeCode, Date modified, int resourceRecordCount) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        Preconditions.checkArgument((typeCode >= 0 ? 1 : 0) != 0, (String)"typeCode of %s must be >= 0", (Object[])new Object[]{name});
        this.typeCode = typeCode;
        this.type = (Zone.Type)((Object)Preconditions.checkNotNull((Object)((Object)type), (String)"type for %s", (Object[])new Object[]{name}));
        this.modified = (Date)Preconditions.checkNotNull((Object)modified, (String)"modified for %s", (Object[])new Object[]{name});
        this.resourceRecordCount = resourceRecordCount;
    }

    public String getName() {
        return this.name;
    }

    public Zone.Type getType() {
        return this.type;
    }

    public int getTypeCode() {
        return this.typeCode;
    }

    public Date getModified() {
        return this.modified;
    }

    public int getResourceRecordCount() {
        return this.resourceRecordCount;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ZoneProperties that = (ZoneProperties)ZoneProperties.class.cast(obj);
        return Objects.equal((Object)this.name, (Object)that.name);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("type", (Object)this.type).add("modified", (Object)this.modified).add("resourceRecordCount", this.resourceRecordCount).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return ZoneProperties.builder().from(this);
    }

    public static final class Builder {
        private String name;
        private Zone.Type type;
        private int typeCode = -1;
        private Date modified;
        private int resourceRecordCount;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder type(Zone.Type type) {
            this.type = type;
            return this;
        }

        public Builder typeCode(int typeCode) {
            this.typeCode = typeCode;
            this.type = Zone.Type.fromValue(typeCode);
            return this;
        }

        public Builder modified(Date modified) {
            this.modified = modified;
            return this;
        }

        public Builder resourceRecordCount(int resourceRecordCount) {
            this.resourceRecordCount = resourceRecordCount;
            return this;
        }

        public ZoneProperties build() {
            return new ZoneProperties(this.name, this.type, this.typeCode, this.modified, this.resourceRecordCount);
        }

        public Builder from(ZoneProperties in) {
            return this.name(in.name).typeCode(in.typeCode).type(in.type).modified(in.modified).resourceRecordCount(in.resourceRecordCount);
        }
    }
}

