/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.compute.strategy;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Atomics;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.compute.config.CustomizationResponse;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.compute.strategy.CreateNodeWithGroupEncodedIntoName;
import org.jclouds.compute.strategy.CustomizeNodeAndAddToGoodMapOrPutExceptionIntoBadMap;
import org.jclouds.compute.strategy.ListNodesStrategy;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationScope;
import org.jclouds.googlecomputeengine.GoogleComputeEngineApi;
import org.jclouds.googlecomputeengine.compute.domain.internal.RegionAndName;
import org.jclouds.googlecomputeengine.compute.functions.FirewallTagNamingConvention;
import org.jclouds.googlecomputeengine.compute.functions.Resources;
import org.jclouds.googlecomputeengine.compute.options.GoogleComputeEngineTemplateOptions;
import org.jclouds.googlecomputeengine.domain.Firewall;
import org.jclouds.googlecomputeengine.domain.Network;
import org.jclouds.googlecomputeengine.domain.Operation;
import org.jclouds.googlecomputeengine.domain.Subnetwork;
import org.jclouds.googlecomputeengine.features.FirewallApi;
import org.jclouds.googlecomputeengine.options.FirewallOptions;
import org.jclouds.logging.Logger;
import org.jclouds.ssh.SshKeyPairGenerator;

public final class CreateNodesWithGroupEncodedIntoNameThenAddToSet
extends org.jclouds.compute.strategy.impl.CreateNodesWithGroupEncodedIntoNameThenAddToSet {
    public static final String EXTERIOR_RANGE = "0.0.0.0/0";
    public static final String DEFAULT_INTERNAL_NETWORK_RANGE = "10.0.0.0/8";
    public static final String DEFAULT_NETWORK_NAME = "default";
    private final GoogleComputeEngineApi api;
    private final Resources resources;
    private final Predicate<AtomicReference<Operation>> operationDone;
    private final FirewallTagNamingConvention.Factory firewallTagNamingConvention;
    private final SshKeyPairGenerator keyGenerator;
    private final LoadingCache<RegionAndName, Optional<Subnetwork>> subnetworksMap;
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;

    @Inject
    CreateNodesWithGroupEncodedIntoNameThenAddToSet(CreateNodeWithGroupEncodedIntoName addNodeWithGroupStrategy, ListNodesStrategy listNodesStrategy, GroupNamingConvention.Factory namingConvention, @Named(value="jclouds.user-threads") ListeningExecutorService userExecutor, CustomizeNodeAndAddToGoodMapOrPutExceptionIntoBadMap.Factory customizeNodeAndAddToGoodMapOrPutExceptionIntoBadMapFactory, GoogleComputeEngineApi api, Resources resources, Predicate<AtomicReference<Operation>> operationDone, FirewallTagNamingConvention.Factory firewallTagNamingConvention, SshKeyPairGenerator keyGenerator, LoadingCache<RegionAndName, Optional<Subnetwork>> subnetworksMap) {
        super(addNodeWithGroupStrategy, listNodesStrategy, namingConvention, userExecutor, customizeNodeAndAddToGoodMapOrPutExceptionIntoBadMapFactory);
        this.api = api;
        this.resources = resources;
        this.operationDone = operationDone;
        this.firewallTagNamingConvention = firewallTagNamingConvention;
        this.keyGenerator = keyGenerator;
        this.subnetworksMap = subnetworksMap;
    }

    public Map<?, ListenableFuture<Void>> execute(String group, int count, Template template, Set<NodeMetadata> goodNodes, Map<NodeMetadata, Exception> badNodes, Multimap<NodeMetadata, CustomizationResponse> customizationResponses) {
        GoogleComputeEngineTemplateOptions templateOptions = (GoogleComputeEngineTemplateOptions)((Object)GoogleComputeEngineTemplateOptions.class.cast(template.getOptions()));
        assert (template.getOptions().equals((Object)templateOptions)) : "options didn't clone properly";
        this.configureNetworking(group, templateOptions, template.getLocation());
        templateOptions.userMetadata("jclouds-group", group);
        if (templateOptions.autoCreateKeyPair() && Strings.isNullOrEmpty((String)templateOptions.getPublicKey())) {
            this.logger.debug(">> creating default keypair...", new Object[0]);
            Map defaultKeys = (Map)this.keyGenerator.get();
            templateOptions.authorizePublicKey((String)defaultKeys.get("public"));
            templateOptions.overrideLoginPrivateKey((String)defaultKeys.get("private"));
        }
        if (templateOptions.getRunScript() != null && templateOptions.getLoginPrivateKey() == null) {
            this.logger.warn(">> a runScript has been configured but no SSH key has been provided. Authentication will delegate to the ssh-agent", new Object[0]);
        }
        return super.execute(group, count, template, goodNodes, badNodes, customizationResponses);
    }

    private void configureNetworking(String group, GoogleComputeEngineTemplateOptions options, Location location) {
        String networkName = null;
        Network network = null;
        if (options.getNetworks().isEmpty()) {
            networkName = DEFAULT_NETWORK_NAME;
        } else {
            Iterator iterator = options.getNetworks().iterator();
            networkName = CreateNodesWithGroupEncodedIntoNameThenAddToSet.nameFromNetworkString((String)iterator.next());
            Preconditions.checkArgument((!iterator.hasNext() ? 1 : 0) != 0, (Object)"Error: Please specify only one network/subnetwork in TemplateOptions when using GCE.");
        }
        String region = LocationScope.ZONE == location.getScope() ? location.getParent().getId() : location.getId();
        Optional subnet = (Optional)this.subnetworksMap.getUnchecked((Object)RegionAndName.fromRegionAndName(region, networkName));
        if (subnet.isPresent()) {
            network = this.resources.network(((Subnetwork)subnet.get()).network());
            options.networks((Iterable)ImmutableSet.of((Object)((Subnetwork)subnet.get()).selfLink().toString()));
            this.logger.debug(">> attaching nodes to subnet(%s) in region(%s)", new Object[]{((Subnetwork)subnet.get()).name(), region});
        } else {
            this.logger.warn(">> subnet(%s) was not found in region(%s). Trying to find a matching legacy network...", new Object[]{networkName, region});
            network = this.api.networks().get(networkName);
            options.networks((Iterable)ImmutableSet.of((Object)network.selfLink().toString()));
            this.logger.debug(">> attaching nodes to legacy network(%s)", new Object[]{network.name()});
        }
        Preconditions.checkArgument((network != null ? 1 : 0) != 0, (String)"Error: no network with name %s was found", (Object[])new Object[]{networkName});
        this.getOrCreateFirewalls(options, network, (Optional<Subnetwork>)subnet, this.firewallTagNamingConvention.get(group));
    }

    private void getOrCreateFirewalls(GoogleComputeEngineTemplateOptions templateOptions, Network network, Optional<Subnetwork> subnet, FirewallTagNamingConvention naming) {
        int[] inboundPorts;
        LinkedHashSet tags = Sets.newLinkedHashSet((Iterable)templateOptions.getTags());
        FirewallApi firewallApi = this.api.firewalls();
        if (!templateOptions.getGroups().isEmpty()) {
            for (String firewallName : templateOptions.getGroups()) {
                Firewall firewall = firewallApi.get(firewallName);
                this.validateFirewall(firewall, network);
                if (firewall.targetTags().isEmpty()) continue;
                tags.addAll(firewall.targetTags());
            }
        }
        if ((inboundPorts = templateOptions.getInboundPorts()) != null && inboundPorts.length > 0) {
            String interiorRange;
            List<String> ports = CreateNodesWithGroupEncodedIntoNameThenAddToSet.simplifyPorts(inboundPorts);
            String name = naming.name(ports);
            Firewall firewall = firewallApi.get(name);
            AtomicReference operation = null;
            String string = interiorRange = subnet.isPresent() ? ((Subnetwork)subnet.get()).ipCidrRange() : DEFAULT_INTERNAL_NETWORK_RANGE;
            if (firewall == null) {
                ImmutableList rules = ImmutableList.of((Object)Firewall.Rule.create("tcp", ports), (Object)Firewall.Rule.create("udp", ports));
                FirewallOptions firewallOptions = new FirewallOptions().name(name).network(network.selfLink()).allowedRules((List<Firewall.Rule>)rules).sourceTags(templateOptions.getTags()).sourceRanges((Iterable<String>)ImmutableList.of((Object)interiorRange, (Object)EXTERIOR_RANGE)).targetTags((List<String>)ImmutableList.of((Object)name));
                operation = Atomics.newReference((Object)firewallApi.createInNetwork(firewallOptions.name(), network.selfLink(), firewallOptions));
                this.operationDone.apply((Object)operation);
                Preconditions.checkState((((Operation)operation.get()).httpErrorStatusCode() == null ? 1 : 0) != 0, (String)"Could not insert firewall, operation failed %s", (Object[])new Object[]{operation});
            }
            tags.add(name);
        }
        templateOptions.tags((Iterable)tags);
    }

    private void validateFirewall(Firewall firewall, Network network) {
        if (firewall == null || !firewall.network().equals(network.selfLink())) {
            throw new IllegalArgumentException(String.format("Can't find firewall %s in network %s.", firewall.name(), network));
        }
    }

    public static List<String> simplifyPorts(int[] ports) {
        if (ports == null || ports.length == 0) {
            return null;
        }
        ArrayList<String> output = new ArrayList<String>();
        Arrays.sort(ports);
        int range_start = ports[0];
        int range_end = ports[0];
        for (int i = 1; i < ports.length; ++i) {
            if (ports[i - 1] == ports[i] - 1 || ports[i - 1] == ports[i]) {
                range_end = ports[i];
                continue;
            }
            output.add(CreateNodesWithGroupEncodedIntoNameThenAddToSet.formatRange(range_start, range_end));
            range_start = ports[i];
            range_end = ports[i];
        }
        output.add(CreateNodesWithGroupEncodedIntoNameThenAddToSet.formatRange(range_start, range_end));
        return output;
    }

    private static String formatRange(int start, int finish) {
        if (start == finish) {
            return Integer.toString(start);
        }
        return String.format("%s-%s", Integer.toString(start), Integer.toString(finish));
    }

    public static String nameFromNetworkString(String networkString) {
        return networkString.substring(networkString.lastIndexOf(47) + 1);
    }
}

