/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.transport.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.mail.MessagingException;
import org.apache.soap.Constants;
import org.apache.soap.Envelope;
import org.apache.soap.SOAPException;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.encoding.soapenc.Base64;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.transport.SOAPTransport;
import org.apache.soap.transport.TransportMessage;
import org.apache.soap.util.net.HTTPUtils;

public class SOAPHTTPConnection
implements SOAPTransport {
    private BufferedReader responseReader;
    private Hashtable responseHeaders;
    private SOAPContext responseSOAPContext;
    private String httpProxyHost;
    private int httpProxyPort = 80;
    private int timeout;
    private String userName;
    private String password;
    private String proxyUserName;
    private String proxyPassword;
    private boolean maintainSession = true;
    private String cookieHeader;
    private String cookieHeader2;
    private int outputBufferSize = 512;
    private Boolean tcpNoDelay = null;

    private static String encodeAuth(String string, String string2) throws SOAPException {
        try {
            return Base64.encode((String.valueOf(string) + ":" + string2).getBytes("8859_1"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, unsupportedEncodingException.getMessage(), unsupportedEncodingException);
        }
    }

    private static String getHeaderValue(Hashtable hashtable, String string) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.equalsIgnoreCase(string)) continue;
            return (String)hashtable.get(string2);
        }
        return null;
    }

    public Hashtable getHeaders() {
        return this.responseHeaders;
    }

    public boolean getMaintainSession() {
        return this.maintainSession;
    }

    public int getOutputBufferSize() {
        return this.outputBufferSize;
    }

    public String getProxyHost() {
        return this.httpProxyHost;
    }

    public int getProxyPort() {
        return this.httpProxyPort;
    }

    public SOAPContext getResponseSOAPContext() {
        return this.responseSOAPContext;
    }

    public Boolean getTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public BufferedReader receive() {
        return this.responseReader;
    }

    public void send(URL uRL, String string, Hashtable hashtable, Envelope envelope, SOAPMappingRegistry sOAPMappingRegistry, SOAPContext sOAPContext) throws SOAPException {
        try {
            Object object;
            Object object2;
            String string2 = null;
            if (envelope != null) {
                object2 = new StringWriter();
                envelope.marshall((Writer)object2, sOAPMappingRegistry, sOAPContext);
                string2 = ((StringWriter)object2).toString();
            }
            if (hashtable == null) {
                hashtable = new Hashtable<String, String>();
            }
            if (this.maintainSession) {
                if (this.cookieHeader2 != null) {
                    hashtable.put("Cookie2", this.cookieHeader2);
                }
                if (this.cookieHeader != null) {
                    hashtable.put("Cookie", this.cookieHeader);
                }
            }
            hashtable.put("SOAPAction", string != null ? String.valueOf('\"') + string + '\"' : "");
            if (this.userName != null) {
                hashtable.put("Authorization", "Basic " + SOAPHTTPConnection.encodeAuth(this.userName, this.password));
            }
            if (this.proxyUserName != null) {
                hashtable.put("Proxy-Authorization", "Basic " + SOAPHTTPConnection.encodeAuth(this.proxyUserName, this.proxyPassword));
            }
            try {
                object = new TransportMessage(string2, sOAPContext, hashtable);
                ((TransportMessage)object).save();
                object2 = HTTPUtils.post(uRL, (TransportMessage)object, this.timeout, this.httpProxyHost, this.httpProxyPort, this.outputBufferSize, this.tcpNoDelay);
            }
            catch (MessagingException messagingException) {
                throw new IOException("Failed to encode mime multipart: " + (Object)((Object)messagingException));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new IOException("Failed to encode mime multipart: " + unsupportedEncodingException);
            }
            object = ((TransportMessage)object2).getEnvelopeReader();
            this.responseReader = object != null ? new BufferedReader((Reader)object) : null;
            this.responseSOAPContext = ((TransportMessage)object2).getSOAPContext();
            this.responseHeaders = ((TransportMessage)object2).getHeaders();
            if (this.maintainSession) {
                int n;
                String string3 = SOAPHTTPConnection.getHeaderValue(this.responseHeaders, "Set-Cookie2");
                if (string3 != null) {
                    this.cookieHeader2 = string3;
                    n = this.cookieHeader2.indexOf(59);
                    if (n != -1) {
                        this.cookieHeader2 = this.cookieHeader2.substring(0, n);
                    }
                }
                if ((string3 = SOAPHTTPConnection.getHeaderValue(this.responseHeaders, "Set-Cookie")) != null) {
                    this.cookieHeader = string3;
                    n = this.cookieHeader.indexOf(59);
                    if (n != -1) {
                        this.cookieHeader = this.cookieHeader.substring(0, n);
                    }
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, illegalArgumentException.getMessage(), illegalArgumentException);
        }
        catch (MessagingException messagingException) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, messagingException.getMessage(), messagingException);
        }
        catch (IOException iOException) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, iOException.getMessage(), iOException);
        }
    }

    public void setMaintainSession(boolean bl) {
        this.maintainSession = bl;
        if (!bl) {
            this.cookieHeader = null;
            this.cookieHeader2 = null;
        }
    }

    public void setOutputBufferSize(int n) {
        this.outputBufferSize = n;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setProxyHost(String string) {
        this.httpProxyHost = string;
    }

    public void setProxyPassword(String string) {
        this.proxyPassword = string;
    }

    public void setProxyPort(int n) {
        this.httpProxyPort = n;
    }

    public void setProxyUserName(String string) {
        this.proxyUserName = string;
    }

    public void setTcpNoDelay(Boolean bl) {
        this.tcpNoDelay = bl;
    }

    public void setTimeout(int n) {
        this.timeout = n;
    }

    public void setUserName(String string) {
        this.userName = string;
    }
}

