/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.sql.Connection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.sql.DataSource;
import jeeves.config.springutil.ServerBeanPropertyUpdater;
import jeeves.interfaces.ApplicationHandler;
import jeeves.server.JeevesEngine;
import jeeves.server.JeevesProxyInfo;
import jeeves.server.ServiceConfig;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import jeeves.server.dispatchers.ServiceManager;
import jeeves.server.sources.http.ServletPathFinder;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.Constants;
import org.fao.geonet.ContextContainer;
import org.fao.geonet.EncryptorInitializer;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.JeevesJCS;
import org.fao.geonet.Logger;
import org.fao.geonet.SystemInfo;
import org.fao.geonet.Util;
import org.fao.geonet.api.records.formatters.FormatType;
import org.fao.geonet.api.records.formatters.FormatterApi;
import org.fao.geonet.api.records.formatters.FormatterWidth;
import org.fao.geonet.api.site.LogUtils;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.domain.Pair;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.domain.Setting;
import org.fao.geonet.domain.Source;
import org.fao.geonet.domain.SourceType;
import org.fao.geonet.domain.User;
import org.fao.geonet.entitylistener.AbstractEntityListenerManager;
import org.fao.geonet.events.server.ServerStartup;
import org.fao.geonet.exceptions.OperationAbortedEx;
import org.fao.geonet.inspireatom.harvester.InspireAtomHarvesterScheduler;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.SvnManager;
import org.fao.geonet.kernel.ThesaurusManager;
import org.fao.geonet.kernel.XmlSerializer;
import org.fao.geonet.kernel.XmlSerializerSvn;
import org.fao.geonet.kernel.csw.CswHarvesterResponseExecutionService;
import org.fao.geonet.kernel.harvest.HarvestManager;
import org.fao.geonet.kernel.oaipmh.OaiPmhDispatcher;
import org.fao.geonet.kernel.search.LuceneConfig;
import org.fao.geonet.kernel.search.SearchManager;
import org.fao.geonet.kernel.setting.SettingInfo;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.kernel.thumbnail.ThumbnailMaker;
import org.fao.geonet.languages.LanguageDetector;
import org.fao.geonet.lib.DbLib;
import org.fao.geonet.notifier.MetadataNotifierControl;
import org.fao.geonet.repository.MetadataRepository;
import org.fao.geonet.repository.SettingRepository;
import org.fao.geonet.repository.SourceRepository;
import org.fao.geonet.resources.Resources;
import org.fao.geonet.util.ThreadUtils;
import org.fao.geonet.utils.IO;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.ProxyInfo;
import org.fao.geonet.wro4j.GeonetWro4jFilter;
import org.geotools.data.DataStore;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.jdom.Element;
import org.locationtech.jts.geom.MultiPolygon;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.quartz.SchedulerException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.mock.web.MockFilterChain;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockHttpSession;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.ServletWebRequest;

public class Geonetwork
implements ApplicationHandler {
    private Logger logger;
    private Path appPath;
    private SearchManager searchMan;
    private MetadataNotifierControl metadataNotifierControl;
    private ConfigurableApplicationContext _applicationContext;
    private OaiPmhDispatcher oaipmhDis;

    public String getContextName() {
        return "contextName";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GeonetContext start(Element config, ServiceContext context) throws Exception {
        boolean dbHeartBeatEnabled;
        boolean inspireEnable;
        SchemaManager schemaMan;
        SettingManager settingMan;
        String thesauriDir;
        GeonetworkDataDirectory dataDirectory;
        ServiceConfig handlerConfig;
        String baseURL;
        ConfigurableListableBeanFactory beanFactory;
        block20: {
            context.setAsThreadLocal();
            this._applicationContext = context.getApplicationContext();
            ApplicationContextHolder.set((ConfigurableApplicationContext)this._applicationContext);
            this.logger = context.getLogger();
            try {
                LogUtils.refreshLogConfiguration();
            }
            catch (OperationAbortedEx e) {
                this.logger.error("Error while setting log configuration. Check the setting in the database for logger configuration file.");
                this.logger.error(e.getMessage());
            }
            beanFactory = context.getApplicationContext().getBeanFactory();
            ServletPathFinder finder = new ServletPathFinder((ServletContext)this._applicationContext.getBean(ServletContext.class));
            this.appPath = finder.getAppPath();
            baseURL = context.getBaseUrl();
            String webappName = "";
            if (StringUtils.isNotEmpty((String)baseURL)) {
                webappName = baseURL.substring(1);
            }
            SystemInfo systemInfo = (SystemInfo)this._applicationContext.getBean(SystemInfo.class);
            String version = systemInfo.getVersion();
            String subVersion = systemInfo.getSubVersion();
            this.logger.info("Initializing GeoNetwork " + version + "." + subVersion + " ...");
            List serviceConfigElems = config.getChildren();
            handlerConfig = new ServiceConfig(serviceConfigElems);
            dataDirectory = (GeonetworkDataDirectory)this._applicationContext.getBean(GeonetworkDataDirectory.class);
            dataDirectory.init(webappName, this.appPath, handlerConfig, context.getServlet());
            String systemDataDir = handlerConfig.getMandatoryValue("geonetworkDataDir");
            thesauriDir = handlerConfig.getMandatoryValue("codeListDir");
            String luceneDir = handlerConfig.getMandatoryValue("luceneDir");
            String luceneConfigXmlFile = handlerConfig.getMandatoryValue("luceneConfig");
            this.logger.info("Data directory: " + systemDataDir);
            this.setProps(this.appPath, handlerConfig);
            this.logger.info("Initializing database password encryptor");
            EncryptorInitializer encryptorInitializer = (EncryptorInitializer)this._applicationContext.getBean(EncryptorInitializer.class);
            encryptorInitializer.init(dataDirectory);
            this.importDatabaseData(context);
            JeevesJCS.setConfigFilename((Path)this.appPath.resolve("WEB-INF/classes/cache.ccf"));
            JeevesJCS.getInstance((String)"xlink");
            JeevesJCS.getInstance((String)"XmlResolver");
            this.logger.info("  - Setting manager...");
            settingMan = (SettingManager)this._applicationContext.getBean(SettingManager.class);
            DataSource dataSource = (DataSource)context.getBean(DataSource.class);
            try (Connection conn = null;){
                conn = dataSource.getConnection();
                ThreadUtils.init((String)conn.getMetaData().getURL(), (SettingManager)settingMan);
            }
            this.logger.info("  - SRU...");
            try {
                String[] configs = new String[]{"JZkitApplicationContext.xml"};
                ClassPathXmlApplicationContext app_context = new ClassPathXmlApplicationContext(configs, (ApplicationContext)this._applicationContext);
                ContextContainer cc = (ContextContainer)this._applicationContext.getBean("ContextGateway");
                cc.setSrvctx(context);
            }
            catch (Exception e) {
                this.logger.error("     SRU initialization failed - cannot pass context to SRU subsystem, SRU searches will not work! Error is:" + Util.getStackTrace((Throwable)e));
            }
            this.logger.info("  - Schema manager...");
            Path schemaPluginsDir = dataDirectory.getSchemaPluginsDir();
            Path schemaCatalogueFile = dataDirectory.getConfigDir().resolve("schemaplugin-uri-catalog.xml");
            boolean createOrUpdateSchemaCatalog = handlerConfig.getMandatoryValue("createOrUpdateSchemaCatalog").equals("true");
            this.logger.info("\t\t\t- Schema plugins directory: " + schemaPluginsDir);
            this.logger.info("\t\t\t- Schema Catalog File     : " + schemaCatalogueFile);
            schemaMan = (SchemaManager)this._applicationContext.getBean(SchemaManager.class);
            schemaMan.configure((ApplicationContext)this._applicationContext, this.appPath, dataDirectory.getResourcesDir(), schemaCatalogueFile, schemaPluginsDir, context.getLanguage(), handlerConfig.getMandatoryValue("preferredSchema"), createOrUpdateSchemaCatalog);
            this.logger.info("  - Search...");
            LuceneConfig lc = (LuceneConfig)this._applicationContext.getBean(LuceneConfig.class);
            lc.configure(luceneConfigXmlFile);
            this.logger.info("  - Lucene configuration is:");
            this.logger.info(lc.toString());
            try {
                this._applicationContext.getBean(DataStore.class);
            }
            catch (NoSuchBeanDefinitionException e) {
                DataStore dataStore = this.createShapefileDatastore(luceneDir);
                this._applicationContext.getBeanFactory().registerSingleton("dataStore", (Object)dataStore);
                if (dataStore != null) break block20;
                throw new IllegalArgumentException("GeoTools datastore creation failed - check logs for more info/exceptions");
            }
        }
        String maxWritesInTransactionStr = handlerConfig.getMandatoryValue("maxWritesInTransaction");
        int maxWritesInTransaction = 1000;
        try {
            maxWritesInTransaction = Integer.parseInt(maxWritesInTransactionStr);
        }
        catch (NumberFormatException nfe) {
            this.logger.error("Invalid config parameter: maximum number of writes to spatial index in a transaction (maxWritesInTransaction), Using " + maxWritesInTransaction + " instead.");
        }
        SettingInfo settingInfo = (SettingInfo)context.getBean(SettingInfo.class);
        this.searchMan = (SearchManager)this._applicationContext.getBean(SearchManager.class);
        this.searchMan.init(maxWritesInTransaction);
        ServerBeanPropertyUpdater.updateURL((String)(settingInfo.getSiteUrl() + baseURL), (ApplicationContext)this._applicationContext);
        this.logger.info("  - Access manager...");
        this.logger.info("  - Xml serializer and Data manager...");
        SvnManager svnManager = (SvnManager)this._applicationContext.getBean(SvnManager.class);
        XmlSerializer xmlSerializer = (XmlSerializer)this._applicationContext.getBean(XmlSerializer.class);
        if (xmlSerializer instanceof XmlSerializerSvn && svnManager != null) {
            svnManager.setContext(context);
            Path subversionPath = dataDirectory.getMetadataRevisionDir().toAbsolutePath().normalize();
            svnManager.setSubversionPath(subversionPath.toString());
            svnManager.init();
        }
        LanguageDetector.init((Path)this.appPath.resolve((String)this._applicationContext.getBean("languageProfilesDir", String.class)));
        this.logger.info("  - Thesaurus...");
        ((ThesaurusManager)this._applicationContext.getBean(ThesaurusManager.class)).init(false, context, thesauriDir);
        this.logger.info("  - Open Archive Initiative (OAI-PMH) server...");
        this.oaipmhDis = new OaiPmhDispatcher(settingMan, schemaMan);
        GeonetContext gnContext = new GeonetContext((ApplicationContext)this._applicationContext, false);
        beanFactory.registerSingleton("serviceHandlerConfig", (Object)handlerConfig);
        beanFactory.registerSingleton("oaipmhDisatcher", (Object)this.oaipmhDis);
        ((DataManager)this._applicationContext.getBean(DataManager.class)).init(context);
        ((DataManager)this._applicationContext.getBean(DataManager.class)).refreshIndex(false);
        ((HarvestManager)this._applicationContext.getBean(HarvestManager.class)).init(context, gnContext.isReadOnly());
        ((ThumbnailMaker)this._applicationContext.getBean(ThumbnailMaker.class)).init(context);
        this.logger.info("Site ID is : " + settingMan.getSiteId());
        SourceRepository sourceRepository = (SourceRepository)this._applicationContext.getBean(SourceRepository.class);
        if (sourceRepository.findOneByUuid(settingMan.getSiteId()) == null) {
            Source source = (Source)sourceRepository.save((Object)new Source(settingMan.getSiteId(), settingMan.getSiteName(), null, SourceType.portal));
        }
        this.createSiteLogo(settingMan.getSiteId(), context, context.getAppPath());
        this.metadataNotifierControl = new MetadataNotifierControl(context);
        this.metadataNotifierControl.runOnce();
        ProxyInfo pi = JeevesProxyInfo.getInstance();
        boolean useProxy = settingMan.getValueAsBool("system/proxy/use", false);
        if (useProxy) {
            String proxyHost = settingMan.getValue("system/proxy/host");
            String proxyPort = settingMan.getValue("system/proxy/port");
            String username = settingMan.getValue("system/proxy/username");
            String password = settingMan.getValue("system/proxy/password");
            pi.setProxyInfo(proxyHost, Integer.valueOf(proxyPort).intValue(), username, password);
        }
        if (inspireEnable = settingMan.getValueAsBool("system/inspire/enable", false)) {
            String atomType = settingMan.getValue("system/inspire/atom");
            String atomSchedule = settingMan.getValue("system/inspire/atomSchedule");
            if (StringUtils.isNotEmpty((String)atomType) && StringUtils.isNotEmpty((String)atomSchedule) && atomType.equalsIgnoreCase("remote")) {
                this.logger.info("  - INSPIRE ATOM feed harvester ...");
                InspireAtomHarvesterScheduler.schedule((String)atomSchedule, (ServiceContext)context, (GeonetContext)gnContext);
            }
        }
        if (dbHeartBeatEnabled = Boolean.parseBoolean(handlerConfig.getValue("DBHeartBeatEnabled", "false"))) {
            Integer dbHeartBeatInitialDelay = Integer.parseInt(handlerConfig.getValue("DBHeartBeatInitialDelaySeconds", "5"));
            Integer dbHeartBeatFixedDelay = Integer.parseInt(handlerConfig.getValue("DBHeartBeatFixedDelaySeconds", "60"));
            this.createDBHeartBeat(gnContext, dbHeartBeatInitialDelay, dbHeartBeatFixedDelay);
        }
        this.fillCaches();
        AbstractEntityListenerManager.setSystemRunning((boolean)true);
        this._applicationContext.publishEvent((ApplicationEvent)new ServerStartup(this._applicationContext));
        return gnContext;
    }

    private void fillCaches() {
        Thread fillCaches = new Thread(new Runnable(){

            @Override
            public void run() {
                ServiceManager serviceManager = (ServiceManager)Geonetwork.this._applicationContext.getBean(ServiceManager.class);
                try (ServiceContext fillCacheServiceContext = serviceManager.createServiceContext("init.filleCaches", Geonetwork.this._applicationContext);){
                    fillCacheServiceContext.setUserSession(new UserSession());
                    FormatterApi formatService = (FormatterApi)fillCacheServiceContext.getBean(FormatterApi.class);
                    ServletContext servletContext = fillCacheServiceContext.getServlet().getServletContext();
                    fillCacheServiceContext.setAsThreadLocal();
                    ApplicationContextHolder.set((ConfigurableApplicationContext)Geonetwork.this._applicationContext);
                    GeonetWro4jFilter filter = (GeonetWro4jFilter)servletContext.getAttribute("GEONET_WRO4J_FILTER_KEY");
                    List wro4jUrls = (List)Geonetwork.this._applicationContext.getBean("wro4jUrlsToInitialize", List.class);
                    for (String wro4jUrl : wro4jUrls) {
                        Log.info((String)"geonetwork", (Object)("Initializing the WRO4J group: " + wro4jUrl + " cache"));
                        MockHttpServletRequest servletRequest = new MockHttpServletRequest(servletContext, "GET", "/static/" + wro4jUrl);
                        MockHttpServletResponse response = new MockHttpServletResponse();
                        try {
                            filter.doFilter((ServletRequest)servletRequest, (ServletResponse)response, (FilterChain)new MockFilterChain());
                        }
                        catch (Throwable t) {
                            Log.info((String)"geonetwork", (Object)("Error while initializing the WRO4J group: " + wro4jUrl + " cache"), (Throwable)t);
                        }
                    }
                    Page metadatas = ((MetadataRepository)Geonetwork.this._applicationContext.getBean(MetadataRepository.class)).findAll((Pageable)new PageRequest(0, 1));
                    if (metadatas.getNumberOfElements() > 0) {
                        Integer mdId = ((Metadata)metadatas.getContent().get(0)).getId();
                        fillCacheServiceContext.getUserSession().loginAs(new User().setName("admin").setProfile(Profile.Administrator).setUsername("admin"));
                        List formattersToInitialize = (List)Geonetwork.this._applicationContext.getBean("formattersToInitialize", List.class);
                        for (String formatterName : formattersToInitialize) {
                            Log.info((String)"geonetwork", (Object)("Initializing the Formatter with id: " + formatterName));
                            MockHttpSession servletSession = new MockHttpSession(servletContext);
                            servletSession.setAttribute("session", (Object)fillCacheServiceContext.getUserSession());
                            MockHttpServletRequest servletRequest = new MockHttpServletRequest(servletContext);
                            servletRequest.setSession((HttpSession)servletSession);
                            MockHttpServletResponse response = new MockHttpServletResponse();
                            try {
                                formatService.exec("eng", FormatType.html.toString(), mdId.toString(), null, formatterName, Boolean.TRUE.toString(), Boolean.valueOf(false), FormatterWidth._100, (NativeWebRequest)new ServletWebRequest((HttpServletRequest)servletRequest, (HttpServletResponse)response));
                            }
                            catch (Throwable t) {
                                Log.info((String)"geonetwork", (Object)("Error while initializing the Formatter with id: " + formatterName), (Throwable)t);
                            }
                        }
                    }
                }
            }
        });
        fillCaches.setDaemon(true);
        fillCaches.setName("Fill Caches Thread");
        fillCaches.setPriority(1);
        fillCaches.start();
    }

    private void importDatabaseData(ServiceContext context) {
        SettingRepository settingRepository = (SettingRepository)context.getBean(SettingRepository.class);
        long count = settingRepository.count();
        if (count == 0L) {
            try {
                EncryptorInitializer encryptorInitializer = (EncryptorInitializer)context.getBean(EncryptorInitializer.class);
                encryptorInitializer.setFirstInitialSetupFlag(true);
                List importData = (List)context.getBean("initial-data", List.class);
                DbLib dbLib = new DbLib();
                for (Pair pair : importData) {
                    ServletContext servletContext = context.getServlet().getServletContext();
                    Path appPath = context.getAppPath();
                    Path filePath = IO.toPath((String)((String)pair.one()), (String[])new String[0]);
                    String filePrefix = (String)pair.two();
                    Log.warning((String)"geonetwork.database", (Object)("Executing SQL from: " + filePath + " " + filePrefix));
                    dbLib.insertData(servletContext, context, appPath, filePath, filePrefix);
                }
                String siteUuid = UUID.randomUUID().toString();
                ((SettingManager)context.getBean(SettingManager.class)).setSiteUuid(siteUuid);
                ((JeevesEngine)context.getBean(JeevesEngine.class)).loadConfigDB((ApplicationContext)context.getApplicationContext(), -1);
            }
            catch (Throwable t) {
                Log.error((String)"geonetwork.database", (Object)"Error occurred while trying to execute SQL", (Throwable)t);
                throw new RuntimeException(t);
            }
        }
    }

    private void createDBHeartBeat(final GeonetContext gc, Integer initialDelay, Integer fixedDelay) throws SchedulerException {
        this.logger.info("creating DB heartbeat with initial delay of " + initialDelay + " s and fixed delay of " + fixedDelay + " s");
        ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);
        Runnable DBHeartBeat = new Runnable(){

            @Override
            public void run() {
                try {
                    boolean readOnly = gc.isReadOnly();
                    Geonetwork.this.logger.debug("DBHeartBeat: GN is read-only ? " + readOnly);
                    boolean canWrite = this.checkDBWrite();
                    HarvestManager hm = (HarvestManager)gc.getBean(HarvestManager.class);
                    if (readOnly && canWrite) {
                        Geonetwork.this.logger.warning("GeoNetwork can write to the database, switching to read-write mode");
                        readOnly = false;
                        gc.setReadOnly(readOnly);
                        hm.setReadOnly(readOnly);
                    } else if (!readOnly && !canWrite) {
                        Geonetwork.this.logger.warning("GeoNetwork can not write to the database, switching to read-only mode");
                        readOnly = true;
                        gc.setReadOnly(readOnly);
                        hm.setReadOnly(readOnly);
                    } else if (readOnly) {
                        Geonetwork.this.logger.info("GeoNetwork remains in read-only mode");
                    } else {
                        Geonetwork.this.logger.debug("GeoNetwork remains in read-write mode");
                    }
                }
                catch (Throwable x) {
                    Geonetwork.this.logger.error("DBHeartBeat error: " + x.getMessage() + " This error is ignored. Error details: " + Util.getStackTrace((Throwable)x));
                }
            }

            private boolean checkDBWrite() {
                SettingRepository settingsRepo = (SettingRepository)gc.getBean(SettingRepository.class);
                try {
                    Setting newSetting = (Setting)settingsRepo.save((Object)new Setting().setName("DBHeartBeat").setValue("value"));
                    settingsRepo.flush();
                    settingsRepo.delete((Object)newSetting);
                    return true;
                }
                catch (Exception x) {
                    Geonetwork.this.logger.info("DBHeartBeat Exception: " + x.getMessage());
                    return false;
                }
            }
        };
        scheduledExecutorService.scheduleWithFixedDelay(DBHeartBeat, initialDelay.intValue(), fixedDelay.intValue(), TimeUnit.SECONDS);
    }

    private void createSiteLogo(String nodeUuid, ServiceContext context, Path appPath) {
        try {
            Resources resources = (Resources)context.getBean(Resources.class);
            Path logosDir = resources.locateLogosDir(context);
            Path logo = logosDir.resolve(nodeUuid + ".png");
            if (!Files.exists(logo, new LinkOption[0])) {
                resources.copyLogo(context, "images" + File.separator + "harvesting" + File.separator + "GN3.png", nodeUuid);
            }
        }
        catch (Throwable e) {
            this.logger.error("      Error when setting the logo: " + e.getMessage());
        }
    }

    private void setProps(Path webappDir, ServiceConfig handlerConfig) {
        Path configDir = IO.toPath((String)handlerConfig.getValue("configDir"), (String[])new String[0]);
        Path schemapluginUriCatalog = configDir.resolve("schemaplugin-uri-catalog.xml");
        Path webInf = SchemaManager.registerXmlCatalogFiles((Path)webappDir, (Path)schemapluginUriCatalog);
        String mimeProp = System.getProperty("mime-mappings");
        if (mimeProp == null) {
            mimeProp = "";
        }
        if (!mimeProp.equals("")) {
            this.logger.info("Overriding mime-mappings property (was set to " + mimeProp + ")");
        }
        mimeProp = webInf.resolve("mime-types.properties").toString();
        System.setProperty("mime-mappings", mimeProp);
        this.logger.info("mime-mappings property set to " + mimeProp);
    }

    public void stop() {
        this.logger.info("Stopping geonetwork...");
        AbstractEntityListenerManager.setSystemRunning((boolean)false);
        this.logger.info("shutting down CSW HarvestResponse executionService");
        CswHarvesterResponseExecutionService.getExecutionService().shutdownNow();
        InspireAtomHarvesterScheduler.shutdown();
        this.logger.info("  - MetadataNotifier ...");
        try {
            this.metadataNotifierControl.shutDown();
        }
        catch (Exception e) {
            this.logger.error("Raised exception while stopping metadatanotifier");
            this.logger.error("  Exception : " + e);
            this.logger.error("  Message   : " + e.getMessage());
            this.logger.error("  Stack     : " + Util.getStackTrace((Throwable)e));
        }
        this.logger.info("  - Harvest Manager...");
        ((HarvestManager)this._applicationContext.getBean(HarvestManager.class)).shutdown();
        this.oaipmhDis.shutdown();
        try {
            ((DataManager)this._applicationContext.getBean(DataManager.class)).destroy();
        }
        catch (Exception e) {
            this.logger.error("Raised exception while stopping data manager");
            this.logger.error((Throwable)e);
        }
    }

    private DataStore createShapefileDatastore(String indexDir) throws Exception {
        File file = new File(indexDir + "/" + "spatialindex" + ".shp");
        if (!file.getParentFile().mkdirs() && !file.getParentFile().exists()) {
            throw new RuntimeException("Unable to create the spatial index (shapefile) directory: " + file.getParentFile());
        }
        if (!file.exists()) {
            this.logger.info("Creating shapefile " + file.getAbsolutePath());
        } else {
            this.logger.info("Using shapefile " + file.getAbsolutePath());
        }
        ShapefileDataStore ids = new ShapefileDataStore(file.toURI().toURL());
        ids.setFidIndexed(false);
        ids.setNamespaceURI("http://geonetwork.org");
        ids.setMemoryMapped(false);
        ids.setCharset(Charset.forName(Constants.ENCODING));
        ids.setIndexCreationEnabled(false);
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:4326");
        if (crs != null) {
            ids.forceSchemaCRS(crs);
        }
        if (!file.exists()) {
            SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
            AttributeDescriptor geomDescriptor = new AttributeTypeBuilder().crs((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84).binding(MultiPolygon.class).buildDescriptor("the_geom");
            builder.setName("spatialindex");
            builder.add(geomDescriptor);
            builder.add("metadataid", String.class);
            ids.createSchema(builder.buildFeatureType());
        }
        this.logger.info("NOTE: Using shapefile for spatial index, this can be slow for larger catalogs");
        return ids;
    }
}

