/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.metadata.schema;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jeeves.interfaces.Service;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import jeeves.server.dispatchers.guiservices.XmlCacheManager;
import org.fao.geonet.domain.SchematronCriteriaType;
import org.fao.geonet.domain.SchematronRequirement;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.repository.SchematronCriteriaGroupRepository;
import org.fao.geonet.repository.specification.SchematronCriteriaGroupSpecs;
import org.fao.geonet.services.metadata.schema.SchematronService;
import org.fao.geonet.utils.Xml;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.springframework.context.ApplicationContext;
import org.springframework.data.jpa.domain.Specification;

public class SchematronCriteriaTypeService
implements Service {
    private static final String EL_TYPE = "type";
    private static final String EL_VALUE = "value";
    private static final String EL_NAME = "name";
    private static final String EL_LABEL = "label";
    private SchematronService schematronService = new SchematronService();

    public void init(Path appPath, ServiceConfig params) throws Exception {
    }

    public Element exec(Element params, ServiceContext context) throws Exception {
        SchemaManager schemaManager = (SchemaManager)context.getBean(SchemaManager.class);
        SchematronCriteriaGroupRepository criteriaGroupRepo = (SchematronCriteriaGroupRepository)context.getBean(SchematronCriteriaGroupRepository.class);
        XmlCacheManager cacheManager = (XmlCacheManager)context.getBean(XmlCacheManager.class);
        Element schematrons = this.schematronService.exec(params, context);
        Element results = new Element("response");
        Element schemas = new Element("schemas");
        results.addContent((Content)schemas);
        Element requirements = new Element("requirements");
        for (SchematronRequirement requirement : SchematronRequirement.values()) {
            requirements.addContent((Content)new Element("requirement").setText(requirement.name()));
        }
        results.addContent((Content)requirements);
        ArrayList schematronElements = Lists.newArrayList((Iterable)schematrons.getChildren());
        for (Element element : schematronElements) {
            String schemaname = element.getChildText("schemaname");
            Element schemaEl = schemas.getChild(schemaname);
            if (schemaEl == null) {
                schemaEl = new Element(schemaname);
                schemaEl.addContent((Content)new Element(EL_NAME).setText(schemaname));
                this.addCriteriaTypeDefinition(context, schemaManager, schemaEl, schemaname);
                schemas.addContent((Content)schemaEl);
            }
            element.setName("schematron");
            this.addTitleToSchematronElement(context, cacheManager, element, schemaManager.getSchemaDir(schemaname));
            schemaEl.addContent(element.detach());
            this.addSchematronGroupCount(criteriaGroupRepo, element, element.getChildText("id"));
        }
        return results;
    }

    private void addTitleToSchematronElement(ServiceContext context, XmlCacheManager cacheManager, Element element, Path schemaDir) throws JDOMException, IOException {
        String ruleName = element.getChildText("rulename");
        Element strings = this.loadTranslations(context, schemaDir, ruleName + ".xml", cacheManager);
        String title = ruleName;
        if (strings.getChild("schematron.title") != null) {
            title = strings.getChildText("schematron.title");
        }
        element.addContent((Content)new Element("title").setText(title));
    }

    private void addSchematronGroupCount(SchematronCriteriaGroupRepository criteriaGroupRepo, Element schemaEl, String id) {
        Specification spec = SchematronCriteriaGroupSpecs.hasSchematronId((int)Integer.parseInt(id));
        String count = String.valueOf(criteriaGroupRepo.count(spec));
        schemaEl.addContent((Content)new Element("groupCount").setText(count));
    }

    private void addCriteriaTypeDefinition(ServiceContext context, SchemaManager schemaManager, Element schemaEl, String schemaName) throws IOException, JDOMException {
        Path schemaDir = schemaManager.getSchemaDir(schemaName);
        Path file = schemaDir.resolve("schematron").resolve("criteria-type.xml");
        XmlCacheManager cacheManager = (XmlCacheManager)context.getBean(XmlCacheManager.class);
        Element criteriaTypeTranslations = this.loadTranslations(context, schemaDir, "criteria-type.xml", cacheManager);
        if (Files.exists(file, new LinkOption[0])) {
            Element criteriaType = Xml.loadFile((Path)file);
            criteriaType.setName("criteriaTypes");
            criteriaType.addContent((Content)this.alwaysAcceptCriteriaType());
            criteriaType.addContent((Content)this.genericXPathCriteriaType());
            List types = criteriaType.getChildren();
            for (Element type : types) {
                String name = type.getChildText(EL_NAME).toUpperCase();
                String label = criteriaTypeTranslations.getChildText(name.toLowerCase());
                if (label == null) {
                    label = name;
                }
                type.addContent((Content)new Element(EL_LABEL).setText(label));
            }
            schemaEl.addContent((Content)criteriaType);
        }
    }

    private Element loadTranslations(ServiceContext context, Path schemaDir, String translationFile, XmlCacheManager cacheManager) throws JDOMException, IOException {
        Element criteriaTypeTranslations;
        try {
            criteriaTypeTranslations = cacheManager.get((ApplicationContext)context.getApplicationContext(), true, schemaDir.resolve("loc"), translationFile, context.getLanguage(), "eng", true);
        }
        catch (NoSuchFileException e) {
            criteriaTypeTranslations = new Element("strings");
        }
        return criteriaTypeTranslations;
    }

    private Element genericXPathCriteriaType() {
        return new Element(EL_TYPE).addContent(Arrays.asList(new Element(EL_VALUE).setText("@@value@@"), new Element(EL_TYPE).setText(SchematronCriteriaType.XPATH.name()), new Element(EL_NAME).setText(SchematronCriteriaType.XPATH.name())));
    }

    private Element alwaysAcceptCriteriaType() {
        return new Element(EL_TYPE).addContent(Arrays.asList(new Element(EL_TYPE).setText(SchematronCriteriaType.ALWAYS_ACCEPT.name()), new Element(EL_NAME).setText(SchematronCriteriaType.ALWAYS_ACCEPT.name())));
    }
}

