/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.guiservices.metadata;

import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import jeeves.interfaces.Service;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import jeeves.server.dispatchers.ServiceManager;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.Constants;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.Util;
import org.fao.geonet.constants.Edit;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.exceptions.MetadataNotFoundEx;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.kernel.RelatedMetadata;
import org.fao.geonet.repository.MetadataRepository;
import org.fao.geonet.services.Utils;
import org.fao.geonet.utils.Xml;
import org.jdom.Element;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@Qualifier(value="getRelated")
public class GetRelated
implements Service,
RelatedMetadata {
    private static int maxRecords = 1000;

    public void init(Path appPath, ServiceConfig config) throws Exception {
    }

    @RequestMapping(value={"/{portal}/{lang}/xml.relation"})
    public HttpEntity<byte[]> exec(@PathVariable String lang, @RequestParam(required=false) Integer id, @RequestParam(required=false) String uuid, @RequestParam(defaultValue="") String type, @RequestParam(defaultValue="1") int from, @RequestParam(defaultValue="-1") int to, boolean fast, HttpServletRequest request) throws Exception {
        if (to < 0) {
            to = maxRecords;
        }
        ConfigurableApplicationContext appContext = ApplicationContextHolder.get();
        ServiceManager serviceManager = (ServiceManager)appContext.getBean(ServiceManager.class);
        GeonetworkDataDirectory dataDirectory = (GeonetworkDataDirectory)appContext.getBean(GeonetworkDataDirectory.class);
        MetadataRepository metadataRepository = (MetadataRepository)appContext.getBean(MetadataRepository.class);
        try (ServiceContext context = serviceManager.createServiceContext("xml.relation", lang, request);){
            String contentType;
            byte[] response;
            Metadata md;
            if (id != null) {
                md = (AbstractMetadata)metadataRepository.findOne((Serializable)id);
                if (md == null) {
                    throw new IllegalArgumentException("No Metadata found with id " + id);
                }
            } else {
                md = metadataRepository.findOneByUuid(uuid);
                if (md == null) {
                    throw new IllegalArgumentException("No Metadata found with uuid " + uuid);
                }
            }
            id = md.getId();
            uuid = md.getUuid();
            Element raw = new Element("root").addContent(Arrays.asList(new Element("gui").addContent(Arrays.asList(new Element("language").setText(lang), new Element("url").setText(context.getBaseUrl()))), this.getRelated(context, id, uuid, type, from, to, fast)));
            Path relatedXsl = dataDirectory.getWebappDir().resolve("xslt/services/metadata/relation.xsl");
            Element transform = Xml.transform((Element)raw, (Path)relatedXsl);
            HashSet acceptContentType = Sets.newHashSet((Iterator)Iterators.forEnumeration((Enumeration)request.getHeaders("Accept")));
            if (this.acceptsType(acceptContentType, "json")) {
                response = Xml.getJSON((Element)transform).getBytes(Constants.CHARSET);
                contentType = "application/json";
            } else if (acceptContentType.isEmpty() || this.acceptsType(acceptContentType, "xml") || acceptContentType.contains("*/*") || acceptContentType.contains("text/plain")) {
                response = Xml.getString((Element)transform).getBytes(Constants.CHARSET);
                contentType = "application/xml";
            } else {
                throw new IllegalArgumentException(acceptContentType + " is not supported");
            }
            HttpHeaders headers = new HttpHeaders();
            headers.add((Object)"Content-Type", (Object)contentType);
            HttpEntity httpEntity = new HttpEntity((Object)response, (MultiValueMap)headers);
            return httpEntity;
        }
    }

    private boolean acceptsType(Set<String> acceptContentType, String toCheck) {
        for (String acceptable : acceptContentType) {
            if (!acceptable.contains(toCheck)) continue;
            return true;
        }
        return false;
    }

    public Element exec(Element params, ServiceContext context) throws Exception {
        int iId;
        String uuid;
        String type = Util.getParam((Element)params, (String)"type", (String)"");
        String fast = Util.getParam((Element)params, (String)"fast", (String)"true");
        int from = Util.getParam((Element)params, (String)"from", (int)1);
        int to = Util.getParam((Element)params, (String)"to", (int)maxRecords);
        Element info = params.getChild("info", Edit.NAMESPACE);
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        DataManager dm = (DataManager)gc.getBean(DataManager.class);
        if (info == null) {
            String mdId = Utils.getIdentifierFromParameters((Element)params, (ServiceContext)context);
            if (mdId == null) {
                throw new MetadataNotFoundEx("Metadata not found.");
            }
            uuid = dm.getMetadataUuid(mdId);
            if (uuid == null) {
                throw new MetadataNotFoundEx("Metadata not found.");
            }
            iId = Integer.parseInt(mdId);
        } else {
            uuid = info.getChildText("uuid");
            iId = Integer.parseInt(info.getChildText("id"));
        }
        return this.getRelated(context, iId, uuid, type, from, to, Boolean.parseBoolean(fast));
    }

    public Element getRelated(ServiceContext context, int iId, String uuid, String type, int from_, int to_, boolean fast_) throws Exception {
        throw new RuntimeException("Not supported. Use /api/records/<uuid>/related.");
    }
}

