/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.guiservices.metadata;

import java.nio.file.Path;
import java.util.List;
import java.util.Random;
import jeeves.interfaces.Service;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.constants.Edit;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.search.MetaSearcher;
import org.fao.geonet.kernel.search.SearchManager;
import org.fao.geonet.kernel.search.SearcherType;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Content;
import org.jdom.Element;

public class GetRandom
implements Service {
    private int _maxItems;
    private long _timeBetweenUpdates;
    private String _relation;
    private String _northBL;
    private String _southBL;
    private String _eastBL;
    private String _westBL;
    private Element _response;
    private long _lastUpdateTime;
    private ServiceConfig _config;

    public void init(Path appPath, ServiceConfig config) throws Exception {
        this._config = config;
        String sMaxItems = config.getValue("maxItems", "10");
        this._maxItems = Integer.parseInt(sMaxItems);
        String sTimeBetweenUpdates = config.getValue("timeBetweenUpdates", "60");
        this._timeBetweenUpdates = Integer.parseInt(sTimeBetweenUpdates) * 1000;
        this._relation = config.getValue("relation", "overlaps");
        this._northBL = config.getValue("northBL", "90");
        this._southBL = config.getValue("southBL", "-90");
        this._eastBL = config.getValue("eastBL", "180");
        this._westBL = config.getValue("westBL", "-180");
    }

    public Element exec(Element params, ServiceContext context) throws Exception {
        if (System.currentTimeMillis() > this._lastUpdateTime + this._timeBetweenUpdates) {
            GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
            SearchManager searchMan = (SearchManager)gc.getBean(SearchManager.class);
            try (MetaSearcher searcher = searchMan.newSearcher(SearcherType.LUCENE, "lucene.xsl");){
                Element searchRequest = new Element("request");
                searchRequest.addContent((Content)new Element("buildSummary").setText("false"));
                searchRequest.addContent((Content)new Element("featured").setText("true"));
                searchRequest.addContent((Content)new Element("relation").setText(this._relation));
                searchRequest.addContent((Content)new Element("northBL").setText(this._northBL));
                searchRequest.addContent((Content)new Element("southBL").setText(this._southBL));
                searchRequest.addContent((Content)new Element("eastBL").setText(this._eastBL));
                searchRequest.addContent((Content)new Element("westBL").setText(this._westBL));
                if (Log.isDebugEnabled((String)"geonetwork.search")) {
                    Log.debug((String)"geonetwork.search", (Object)("RANDOM SEARCH CRITERIA:\n" + Xml.getString((Element)searchRequest)));
                }
                searcher.search(context, searchRequest, this._config);
                Element presentRequest = new Element("request");
                presentRequest.addContent((Content)new Element("fast").setText("true"));
                presentRequest.addContent((Content)new Element("from").setText("1"));
                presentRequest.addContent((Content)new Element("to").setText(searcher.getSize() + ""));
                List results = searcher.present(context, presentRequest, this._config).getChildren();
                this._response = new Element("response");
                for (int i = 0; i < this._maxItems && results.size() > 1; ++i) {
                    Random rnd = new Random();
                    int r = rnd.nextInt(results.size() - 1) + 1;
                    Element mdInfo = (Element)results.remove(r);
                    mdInfo.detach();
                    Element info = mdInfo.getChild("info", Edit.NAMESPACE);
                    String id = info.getChildText("id");
                    boolean forEditing = false;
                    boolean withValidationErrors = false;
                    boolean keepXlinkAttributes = false;
                    Element md = ((DataManager)gc.getBean(DataManager.class)).getMetadata(context, id, forEditing, withValidationErrors, keepXlinkAttributes);
                    this._response.addContent((Content)md);
                }
                this._lastUpdateTime = System.currentTimeMillis();
            }
        }
        return (Element)this._response.clone();
    }
}

