/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.guiservices.metadata;

import java.nio.file.Path;
import java.util.Map;
import jeeves.interfaces.Service;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.search.LuceneSearcher;
import org.fao.geonet.kernel.search.MetaSearcher;
import org.fao.geonet.kernel.search.SearchManager;
import org.fao.geonet.kernel.search.SearcherType;
import org.fao.geonet.utils.Log;
import org.jdom.Content;
import org.jdom.Element;

public class GetLatestUpdated
implements Service {
    private int _maxItems;
    private long _timeBetweenUpdates;
    private Element _response;
    private long _lastUpdateTime;
    private ServiceConfig _config;

    public void init(Path appPath, ServiceConfig config) throws Exception {
        String sMaxItems = config.getValue("maxItems", "10");
        String sTimeBetweenUpdates = config.getValue("timeBetweenUpdates", "60");
        this._timeBetweenUpdates = Long.parseLong(sTimeBetweenUpdates) * 1000L;
        this._maxItems = Integer.parseInt(sMaxItems);
        this._config = config;
    }

    public Element exec(Element params, ServiceContext context) throws Exception {
        Element _request = new Element("request");
        _request.addContent((Content)new Element("query").setText(""));
        _request.addContent((Content)new Element("sortBy").setText("changeDate"));
        _request.addContent((Content)new Element("from").setText("1"));
        _request.addContent((Content)new Element("to").setText(""));
        if (System.currentTimeMillis() > this._lastUpdateTime + this._timeBetweenUpdates) {
            GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
            SearchManager searchMan = (SearchManager)gc.getBean(SearchManager.class);
            DataManager dataMan = (DataManager)gc.getBean(DataManager.class);
            _request.getChild("to").setText("" + this._maxItems);
            this._response = new Element("response");
            Log.info((String)"geonetwork.search", (Object)"Creating latest updates searcher");
            try (MetaSearcher searcher = searchMan.newSearcher(SearcherType.LUCENE, "lucene.xsl");){
                searcher.search(context, _request, this._config);
                Map allMdInfo = ((LuceneSearcher)searcher).getAllMdInfo(context, this._maxItems);
                for (Integer id : allMdInfo.keySet()) {
                    try {
                        boolean forEditing = false;
                        boolean withValidationErrors = false;
                        boolean keepXlinkAttributes = false;
                        Element md = dataMan.getMetadata(context, id + "", forEditing, withValidationErrors, keepXlinkAttributes);
                        this._response.addContent((Content)md);
                    }
                    catch (Exception e) {
                        Log.error((String)"geonetwork.search", (Object)("Exception in latest update searcher " + e.getMessage()), (Throwable)e);
                    }
                }
            }
            this._lastUpdateTime = System.currentTimeMillis();
        }
        return (Element)this._response.clone();
    }
}

