/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.site;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.fao.geonet.NodeInfo;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.MetadataDataInfo_;
import org.fao.geonet.domain.Metadata_;
import org.fao.geonet.domain.OperationAllowedId_;
import org.fao.geonet.domain.ReservedOperation;
import org.fao.geonet.exceptions.SitemapDocumentNotFoundEx;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.repository.MetadataRepository;
import org.fao.geonet.repository.OperationAllowedRepository;
import org.fao.geonet.repository.specification.MetadataSpecs;
import org.fao.geonet.repository.specification.OperationAllowedSpecs;
import org.fao.geonet.utils.Xml;
import org.jdom.Content;
import org.jdom.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.domain.Specifications;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import springfox.documentation.annotations.ApiIgnore;

@RequestMapping(value={"/{portal}/api"})
@Api(value="site", tags={"site"}, description="Catalog operations")
@Controller(value="sitemap")
public class SitemapApi {
    private static final String FORMAT_XML = "xml";
    private static final String FORMAT_HTML = "html";
    private static final int MAX_ITEMS_PER_PAGE = 2500;
    @Autowired
    SettingManager settingManager;
    @Autowired
    NodeInfo node;
    @Autowired
    OperationAllowedRepository operationAllowedRepository;
    @Autowired
    MetadataRepository metadataRepository;
    @Autowired
    GeonetworkDataDirectory dataDirectory;

    @ApiOperation(value="robots.txt", notes="", nickname="getRobotsText")
    @RequestMapping(path={"/robots.txt"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(code=200, message="robots.txt file for SEO.")})
    public void getRobotsText(HttpServletRequest request, HttpServletResponse response) throws IOException {
        StringBuilder content = new StringBuilder(256);
        String contextPath = request.getContextPath();
        content.append("User-agent: *\n");
        content.append("Disallow: ").append(contextPath).append("/catalog/\n");
        content.append("Disallow: ").append(contextPath).append("/static/\n");
        content.append("Sitemap: ").append(this.settingManager.getNodeURL()).append("api/sitemap\n");
        content.append("Sitemap: ").append(this.settingManager.getNodeURL()).append("api/sitemap?format=rdf");
        response.setHeader("Content-Type", "text/plain");
        response.getWriter().append(content);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ApiOperation(value="Get sitemap", notes="", nickname="getSitemap")
    @RequestMapping(path={"/sitemap"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(code=200, message="Site map.")})
    public void getSitemap(@ApiParam(value="Format (xml or html).", required=false) @RequestParam(required=false, defaultValue="html") String format, @ApiParam(value="page.", required=false) @RequestParam(required=false, defaultValue="0") Integer doc, @ApiIgnore HttpServletResponse response) throws Exception {
        Element result;
        if (!format.equalsIgnoreCase(FORMAT_HTML) && !format.equalsIgnoreCase(FORMAT_XML)) {
            format = FORMAT_HTML;
        }
        Integer allGroup = 1;
        Specifications spec = Specifications.where((Specification)OperationAllowedSpecs.hasOperation((ReservedOperation)ReservedOperation.view));
        spec = spec.and(OperationAllowedSpecs.hasGroupId((int)allGroup));
        List list = this.operationAllowedRepository.findAllIds((Specification)spec, OperationAllowedId_.metadataId);
        Sort sortByChangeDateDesc = new Sort(Sort.Direction.DESC, new String[]{Metadata_.dataInfo.getName() + "." + MetadataDataInfo_.changeDate.getName()});
        long metadataCount = this.metadataRepository.count(MetadataSpecs.hasMetadataIdIn((Collection)list));
        long pages = (long)Math.ceil((double)metadataCount / 2500.0);
        if (doc > 0) {
            if ((long)doc.intValue() > pages) throw new SitemapDocumentNotFoundEx(doc.intValue());
            PageRequest pageRequest = new PageRequest(doc - 1, 2500, sortByChangeDateDesc);
            result = this.metadataRepository.findAllUuidsAndChangeDatesAndSchemaId(list, (Pageable)pageRequest);
            Element formatEl = new Element("format");
            formatEl.setText(format.toLowerCase());
            result.addContent((Content)formatEl);
        } else if (metadataCount <= 2500L) {
            result = this.metadataRepository.findAllUuidsAndChangeDatesAndSchemaId(list);
            Element formatEl = new Element("format");
            formatEl.setText(format.toLowerCase());
            result.addContent((Content)formatEl);
        } else {
            result = new Element("response");
            Element indexDocs = new Element("indexDocs");
            indexDocs.setText(pages + "");
            result.addContent((Content)indexDocs);
            Element changeDate = new Element("changeDate");
            changeDate.setText(new ISODate().toString());
            result.addContent((Content)changeDate);
        }
        Path xslt = this.dataDirectory.getWebappDir().resolve("xslt/services/sitemap/sitemap.xsl");
        Element root = new Element("root");
        Element requestElt = new Element("request");
        requestElt.addContent((Content)new Element("format").setText(format));
        root.addContent((Content)requestElt);
        root.addContent((Content)result);
        response.setHeader("Content-Type", "application/xml");
        Xml.transform((Element)root, (Path)xslt, (OutputStream)response.getOutputStream());
    }
}

