/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.reports;

import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.domain.ReservedGroup;
import org.fao.geonet.kernel.AccessManager;
import org.fao.geonet.kernel.search.LuceneSearcher;
import org.fao.geonet.utils.Log;

public final class ReportUtils {
    private ReportUtils() {
    }

    public static Set<Integer> groupsForFilter(ServiceContext context, List<Integer> groups) throws Exception {
        HashSet requestedGroups = groups == null ? new HashSet() : ImmutableSet.copyOf(groups);
        Profile userProfile = context.getUserSession().getProfile();
        if (userProfile != null && userProfile.equals((Object)Profile.Administrator)) {
            return requestedGroups;
        }
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        AccessManager am = (AccessManager)gc.getBean(AccessManager.class);
        Set userGroups = am.getUserGroups(context.getUserSession(), context.getIpAddress(), false);
        userGroups.remove(ReservedGroup.guest.getId());
        userGroups.remove(ReservedGroup.all.getId());
        userGroups.remove(ReservedGroup.intranet.getId());
        if (requestedGroups.isEmpty()) {
            return userGroups;
        }
        HashSet<Integer> filterRequestedGroups = new HashSet<Integer>();
        Iterator iterator = requestedGroups.iterator();
        while (iterator.hasNext()) {
            Integer gr = (Integer)iterator.next();
            if (!userGroups.contains(gr)) continue;
            filterRequestedGroups.add(gr);
        }
        if (!filterRequestedGroups.isEmpty()) {
            return filterRequestedGroups;
        }
        return userGroups;
    }

    public static String retrieveMetadataTitle(ServiceContext context, int metadataId) {
        return ReportUtils.retrieveMetadataIndexField(context, metadataId, "_defaultTitle");
    }

    public static String retrieveMetadataUuid(ServiceContext context, int metadataId) {
        return ReportUtils.retrieveMetadataIndexField(context, metadataId, "_uuid");
    }

    private static String retrieveMetadataIndexField(ServiceContext context, int metadataId, String fieldName) {
        String value = "";
        try {
            value = LuceneSearcher.getMetadataFromIndexById((String)context.getLanguage(), (String)(metadataId + ""), (String)fieldName);
            if (value == null) {
                value = "";
            }
        }
        catch (Exception ex) {
            Log.error((String)"geonetwork", (Object)ex.getMessage(), (Throwable)ex);
        }
        return value;
    }
}

