/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.related;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import jeeves.server.context.ServiceContext;
import jeeves.services.ReadWriteController;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.exception.NotAllowedException;
import org.fao.geonet.api.records.MetadataUtils;
import org.fao.geonet.api.records.model.related.RelatedItemType;
import org.fao.geonet.api.records.model.related.RelatedResponse;
import org.fao.geonet.api.tools.i18n.LanguageUtils;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@RequestMapping(value={"/{portal}/api/related", "/{portal}/api/0.1/related"})
@Api(value="related", tags={"related"}, description="Related records")
@Controller(value="related")
@ReadWriteController
public class Related
implements ApplicationContextAware {
    @Autowired
    LanguageUtils languageUtils;
    private ApplicationContext context;
    @Autowired
    GeonetworkDataDirectory dataDirectory;

    public synchronized void setApplicationContext(ApplicationContext context) {
        this.context = context;
    }

    @ApiOperation(value="Get record related resources for all requested metadatas", nickname="getAssociated", notes="Retrieve related services, datasets, onlines, thumbnails, sources, ... to all requested records.<br/><a href='http://geonetwork-opensource.org/manuals/trunk/eng/users/user-guide/associating-resources/index.html'>More info</a>")
    @RequestMapping(value={""}, method={RequestMethod.GET}, produces={"application/xml", "application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(code=200, message="Return the associated resources."), @ApiResponse(code=403, message="Operation not allowed. User needs to be able to view the resource.")})
    @ResponseBody
    public Map<String, RelatedResponse> getRelated(@ApiParam(value="Type of related resource. If none, all resources are returned.", required=false) @RequestParam(defaultValue="", name="type") RelatedItemType[] types, @ApiParam(value="Uuids of the metadatas you request the relations from.", required=false) @RequestParam(defaultValue="", name="uuid") String[] uuids, @ApiParam(value="Use approved version or not", required=false, defaultValue="true") @RequestParam(required=false, defaultValue="true") boolean approved, HttpServletRequest request) throws Exception {
        try (ServiceContext context = ApiUtils.createServiceContext(request);){
            Locale language = this.languageUtils.parseAcceptLanguage(request.getLocales());
            Path relatedXsl = this.dataDirectory.getWebappDir().resolve("xslt/services/metadata/relation.xsl");
            HashMap<String, RelatedResponse> res = new HashMap<String, RelatedResponse>();
            for (String uuid : uuids) {
                try {
                    AbstractMetadata md = ApiUtils.canViewRecord(uuid, approved, context);
                    Element raw = new Element("root").addContent(Arrays.asList(new Element("gui").addContent(Arrays.asList(new Element("language").setText(language.getISO3Language()), new Element("url").setText(context.getBaseUrl()))), MetadataUtils.getRelated(context, md.getId(), md.getUuid(), types, 1, 1000, true)));
                    Element transform = Xml.transform((Element)raw, (Path)relatedXsl);
                    RelatedResponse response = (RelatedResponse)Xml.unmarshall((Element)transform, RelatedResponse.class);
                    res.put(uuid, response);
                }
                catch (SecurityException e) {
                    Log.debug((String)"geonetwork.api", (Object)e.getMessage(), (Exception)e);
                    throw new NotAllowedException("Operation not allowed. User needs to be able to view the resource.");
                }
            }
            HashMap<String, RelatedResponse> hashMap = res;
            return hashMap;
        }
    }
}

